/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.AbstractCompiledBlockCallback;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.FastInvocationCallback;
import org.jruby.runtime.callback.InvocationCallback;
import org.jruby.runtime.callback.ReflectionCallback;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class InvocationCallbackFactory
extends CallbackFactory
implements Opcodes {
    private final Class type;
    final ProtectionDomain protectionDomain;
    protected final JRubyClassLoader classLoader;
    private final String typePath;
    protected final Ruby runtime;
    private static final String SUPER_CLASS = CodegenUtils.p(InvocationCallback.class);
    private static final String FAST_SUPER_CLASS = CodegenUtils.p(FastInvocationCallback.class);
    private static final String CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class, Block.class));
    private static final String FAST_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class));
    private static final String BLOCK_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class));
    private static final String BLOCK_CALL_SIG19 = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
    private static final String IRUB = CodegenUtils.p(RubyKernel.IRUBY_OBJECT);
    public static final int DISPATCHER_THREADCONTEXT_INDEX = 1;
    public static final int DISPATCHER_SELF_INDEX = 2;
    public static final int DISPATCHER_RUBYMODULE_INDEX = 3;
    public static final int DISPATCHER_METHOD_INDEX = 4;
    public static final int DISPATCHER_NAME_INDEX = 5;
    public static final int DISPATCHER_ARGS_INDEX = 6;
    public static final int DISPATCHER_CALLTYPE_INDEX = 7;
    public static final int DISPATCHER_BLOCK_INDEX = 8;
    public static final int DISPATCHER_RUNTIME_INDEX = 9;
    private static final int METHOD_ARGS_INDEX = 2;

    public InvocationCallbackFactory(Ruby runtime2, final Class type2, ClassLoader classLoader) {
        this.type = type2;
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
        this.typePath = CodegenUtils.p(type2);
        this.runtime = runtime2;
        SecurityManager sm = System.getSecurityManager();
        this.protectionDomain = sm == null ? type2.getProtectionDomain() : AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return type2.getProtectionDomain();
            }
        });
    }

    @Deprecated
    private Class getReturnClass(String method2, Class[] args2) throws Exception {
        return this.type.getMethod(method2, args2).getReturnType();
    }

    @Deprecated
    private ClassWriter createCtor(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER_CLASS, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    @Deprecated
    private ClassWriter createCtorFast(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, FAST_SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, FAST_SUPER_CLASS, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createBlockCtor(String namePath, Class fieldClass) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, CodegenUtils.p(AbstractCompiledBlockCallback.class), null);
        cw.visitField(18, "$scriptObject", CodegenUtils.ci(fieldClass), null, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(AbstractCompiledBlockCallback.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        mv.aload(0);
        mv.aload(1);
        mv.checkcast(CodegenUtils.p(fieldClass));
        mv.putfield(namePath, "$scriptObject", CodegenUtils.ci(fieldClass));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    private ClassWriter createBlockCtor19(String namePath, Class fieldClass) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, CodegenUtils.p(Object.class), new String[]{CodegenUtils.p(CompiledBlockCallback19.class)});
        cw.visitField(18, "$scriptObject", CodegenUtils.ci(fieldClass), null, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        mv.aload(0);
        mv.aload(1);
        mv.checkcast(CodegenUtils.p(fieldClass));
        mv.putfield(namePath, "$scriptObject", CodegenUtils.ci(fieldClass));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    private Class tryClass(String name2) {
        try {
            return this.classLoader.loadClass(name2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    private MethodVisitor startCall(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    @Deprecated
    private MethodVisitor startCallS(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        this.checkCast(mv, IRubyObject.class);
        return mv;
    }

    @Deprecated
    private MethodVisitor startCallFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    @Deprecated
    private MethodVisitor startDispatcher(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "callMethod", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyClass.class, Integer.TYPE, String.class, IRubyObject[].class, CallType.class, Block.class)), null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    @Deprecated
    private MethodVisitor startCallSFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, IRUB);
        return mv;
    }

    private SkinnyMethodAdapter startBlockCall(ClassWriter cw) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(4113, "call", BLOCK_CALL_SIG, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        return mv;
    }

    private SkinnyMethodAdapter startBlockCall19(ClassWriter cw) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(4113, "call", BLOCK_CALL_SIG19, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        return mv;
    }

    protected Class endCall(ClassWriter cw, MethodVisitor mv, String name2) {
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name2, code, this.protectionDomain);
    }

    @Deprecated
    public Callback getMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_0";
        String mnamePath = this.typePath + "Callback$" + method2 + "_0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String method2, Class arg1) {
        String mname = this.type.getName() + "Callback$" + method2 + "_1";
        String mnamePath = this.typePath + "Callback$" + method2 + "_1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String method2, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_2";
        String mnamePath = this.typePath + "Callback$" + method2 + "_2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, arg2, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String method2, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Callback$" + method2 + "_3";
        String mnamePath = this.typePath + "Callback$" + method2 + "_3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, arg2, arg3, Block.class};
                    Class ret = this.getReturnClass(method2, descriptor);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "S0";
        String mnamePath = this.typePath + "Callback$" + method2 + "S0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String method2, Class arg1) {
        String mname = this.type.getName() + "Callback$" + method2 + "_S1";
        String mnamePath = this.typePath + "Callback$" + method2 + "_S1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String method2, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_S2";
        String mnamePath = this.typePath + "Callback$" + method2 + "_S2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 4);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String method2, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Callback$" + method2 + "_S3";
        String mnamePath = this.typePath + "Callback$" + method2 + "_S3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getBlockMethod(String method2) {
        return new ReflectionCallback(this.type, method2, new Class[]{RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT}, false, true, Arity.fixed(2), false);
    }

    public CompiledBlockCallback getBlockCallback(String method2, Object scriptObject) {
        Class<?> typeClass = scriptObject.getClass();
        String typePathString = CodegenUtils.p(typeClass);
        String mname = typeClass.getName() + "BlockCallback$" + method2 + "xx1";
        String mnamePath = typePathString + "BlockCallback$" + method2 + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    ClassWriter cw = this.createBlockCtor(mnamePath, typeClass);
                    SkinnyMethodAdapter mv = this.startBlockCall(cw);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(typeClass));
                    mv.aload(1);
                    mv.aload(2);
                    mv.aload(3);
                    mv.invokevirtual(typePathString, method2, CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class)));
                    mv.areturn();
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                CompiledBlockCallback ic = (CompiledBlockCallback)c.getConstructor(Object.class).newInstance(scriptObject);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public CompiledBlockCallback19 getBlockCallback19(String method2, Object scriptObject) {
        Class<?> typeClass = scriptObject.getClass();
        String typePathString = CodegenUtils.p(typeClass);
        String mname = typeClass.getName() + "BlockCallback$" + method2 + "xx1";
        String mnamePath = typePathString + "BlockCallback$" + method2 + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    ClassWriter cw = this.createBlockCtor19(mnamePath, typeClass);
                    SkinnyMethodAdapter mv = this.startBlockCall19(cw);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(typeClass));
                    mv.aload(1);
                    mv.aload(2);
                    mv.aload(3);
                    mv.aload(4);
                    mv.invokevirtual(typePathString, method2, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)));
                    mv.areturn();
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                CompiledBlockCallback19 ic = (CompiledBlockCallback19)c.getConstructor(Object.class).newInstance(scriptObject);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getOptSingletonMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_Sopt";
        String mnamePath = this.typePath + "Callback$" + method2 + "_Sopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getOptMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_opt";
        String mnamePath = this.typePath + "Callback$" + method2 + "_opt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{IRubyObject[].class, Block.class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_F0";
        String mnamePath = this.typePath + "Callback$" + method2 + "_F0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class ret = this.getReturnClass(method2, new Class[0]);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, new Class[0]));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String method2, Class arg1) {
        String mname = this.type.getName() + "Callback$" + method2 + "_F1";
        String mnamePath = this.typePath + "Callback$" + method2 + "_F1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String method2, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_F2";
        String mnamePath = this.typePath + "Callback$" + method2 + "_F2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String method2, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Callback$" + method2 + "_F3";
        String mnamePath = this.typePath + "Callback$" + method2 + "_F3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_FS0";
        String mnamePath = this.typePath + "Callback$" + method2 + "_FS0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String method2, Class arg1) {
        String mname = this.type.getName() + "Callback$" + method2 + "_FS1";
        String mnamePath = this.typePath + "Callback$" + method2 + "_FS1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String method2, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_FS2";
        String mnamePath = this.typePath + "Callback$" + method2 + "_FS2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 4);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String method2, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Callback$" + method2 + "_FS3";
        String mnamePath = this.typePath + "Callback$" + method2 + "_FS3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastOptMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_Fopt";
        String mnamePath = this.typePath + "Callback$" + method2 + "_Fopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{IRubyObject[].class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitMethodInsn(182, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method2);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastOptSingletonMethod(String method2) {
        String mname = this.type.getName() + "Callback$" + method2 + "_FSopt";
        String mnamePath = this.typePath + "Callback$" + method2 + "_FSopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class};
                    Class ret = this.getReturnClass(method2, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitMethodInsn(184, this.typePath, method2, CodegenUtils.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method2);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Deprecated
    private void dispatchWithoutSTI(SkinnyMethodAdapter mv, Label afterCall) {
        mv.aload(3);
        mv.aload(5);
        mv.invokevirtual(CodegenUtils.p(RubyModule.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
        Label okCall = new Label();
        this.callMethodMissingIfNecessary(mv, afterCall, okCall);
        mv.label(okCall);
        mv.aload(1);
        mv.aload(2);
        mv.aload(3);
        mv.aload(5);
        mv.aload(6);
        mv.aload(8);
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class)));
    }

    @Deprecated
    public void callMethodMissingIfNecessary(SkinnyMethodAdapter mv, Label afterCall, Label okCall) {
        Label methodMissing = new Label();
        mv.dup();
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "isUndefined", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        mv.ifne(methodMissing);
        mv.aload(5);
        mv.ldc("method_missing");
        mv.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
        mv.ifne(okCall);
        mv.dup();
        mv.aload(1);
        mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        mv.aload(7);
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "isCallableFrom", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class, CallType.class)));
        mv.ifne(okCall);
        mv.label(methodMissing);
        mv.aload(1);
        mv.swap();
        mv.aload(2);
        mv.swap();
        mv.aload(5);
        mv.aload(6);
        mv.aload(1);
        mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        mv.aload(7);
        mv.aload(8);
        mv.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "callMethodMissing", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, DynamicMethod.class, String.class, IRubyObject[].class, IRubyObject.class, CallType.class, Block.class)));
        mv.go_to(afterCall);
    }

    @Deprecated
    private void loadArguments(MethodVisitor mv, int argsIndex, int count2, Class[] types) {
        this.loadArguments(mv, argsIndex, count2, types, false);
    }

    @Deprecated
    private void loadArguments(MethodVisitor mv, int argsIndex, int count2, Class[] types, boolean contextProvided) {
        for (int i = 0; i < count2; ++i) {
            this.loadArgument(mv, argsIndex, i, types[i + (contextProvided ? 1 : 0)]);
        }
    }

    @Deprecated
    private void loadArgument(MethodVisitor mv, int argsIndex, int argIndex, Class type1) {
        mv.visitVarInsn(25, argsIndex);
        mv.visitLdcInsn(new Integer(argIndex));
        mv.visitInsn(50);
        this.checkCast(mv, type1);
    }

    @Deprecated
    private void checkCast(MethodVisitor mv, Class clazz) {
        mv.visitTypeInsn(192, CodegenUtils.p(clazz));
    }

    @Deprecated
    private void checkArity(SkinnyMethodAdapter mv, Arity arity2) {
        if (arity2.getValue() >= 0) {
            Label arityOk = new Label();
            mv.aload(6);
            mv.arraylength();
            switch (arity2.getValue()) {
                case 3: {
                    mv.iconst_3();
                    break;
                }
                case 2: {
                    mv.iconst_2();
                    break;
                }
                case 1: {
                    mv.iconst_1();
                    break;
                }
                case 0: {
                    mv.iconst_0();
                    break;
                }
                default: {
                    mv.ldc(new Integer(arity2.getValue()));
                }
            }
            mv.if_icmpeq(arityOk);
            mv.aload(9);
            mv.aload(6);
            mv.arraylength();
            switch (arity2.getValue()) {
                case 3: {
                    mv.iconst_3();
                    break;
                }
                case 2: {
                    mv.iconst_2();
                    break;
                }
                case 1: {
                    mv.iconst_1();
                    break;
                }
                case 0: {
                    mv.iconst_0();
                    break;
                }
                default: {
                    mv.ldc(new Integer(arity2.getValue()));
                }
            }
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "newArgumentError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE)));
            mv.athrow();
            mv.label(arityOk);
        }
    }
}

