/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedMethod;
import org.jruby.internal.runtime.methods.JittedMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private DynamicMethod actualMethod;
    private final StaticScope staticScope;
    private final Node body;
    private final ArgsNode argsNode;
    private int callCount = 0;
    private final ISourcePosition position;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull);
        this.actualMethod = new InterpretedMethod(implementationClass, staticScope, body, argsNode, visibility, position);
        this.argsNode = argsNode;
        this.body = body;
        this.staticScope = staticScope;
        this.position = position;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int incrementCallCount() {
        return ++this.callCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public void switchToJitted(Script jitCompiledScript, CallConfiguration jitCallConfig) {
        this.actualMethod = new JittedMethod(this.getImplementationClass(), this.staticScope, jitCompiledScript, jitCallConfig, this.getVisibility(), this.argsNode.getArity(), this.position);
        this.callCount = -1;
    }

    private DynamicMethod tryJitReturnMethod(ThreadContext context, String name2) {
        context.getRuntime().getJITCompiler().tryJIT(this, context, name2);
        return this.actualMethod;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, args2, block);
        }
        return this.actualMethod.call(context, self, clazz, name2, args2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, args2);
        }
        return this.actualMethod.call(context, self, clazz, name2, args2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2);
        }
        return this.actualMethod.call(context, self, clazz, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, block);
        }
        return this.actualMethod.call(context, self, clazz, name2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0, block);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0, arg1);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0, arg1, block);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0, arg1, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0, arg1, arg2);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.callCount >= 0) {
            return this.tryJitReturnMethod(context, name2).call(context, self, clazz, name2, arg0, arg1, arg2, block);
        }
        return this.actualMethod.call(context, self, clazz, name2, arg0, arg1, arg2, block);
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

