/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NodeType;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class BlockBody
implements JumpTarget {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    protected final int argumentType;
    public static final BlockBody NULL_BODY = new BlockBody(0){

        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, context.getRuntime().newArrayNoCopy(args2), "yield called out of block");
        }

        public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, context.getRuntime().getNil(), "yield called out of block");
        }

        public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, context.getRuntime().newArrayNoCopyLight(arg0), "yield called out of block");
        }

        public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, context.getRuntime().newArrayNoCopyLight(arg0, arg1), "yield called out of block");
        }

        public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, context.getRuntime().newArrayNoCopyLight(arg0, arg1, arg2), "yield called out of block");
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, value2, "yield called out of block");
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, value2, "yield called out of block");
        }

        public StaticScope getStaticScope() {
            return null;
        }

        public Block cloneBlock(Binding binding2) {
            return null;
        }

        public Arity arity() {
            return null;
        }
    };

    public BlockBody(int argumentType) {
        this.argumentType = argumentType;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, RubyArray.newArrayNoCopy(context.getRuntime(), args2), null, null, true, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, args2, binding2, type2);
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public abstract IRubyObject yieldSpecific(ThreadContext var1, Binding var2, Block.Type var3);

    public abstract IRubyObject yieldSpecific(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    public abstract IRubyObject yieldSpecific(ThreadContext var1, IRubyObject var2, IRubyObject var3, Binding var4, Block.Type var5);

    public abstract IRubyObject yieldSpecific(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Binding var5, Block.Type var6);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyModule var4, boolean var5, Binding var6, Block.Type var7);

    public abstract StaticScope getStaticScope();

    public abstract Block cloneBlock(Binding var1);

    public abstract Arity arity();

    public boolean isGiven() {
        return true;
    }

    public static int asArgumentType(NodeType nodeId) {
        if (nodeId == null) {
            return 0;
        }
        switch (nodeId) {
            case ZEROARGNODE: {
                return 0;
            }
            case MULTIPLEASGNNODE: {
                return 1;
            }
            case SVALUENODE: {
                return 3;
            }
        }
        return 2;
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        switch (type2) {
            case NORMAL: {
                if (args2.length == 1 && args2[0] instanceof RubyArray) {
                    if (this.argumentType != 1 && this.argumentType != 3) break;
                    args2 = ((RubyArray)args2[0]).toJavaArray();
                    break;
                }
            }
            case PROC: {
                if (args2.length != 1 || !(args2[0] instanceof RubyArray) || this.argumentType != 1 || this.argumentType == 3) break;
                args2 = ((RubyArray)args2[0]).toJavaArray();
                break;
            }
            case LAMBDA: {
                if (this.argumentType == 2 && args2.length != 1) {
                    context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + args2.length + " for " + this.arity().getValue() + ")", new Object[0]);
                    if (args2.length == 0) {
                        args2 = context.getRuntime().getSingleNilArray();
                        break;
                    }
                    args2 = new IRubyObject[]{context.getRuntime().newArrayNoCopy(args2)};
                    break;
                }
                this.arity().checkArity(context.getRuntime(), args2);
            }
        }
        return args2;
    }

    public static NodeType getArgumentTypeWackyHack(IterNode iterNode) {
        MultipleAsgnNode multipleAsgnNode;
        NodeType argsNodeId = null;
        if (iterNode.getVarNode() != null && iterNode.getVarNode().getNodeType() != NodeType.ZEROARGNODE && (argsNodeId = iterNode.getVarNode().getNodeType()) == NodeType.MULTIPLEASGNNODE && (multipleAsgnNode = (MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() == null && multipleAsgnNode.getArgsNode() != null) {
            argsNodeId = NodeType.SVALUENODE;
        }
        return argsNodeId;
    }
}

