/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.TypeSizeMapper;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"FFI::AbstractMemory"}, parent="Object")
public abstract class AbstractMemory
extends RubyObject {
    public static final String ABSTRACT_MEMORY_RUBY_CLASS = "AbstractMemory";
    protected final long size;
    protected final MemoryIO io;

    public static RubyClass createAbstractMemoryClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(ABSTRACT_MEMORY_RUBY_CLASS, runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractMemory.class);
        result.defineAnnotatedConstants(AbstractMemory.class);
        return result;
    }

    protected static final int calculateSize(ThreadContext context, IRubyObject sizeArg) {
        if (sizeArg instanceof RubyFixnum) {
            return (int)((RubyFixnum)sizeArg).getLongValue();
        }
        if (sizeArg instanceof RubySymbol) {
            return TypeSizeMapper.getTypeSize(context, sizeArg);
        }
        if (sizeArg instanceof RubyClass && Struct.isStruct(context.getRuntime(), (RubyClass)sizeArg)) {
            return Struct.getStructSize(context.getRuntime(), sizeArg);
        }
        if (sizeArg.respondsTo("size")) {
            return (int)RubyFixnum.num2long(sizeArg.callMethod(context, "size"));
        }
        throw context.getRuntime().newArgumentError("Invalid size argument");
    }

    protected AbstractMemory(Ruby runtime2, RubyClass klass, MemoryIO io2, long size2) {
        super(runtime2, klass);
        this.io = io2;
        this.size = size2;
    }

    public final MemoryIO getMemoryIO() {
        return this.io;
    }

    protected final long getOffset(IRubyObject offset2) {
        return Util.longValue(offset2);
    }

    protected final long getSize() {
        return this.size;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return context.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        return RubyString.newString(context.getRuntime(), "AbstractMemory[size=" + this.size + "]");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMemory)) {
            return false;
        }
        AbstractMemory other = (AbstractMemory)obj;
        return other.getMemoryIO().equals(this.getMemoryIO());
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return context.getRuntime().newBoolean(this.equals(obj));
    }

    public final boolean eql(IRubyObject other) {
        return this.equals(other);
    }

    public int hashCode() {
        return 67 * this.getMemoryIO().hashCode();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.getMemoryIO().setMemory(0L, this.size, (byte)0);
        return this;
    }

    @JRubyMethod(name={"total"})
    public IRubyObject total(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.size);
    }

    protected static final void checkBounds(ThreadContext context, long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw context.getRuntime().newIndexError("Memory access offset=" + off + " size=" + len + " is out of bounds");
        }
    }

    protected final void checkBounds(ThreadContext context, long off, long len) {
        AbstractMemory.checkBounds(context, this.size, off, len);
    }

    protected final long checkBounds(ThreadContext context, IRubyObject offArg, long len) {
        long off = Util.longValue(offArg);
        AbstractMemory.checkBounds(context, this.size, off, len);
        return off;
    }

    @JRubyMethod(name={"put_int8", "put_char"}, required=2)
    public IRubyObject put_int8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 1L);
        this.getMemoryIO().putByte(this.getOffset(offset2), Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_int8", "get_char"}, required=1)
    public IRubyObject get_int8(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 1L);
        return RubyFixnum.newFixnum(context.getRuntime(), this.getMemoryIO().getByte(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"}, required=2)
    public IRubyObject put_uint8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 1L);
        this.getMemoryIO().putByte(this.getOffset(offset2), (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"}, required=1)
    public IRubyObject get_uint8(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 1L);
        byte value2 = this.getMemoryIO().getByte(this.getOffset(offset2));
        return RubyFixnum.newFixnum(context.getRuntime(), value2 < 0 ? (long)((short)((value2 & 0x7F) + 128)) : (long)value2);
    }

    @JRubyMethod(name={"put_int16", "put_short"}, required=2)
    public IRubyObject put_int16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 2L);
        this.getMemoryIO().putShort(this.getOffset(offset2), Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_int16", "get_short"}, required=1)
    public IRubyObject get_int16(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 2L);
        return RubyFixnum.newFixnum(context.getRuntime(), this.getMemoryIO().getShort(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"}, required=2)
    public IRubyObject put_uint16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 2L);
        this.getMemoryIO().putShort(this.getOffset(offset2), (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"}, required=1)
    public IRubyObject get_uint16(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 2L);
        short value2 = this.getMemoryIO().getShort(this.getOffset(offset2));
        return RubyFixnum.newFixnum(context.getRuntime(), value2 < 0 ? (long)((value2 & Short.MAX_VALUE) + 32768) : (long)value2);
    }

    @JRubyMethod(name={"put_int32", "put_int"}, required=2)
    public IRubyObject put_int32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 4L);
        this.getMemoryIO().putInt(this.getOffset(offset2), Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_int32", "get_int"}, required=1)
    public IRubyObject get_int32(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 4L);
        return RubyFixnum.newFixnum(context.getRuntime(), this.getMemoryIO().getInt(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_uint32", "put_uint"}, required=2)
    public IRubyObject put_uint32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 4L);
        this.getMemoryIO().putInt(this.getOffset(offset2), (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_uint32", "get_uint"}, required=1)
    public IRubyObject get_uint32(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 4L);
        long value2 = this.getMemoryIO().getInt(this.getOffset(offset2));
        return RubyFixnum.newFixnum(context.getRuntime(), value2 < 0L ? (value2 & Integer.MAX_VALUE) + 0x80000000L : value2);
    }

    @JRubyMethod(name={"put_int64", "put_long_long"}, required=2)
    public IRubyObject put_int64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 8L);
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_int64", "get_long_long"}, required=1)
    public IRubyObject get_int64(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 8L);
        return Util.newSigned64(context.getRuntime(), this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_uint64", "put_ulong_long"}, required=2)
    public IRubyObject put_uint64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 8L);
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"get_uint64", "get_ulong_long"}, required=1)
    public IRubyObject get_uint64(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 8L);
        return Util.newUnsigned64(context.getRuntime(), this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_long"}, required=2)
    public IRubyObject put_long(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_int32(context, offset2, value2) : this.put_int64(context, offset2, value2);
    }

    @JRubyMethod(name={"get_long"}, required=1)
    public IRubyObject get_long(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_int32(context, offset2) : this.get_int64(context, offset2);
    }

    @JRubyMethod(name={"put_ulong"}, required=2)
    public IRubyObject put_ulong(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_uint32(context, offset2, value2) : this.put_uint64(context, offset2, value2);
    }

    @JRubyMethod(name={"get_ulong"}, required=1)
    public IRubyObject get_ulong(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_uint32(context, offset2) : this.get_uint64(context, offset2);
    }

    @JRubyMethod(name={"put_float32", "put_float"}, required=2)
    public IRubyObject put_float32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 4L);
        this.getMemoryIO().putFloat(this.getOffset(offset2), Util.floatValue(value2));
        return this;
    }

    @JRubyMethod(name={"get_float32", "get_float"}, required=1)
    public IRubyObject get_float32(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 4L);
        return RubyFloat.newFloat(context.getRuntime(), this.getMemoryIO().getFloat(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"put_float64", "put_double"}, required=2)
    public IRubyObject put_float64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.checkBounds(context, offset2, 8L);
        this.getMemoryIO().putDouble(this.getOffset(offset2), Util.doubleValue(value2));
        return this;
    }

    @JRubyMethod(name={"get_float64", "get_double"}, required=1)
    public IRubyObject get_float64(ThreadContext context, IRubyObject offset2) {
        this.checkBounds(context, offset2, 8L);
        return RubyFloat.newFloat(context.getRuntime(), this.getMemoryIO().getDouble(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"get_array_of_int8", "get_array_of_char"}, required=2)
    public IRubyObject get_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 2));
        byte[] array = new byte[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFixnum.newFixnum(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_int8", "put_array_of_char"}, required=2)
    public IRubyObject put_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 2));
        byte[] array = new byte[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int8Value(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_int16", "get_array_of_short"}, required=2)
    public IRubyObject get_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 2));
        short[] array = new short[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFixnum.newFixnum(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_int16", "put_array_of_short"}, required=2)
    public IRubyObject put_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 2));
        short[] array = new short[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int16Value(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_int32", "get_array_of_int"}, required=2)
    public IRubyObject get_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 4));
        int[] array = new int[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFixnum.newFixnum(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_int32", "get_array_of_int"}, required=2)
    public IRubyObject put_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 4));
        int[] array = new int[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int32Value(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_long"}, required=2)
    public IRubyObject get_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_int32(context, offset2, length2) : this.get_array_of_int64(context, offset2, length2);
    }

    @JRubyMethod(name={"put_array_of_long"}, required=2)
    public IRubyObject put_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject arr) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_int32(context, offset2, arr) : this.put_array_of_int64(context, offset2, arr);
    }

    @JRubyMethod(name={"get_array_of_int64"}, required=2)
    public IRubyObject get_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 4));
        long[] array = new long[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFixnum.newFixnum(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_int64"}, required=2)
    public IRubyObject put_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 8));
        long[] array = new long[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int64Value(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_float32", "get_array_of_float"}, required=2)
    public IRubyObject get_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 4));
        float[] array = new float[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFloat.newFloat(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_float32", "put_array_of_float"}, required=2)
    public IRubyObject put_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 4));
        float[] array = new float[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.floatValue(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_float64", "get_array_of_double"}, required=2)
    public IRubyObject get_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int count2 = Util.int32Value(length2);
        this.checkBounds(context, offset2, (long)(count2 * 8));
        double[] array = new double[count2];
        this.getMemoryIO().get(this.getOffset(offset2), array, 0, array.length);
        Ruby runtime2 = context.getRuntime();
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFloat.newFloat(runtime2, array[i]));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_float64", "put_array_of_double"}, required=2)
    public IRubyObject put_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        this.checkBounds(context, offset2, (long)(count2 * 8));
        double[] array = new double[count2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.doubleValue(arr.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(offset2), array, 0, array.length);
        return this;
    }

    @JRubyMethod(name={"get_string"}, required=1)
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg) {
        long off = this.getOffset(offArg);
        int len = this.getMemoryIO().indexOf(off, (byte)0);
        ByteList bl = new ByteList(len);
        this.getMemoryIO().get(off, bl.unsafeBytes(), bl.begin(), len);
        bl.length(len);
        RubyString s = context.getRuntime().newString(bl);
        s.setTaint(true);
        return s;
    }

    @JRubyMethod(name={"get_string"}, required=2)
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        long off = this.getOffset(offArg);
        int maxlen = Util.int32Value(lenArg);
        int len = this.getMemoryIO().indexOf(off, (byte)0, maxlen);
        if (len < 0 || len > maxlen) {
            len = maxlen;
        }
        ByteList bl = new ByteList(len);
        this.getMemoryIO().get(off, bl.unsafeBytes(), bl.begin(), len);
        bl.length(len);
        RubyString s = context.getRuntime().newString(bl);
        s.setTaint(true);
        return s;
    }

    @JRubyMethod(name={"put_string"})
    public IRubyObject put_string(ThreadContext context, IRubyObject offArg, IRubyObject strArg) {
        long off = this.getOffset(offArg);
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().put(off, bl.unsafeBytes(), bl.begin(), bl.length());
        this.getMemoryIO().putByte(off + (long)bl.length(), (byte)0);
        return this;
    }

    @JRubyMethod(name={"get_bytes"})
    public IRubyObject get_bytes(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        long off = this.getOffset(offArg);
        int len = Util.int32Value(lenArg);
        ByteList bl = new ByteList(len);
        this.checkBounds(context, off, (long)len);
        this.getMemoryIO().get(off, bl.unsafeBytes(), bl.begin(), len);
        bl.length(len);
        RubyString s = context.getRuntime().newString(bl);
        s.setTaint(true);
        return s;
    }

    @JRubyMethod(name={"put_bytes"}, required=2, optional=2)
    public IRubyObject put_bytes(ThreadContext context, IRubyObject[] args2) {
        int len;
        int idx;
        long off = this.getOffset(args2[0]);
        ByteList bl = args2[1].convertToString().getByteList();
        int n = idx = args2.length > 2 ? Util.int32Value(args2[2]) : 0;
        if (idx < 0 || idx > bl.length()) {
            throw context.getRuntime().newRangeError("Invalid string index");
        }
        int n2 = len = args2.length > 3 ? Util.int32Value(args2[3]) : bl.length() - idx;
        if (len < 0 || len > bl.length() - idx) {
            throw context.getRuntime().newRangeError("Invalid length");
        }
        this.checkBounds(context, off, (long)len);
        this.getMemoryIO().put(off, bl.unsafeBytes(), bl.begin() + idx, len);
        return this;
    }

    @JRubyMethod(name={"get_pointer"}, required=1)
    public IRubyObject get_pointer(ThreadContext context, IRubyObject offset2) {
        return this.getPointer(context.getRuntime(), this.getOffset(offset2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        if (value2 instanceof Pointer) {
            MemoryIO ptr = ((Pointer)value2).getMemoryIO();
            if (ptr.isDirect()) {
                this.getMemoryIO().putMemoryIO(this.getOffset(offset2), ptr);
                return this;
            } else {
                if (!ptr.isNull()) throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
                this.getMemoryIO().putAddress(this.getOffset(offset2), 0L);
            }
            return this;
        } else {
            if (!value2.isNil()) throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
            this.getMemoryIO().putAddress(this.getOffset(offset2), 0L);
        }
        return this;
    }

    @JRubyMethod(name={"put_callback"}, required=3)
    public IRubyObject put_callback(ThreadContext context, IRubyObject offset2, IRubyObject proc2, IRubyObject cbInfo) {
        if (!(cbInfo instanceof CallbackInfo)) {
            throw context.getRuntime().newArgumentError("invalid CallbackInfo");
        }
        Pointer ptr = Factory.getInstance().getCallbackManager().getCallback(context.getRuntime(), (CallbackInfo)cbInfo, proc2);
        this.getMemoryIO().putMemoryIO(this.getOffset(offset2), ptr.getMemoryIO());
        return this;
    }

    @JRubyMethod(name={"__get_buffer"}, required=2)
    public IRubyObject get_buffer(ThreadContext context, IRubyObject off, IRubyObject len_) {
        int len = Util.int32Value(len_);
        ByteList bl = new ByteList(len);
        this.getMemoryIO().get(this.getOffset(off), bl.unsafeBytes(), bl.begin(), len);
        bl.length(len);
        return context.getRuntime().newString(bl);
    }

    @JRubyMethod(name={"__put_buffer"}, required=3)
    public IRubyObject put_buffer(ThreadContext context, IRubyObject off, IRubyObject str, IRubyObject len_) {
        ByteList bl = str.convertToString().getByteList();
        int len = Math.min(bl.length(), Util.int32Value(len_));
        this.getMemoryIO().put(this.getOffset(off), bl.unsafeBytes(), bl.begin(), len);
        return context.getRuntime().newFixnum(len);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return this.slice(context.getRuntime(), RubyNumeric.fix2long(value2));
    }

    protected abstract AbstractMemory slice(Ruby var1, long var2);

    protected abstract Pointer getPointer(Ruby var1, long var2);
}

