/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;

public class MethodCache {
    private static final int CACHE_SIZE = 2048;
    private static final int CACHE_MASK = 2047;
    private final CacheEntry[] cache = new CacheEntry[2048];
    private boolean initialized = false;

    public MethodCache() {
        for (int i = 0; i < 2048; ++i) {
            this.cache[i] = new CacheEntry();
        }
    }

    public void initialized() {
        this.initialized = true;
    }

    public void clearCacheForModule(RubyModule module) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < 2048; ++i) {
            if (this.cache[i].klass.get() != module) continue;
            this.cache[i].clear();
        }
    }

    public CacheEntry getMethod(RubyModule klass, String methodName) {
        return this.cache[this.cacheIndex(klass, methodName)];
    }

    public void putMethod(RubyModule klass, String methodName, DynamicMethod method) {
        this.cache[this.cacheIndex(klass, methodName)].put(klass, methodName, method);
    }

    public void removeMethod(RubyClass c, String id) {
        if (!this.initialized) {
            return;
        }
        int i = 2048;
        while (--i >= 0) {
            CacheEntry entry = this.cache[i];
            if (c != entry.klass.get() || !id.equals(entry.methodName)) continue;
            entry.methodName = null;
        }
    }

    public void removeMethod(String methodName) {
        if (!this.initialized) {
            return;
        }
        int i = 2048;
        while (--i >= 0) {
            CacheEntry entry = this.cache[i];
            if (!methodName.equals(entry.methodName)) continue;
            entry.methodName = null;
        }
    }

    public void removeClass(RubyClass klass) {
        if (!this.initialized) {
            return;
        }
        int i = 2048;
        while (--i >= 0) {
            CacheEntry entry = this.cache[i];
            if (entry.klass.get() != klass) continue;
            entry.methodName = null;
        }
    }

    private int cacheIndex(RubyModule klass, String methodName) {
        return (klass.hashCode() >> 3 ^ methodName.hashCode()) & 0x7FF;
    }

    public static class CacheEntry {
        private static final Reference NULL_REFERENCE = new WeakReference<Object>(null);
        public Reference<RubyModule> klass = NULL_REFERENCE;
        public String methodName = null;
        public Reference<DynamicMethod> method = NULL_REFERENCE;

        void put(RubyModule klass, String methodName, DynamicMethod method) {
            this.klass = new WeakReference<RubyModule>(klass);
            this.methodName = methodName;
            this.method = new WeakReference<DynamicMethod>(method);
        }

        void clear() {
            this.klass = NULL_REFERENCE;
            this.methodName = null;
            this.method = NULL_REFERENCE;
        }
    }
}

