/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;
import org.jruby.util.RubyInputStream;

public class IOHandlerUnseekable
extends IOHandlerJavaIO {
    protected InputStream input = null;
    protected OutputStream output = null;

    public IOHandlerUnseekable(Ruby runtime, InputStream inStream, OutputStream outStream) throws IOException {
        super(runtime);
        String mode = "";
        if (inStream != null) {
            this.input = inStream instanceof BufferedInputStream ? inStream : new BufferedInputStream(inStream);
            mode = mode + "r";
            this.isOpen = true;
        }
        if (outStream != null) {
            this.output = outStream;
            mode = mode + "w";
            this.isOpen = true;
        }
        if ("rw".equals(mode)) {
            this.modes = new IOModes(runtime, 2L);
            this.isOpen = true;
        } else {
            if (!this.isOpen) {
                throw new IOException("Opening nothing?");
            }
            this.modes = new IOModes(runtime, mode);
        }
        this.fileno = RubyIO.getNewFileno();
    }

    public IOHandlerUnseekable(Ruby runtime, int fileno) throws IOException {
        super(runtime);
        switch (fileno) {
            case 0: {
                this.input = new RubyInputStream(runtime.getIn());
                this.modes = new IOModes(runtime, "r");
                this.isOpen = true;
                break;
            }
            case 1: {
                this.output = runtime.getOut();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            case 2: {
                this.output = runtime.getErr();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            default: {
                throw new IOException("Bad file descriptor");
            }
        }
        this.fileno = fileno;
    }

    public IOHandlerUnseekable(Ruby runtime, int fileno, String mode) throws IOException {
        super(runtime);
        this.modes = new IOModes(runtime, mode);
        if (fileno < 0 || fileno > 2) {
            throw new IOException("Bad file descriptor");
        }
        if (this.modes.isReadable()) {
            this.input = new RubyInputStream(System.in);
            this.isOpen = true;
            if (this.modes.isWritable()) {
                this.output = System.out;
            }
        } else if (this.isWritable()) {
            this.output = System.out;
            this.isOpen = true;
        }
        this.fileno = fileno;
    }

    @Override
    public ByteList getsEntireStream() throws IOException {
        ByteList list;
        block3: {
            boolean read = false;
            list = new ByteList();
            if (this.ungotc != -1) {
                list.append(this.ungotc);
                read = true;
                this.ungotc = -1;
            }
            try {
                list.append(this.input, Integer.MAX_VALUE);
            }
            catch (EOFException e) {
                if (read) break block3;
                throw e;
            }
        }
        return list;
    }

    @Override
    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerUnseekable(this.getRuntime(), this.input, this.output);
    }

    @Override
    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        if (this.modes.isReadable() && this.input != System.in) {
            this.input.close();
        }
        if (this.modes.isWritable() && this.output != System.out && this.output != System.err) {
            this.output.close();
        }
    }

    @Override
    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWritable();
        this.output.flush();
    }

    @Override
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.input.read();
        if (c == -1) {
            return true;
        }
        this.ungetc(c);
        return false;
    }

    @Override
    public int pid() {
        return -1;
    }

    @Override
    public long pos() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void resetByModes(IOModes newModes) {
    }

    @Override
    public void rewind() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void seek(long offset, int type) throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void sync() throws IOException {
        this.output.flush();
        if (this.output instanceof FileOutputStream) {
            ((FileOutputStream)this.output).getFD().sync();
        }
    }

    protected void sysread(ByteList buf, int length) throws IOException {
        buf.append(this.input, length);
    }

    @Override
    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        return new ByteList().append(this.input, number);
    }

    @Override
    public int sysread() throws IOException {
        return this.input.read();
    }

    @Override
    public int syswrite(ByteList buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        if (buf == null || buf.realSize == 0) {
            return 0;
        }
        this.output.write(buf.bytes, buf.begin, buf.realSize);
        if (this.isSync) {
            this.sync();
        }
        return buf.realSize;
    }

    @Override
    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.output.write(c);
        if (this.isSync) {
            this.sync();
        }
        return c;
    }

    @Override
    public void truncate(long newLength) throws IOException, IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public FileChannel getFileChannel() {
        assert (false) : "No file channel for unseekable IO";
        return null;
    }
}

