/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;

public abstract class IOHandlerJavaIO
extends IOHandler {
    protected int ungotc = -1;

    protected IOHandlerJavaIO(Ruby runtime) {
        super(runtime);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteList gets(ByteList separatorString) throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        if (separatorString == null) {
            return this.getsEntireStream();
        }
        separator = separatorString == IOHandlerJavaIO.PARAGRAPH_DELIMETER ? ByteList.create("\n\n") : separatorString;
        c = (byte)this.read();
        if (c == -1) {
            return null;
        }
        buffer = new ByteList();
        block0: while (true) {
            if (c != separator.bytes[separator.begin] && c != -1) {
                buffer.append(c);
                c = (byte)this.read();
                continue;
            }
            for (i = 0; i < separator.realSize && c != -1; ++i) {
                if (c == separator.bytes[separator.begin + i]) ** break;
                continue block0;
                buffer.append(c);
                if (i >= separator.realSize - 1) continue;
                c = (byte)this.read();
            }
            break;
        }
        if (separatorString == IOHandlerJavaIO.PARAGRAPH_DELIMETER) {
            while (c == separator.bytes[separator.begin]) {
                c = (byte)this.read();
            }
            this.ungetc(c);
        }
        return buffer;
    }

    @Override
    public ByteList getsEntireStream() throws IOException {
        byte c;
        ByteList result = new ByteList();
        while ((c = (byte)this.read()) != -1) {
            result.append((int)c);
        }
        if (result.realSize == 0) {
            return null;
        }
        return result;
    }

    public int read() throws IOException {
        try {
            if (this.ungotc >= 0) {
                int c = this.ungotc;
                this.ungotc = -1;
                return c;
            }
            return this.sysread();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public int getc() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.read();
        if (c == -1) {
            return c;
        }
        return c & 0xFF;
    }

    @Override
    public ByteList read(int number) throws IOException, IOHandler.BadDescriptorException {
        try {
            if (this.ungotc >= 0) {
                ByteList buf2 = this.sysread(number - 1);
                buf2.prepend((byte)this.ungotc);
                this.ungotc = -1;
                return buf2;
            }
            return this.sysread(number);
        }
        catch (EOFException e) {
            return null;
        }
    }

    @Override
    public void ungetc(int c) {
        if (c >= 0) {
            this.ungotc = c;
        }
    }

    @Override
    public void putc(int c) throws IOException, IOHandler.BadDescriptorException {
        try {
            this.syswrite(c);
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int write(ByteList string) throws IOException, IOHandler.BadDescriptorException {
        return this.syswrite(string);
    }

    @Override
    public abstract ByteList sysread(int var1) throws IOException, IOHandler.BadDescriptorException;

    public abstract int sysread() throws IOException;

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    @Override
    public int ready() throws IOException {
        return this.getInputStream().available();
    }
}

