/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class JarredScript
implements Library {
    private final LoadServiceResource resource;

    public JarredScript(LoadServiceResource resource) {
        this.resource = resource;
    }

    public LoadServiceResource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Ruby runtime) {
        URL jarFile = this.resource.getURL();
        runtime.getJavaSupport().addToClasspath(jarFile);
        try {
            String rubyInit;
            JarInputStream in = new JarInputStream(new BufferedInputStream(jarFile.openStream()));
            Manifest mf = in.getManifest();
            if (mf != null && (rubyInit = mf.getMainAttributes().getValue("Ruby-Init")) != null) {
                JarEntry entry = in.getNextJarEntry();
                while (entry != null && !entry.getName().equals(rubyInit)) {
                    entry = in.getNextJarEntry();
                }
                if (entry != null) {
                    IRubyObject old = runtime.getGlobalVariables().isDefined("$JAR_URL") ? runtime.getGlobalVariables().get("$JAR_URL") : runtime.getNil();
                    try {
                        runtime.getGlobalVariables().set("$JAR_URL", runtime.newString("jar:" + jarFile + "!/"));
                        runtime.loadFile("init", in);
                    }
                    finally {
                        runtime.getGlobalVariables().set("$JAR_URL", old);
                    }
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }
}

