/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;

public class DynamicScope {
    private IRubyObject[] variableValues;
    private StaticScope staticScope;
    private DynamicScope parent;
    private DynamicScope bindingScope;

    public DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this(staticScope);
        this.parent = parent;
    }

    public DynamicScope(StaticScope staticScope) {
        this.staticScope = staticScope;
    }

    private void lazy() {
        if (this.variableValues == null) {
            int size = this.staticScope.getNumberOfVariables();
            this.variableValues = new IRubyObject[size];
        }
    }

    public DynamicScope cloneScope() {
        return new DynamicScope(this.staticScope, this.parent);
    }

    public String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope(this);
    }

    public IRubyObject[] getValues() {
        this.lazy();
        return this.variableValues;
    }

    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        this.lazy();
        assert (this.variableValues != null) : "No variables in getValue for off: " + offset + ", Dep: " + depth;
        assert (offset < this.variableValues.length) : "Index to big for getValue off: " + offset + ", Dep: " + depth + ", O: " + this;
        return this.variableValues[offset];
    }

    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        this.lazy();
        assert (this.variableValues != null) : "No variables in getValue for off: " + offset + ", Dep: " + depth;
        assert (offset < this.variableValues.length) : "Index to big for getValue off: " + offset + ", Dep: " + depth + ", O: " + this;
        IRubyObject value = this.variableValues[offset];
        if (value == null) {
            this.variableValues[offset] = nil;
            value = nil;
        }
        return value;
    }

    public void setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            this.parent.setValue(offset, value, depth - 1);
        } else {
            this.lazy();
            assert (offset < this.variableValues.length) : "Setting " + offset + " to " + value + ", O: " + this;
            this.variableValues[offset] = value;
        }
    }

    public void setArgValues(IRubyObject[] values, int size) {
        this.lazy();
        System.arraycopy(values, 0, this.variableValues, 0, size);
    }

    public void setBlockArgValues(IRubyObject[] blockArgValues, int size) {
        this.lazy();
        System.arraycopy(blockArgValues, 0, this.variableValues, 0, size);
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        this.lazy();
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        if (this.staticScope.getRestArg() < 0) {
            IRubyObject[] argValues = new IRubyObject[totalArgs];
            System.arraycopy(this.variableValues, 0, argValues, 0, totalArgs);
            return argValues;
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = ASTInterpreter.splatValue(restArg.getRuntime(), restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(this.variableValues, 0, argValues, 0, totalArgs);
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        return argValues;
    }

    public void growIfNeeded() {
        int dynamicSize;
        this.lazy();
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            IRubyObject[] values = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                System.arraycopy(this.variableValues, 0, values, 0, dynamicSize);
            }
            this.variableValues = values;
        }
    }

    public DynamicScope getBindingScope() {
        return this.bindingScope;
    }

    public void setBindingScope(DynamicScope bindingScope) {
        this.bindingScope = bindingScope;
    }

    public DynamicScope getNextCapturedScope() {
        return this.parent;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    private String toString(StringBuffer buf, String indent) {
        this.lazy();
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        int size = this.staticScope.getNumberOfVariables();
        if (size != 0) {
            String[] names = this.staticScope.getVariables();
            for (int i = 0; i < size - 1; ++i) {
                buf.append(names[i]).append("=");
                if (this.variableValues[i] == null) {
                    buf.append("null");
                } else {
                    buf.append(this.variableValues[i]);
                }
                buf.append(",");
            }
            buf.append(names[size - 1]).append("=");
            assert (this.variableValues.length == names.length) : "V: " + this.variableValues.length + " != N: " + names.length + " for " + buf;
            if (this.variableValues[size - 1] == null) {
                buf.append("null");
            } else {
                buf.append(this.variableValues[size - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

