/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaCallable
extends JavaAccessibleObject {
    public JavaCallable(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public final RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getArity());
    }

    public final RubyArray argument_types() {
        Class[] parameterTypes = this.parameterTypes();
        RubyArray result = this.getRuntime().newArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), parameterTypes[i]));
        }
        return result;
    }

    @Override
    public IRubyObject inspect() {
        StringBuffer result = new StringBuffer();
        result.append(this.nameOnInspection());
        Class[] parameterTypes = this.parameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    protected abstract int getArity();

    protected abstract Class[] parameterTypes();

    protected abstract int getModifiers();

    protected abstract String nameOnInspection();

    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.getModifiers()));
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result, Class klass) {
        JavaCallable.registerRubyMethods(runtime, result);
        CallbackFactory callbackFactory = runtime.callbackFactory(klass);
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
    }
}

