/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule implementationClass, RubiniusCMethod cmethod, StaticScope staticScope, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.RUBY_FULL);
        this.staticScope = staticScope;
        this.cmethod = cmethod;
        this.arity = Arity.optional();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        this.callConfig.pre(context, self, klazz, this.getArity(), name, args, block, this.staticScope, this);
        try {
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            IRubyObject iRubyObject = RubiniusMachine.INSTANCE.exec(context, self, this.cmethod.code, this.cmethod.literals, args);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            if (rj.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                return iRubyObject;
            }
            throw rj;
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
            this.callConfig.post(context);
        }
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = context.getPosition();
        runtime.callEventHooks(context, 3, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

