/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.File;
import java.io.FileOutputStream;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import org.jruby.Ruby;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;

public class DumpingInvocationMethodFactory
extends InvocationMethodFactory {
    private String dumpPath;

    public DumpingInvocationMethodFactory(String path) {
        this.dumpPath = path;
    }

    @Override
    protected Class endCall(Ruby runtime, ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return runtime.getJRubyClassLoader().defineClass(name, code);
    }
}

