/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.RUBY_FULL);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.restArg = argsNode.getRestArg();
        boolean bl = this.hasOptArgs = argsNode.getOptArgs() != null;
        assert (argsNode != null);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        RubyModule implementer = this.getImplementationClass();
        Ruby runtime = context.getRuntime();
        if (runtime.getInstanceConfig().isJitEnabled()) {
            this.runJIT(runtime, context, name);
        }
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitCallConfig.pre(context, self, implementer, this.getArity(), name, args, block, this.staticScope, this);
                IRubyObject iRubyObject = this.jitCompiledScript.run(context, self, args, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                if (rj.getTarget() == this) {
                    IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                    return iRubyObject;
                }
                throw rj;
            }
            catch (JumpException.RedoJump rj) {
                throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
            }
            finally {
                if (runtime.hasEventHooks()) {
                    this.traceReturn(context, runtime, name);
                }
                this.jitCallConfig.post(context);
            }
        }
        try {
            this.callConfig.pre(context, self, implementer, this.getArity(), name, args, block, this.staticScope, this);
            if (this.argsNode.getBlockArgNode() != null) {
                context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(runtime, block), 0);
            }
            this.getArity().checkArity(runtime, args);
            this.prepareArguments(context, runtime, args);
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            IRubyObject rj = ASTInterpreter.eval(runtime, context, this.body, self, block);
            return rj;
        }
        catch (JumpException.ReturnJump rj) {
            if (rj.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                return iRubyObject;
            }
            throw rj;
        }
        catch (JumpException.RedoJump rj) {
            throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
            this.callConfig.post(context);
        }
    }

    private void runJIT(Ruby runtime, ThreadContext context, String name) {
        if (this.callCount >= 0) {
            try {
                ++this.callCount;
                if (this.callCount >= runtime.getInstanceConfig().getJitThreshold()) {
                    MethodCompiler methodCompiler;
                    String cleanName = CodegenUtils.cg.cleanJavaIdentifier(name);
                    String filename = "__eval__";
                    if (this.body != null) {
                        filename = this.body.getPosition().getFile();
                    } else if (this.argsNode != null) {
                        filename = this.argsNode.getPosition().getFile();
                    }
                    StandardASMCompiler compiler = new StandardASMCompiler(cleanName + this.hashCode() + "_" + context.hashCode(), filename);
                    compiler.startScript(this.staticScope);
                    ClosureCallback args = new ClosureCallback(){

                        @Override
                        public void compile(MethodCompiler context) {
                            ASTCompiler.compileArgs(DefaultMethod.this.argsNode, context);
                        }
                    };
                    ASTInspector inspector = new ASTInspector();
                    inspector.inspect(this.body);
                    inspector.inspect(this.argsNode);
                    if (this.body != null) {
                        methodCompiler = compiler.startMethod("__file__", args, this.staticScope, inspector);
                        ASTCompiler.compile(this.body, methodCompiler);
                    } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                        methodCompiler = compiler.startMethod("__file__", args, this.staticScope, inspector);
                        methodCompiler.loadNil();
                    } else {
                        methodCompiler = compiler.startMethod("__file__", null, this.staticScope, inspector);
                        methodCompiler.loadNil();
                        this.jitCallConfig = CallConfiguration.JAVA_FAST;
                    }
                    methodCompiler.endMethod();
                    compiler.endScript();
                    Class<?> sourceClass = compiler.loadClass(new JRubyClassLoader(runtime.getJRubyClassLoader()));
                    if (this.jitCallConfig == null) {
                        this.jitCallConfig = !inspector.hasClosure() && !inspector.hasScopeAwareMethods() ? CallConfiguration.JAVA_FULL : CallConfiguration.RUBY_FULL;
                    }
                    this.jitCompiledScript = (Script)sourceClass.newInstance();
                    if (runtime.getInstanceConfig().isJitLogging()) {
                        String className = this.getImplementationClass().getBaseName();
                        if (className == null) {
                            className = "<anon class>";
                        }
                        System.err.println("compiled: " + className + "." + name);
                    }
                    this.callCount = -1;
                }
            }
            catch (Exception e) {
                if (runtime.getInstanceConfig().isJitLoggingVerbose()) {
                    String className = this.getImplementationClass().getBaseName();
                    if (className == null) {
                        className = "<anon class>";
                    }
                    System.err.println("could not compile: " + className + "." + name + " because of: \"" + e.getMessage() + '\"');
                }
                this.callCount = -1;
            }
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        if (this.requiredArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + this.requiredArgsCount + ")");
        }
        if (this.requiredArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime, args);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        int givenArgsCount = this.requiredArgsCount;
        int maximumArgs = this.requiredArgsCount;
        if (this.argsNode.getOptArgs() != null && this.restArg == -1 && (maximumArgs += this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + maximumArgs + ")");
        }
        if (this.hasOptArgs) {
            int i;
            ListNode optArgs = this.argsNode.getOptArgs();
            int j = 0;
            for (i = this.requiredArgsCount; i < args.length && j < optArgs.size(); ++i, ++j) {
                AssignmentVisitor.assign(runtime, context, context.getFrameSelf(), optArgs.get(j), args[i], Block.NULL_BLOCK, true);
                ++givenArgsCount;
            }
            i = 0;
            while (j < optArgs.size()) {
                ASTInterpreter.eval(runtime, context, optArgs.get(j), context.getFrameSelf(), Block.NULL_BLOCK);
                ++i;
                ++j;
            }
        }
        if (this.restArg != -1 && this.restArg >= 0) {
            RubyArray array = runtime.newArray(args.length - givenArgsCount);
            for (int i = givenArgsCount; i < args.length; ++i) {
                array.append(args[i]);
            }
            context.getCurrentScope().setValue(this.restArg, array, 0);
        }
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        ISourcePosition position = this.body != null ? this.body.getPosition() : context.getPosition();
        runtime.callEventHooks(context, 3, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.argsNode.getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility());
    }
}

