/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariables {
    private Ruby runtime;
    private Map globalVariables = new ConcurrentHashMap();
    private IRubyObject defaultSeparator;

    public GlobalVariables(Ruby runtime) {
        this.runtime = runtime;
    }

    public void define(String name, IAccessor accessor) {
        assert (name != null);
        assert (accessor != null);
        assert (name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(accessor));
    }

    public void defineReadonly(String name, IAccessor accessor) {
        assert (name != null);
        assert (accessor != null);
        assert (name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(new ReadonlyAccessor(name, accessor)));
    }

    public boolean isDefined(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name, String oldName) {
        assert (name != null);
        assert (oldName != null);
        assert (name.startsWith("$"));
        assert (oldName.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't alias global variable");
        }
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw new RaiseException(this.runtime, this.runtime.fastGetClass("RuntimeError"), "can't alias in tracer", false);
        }
        this.globalVariables.put(name, oldVariable);
    }

    public IRubyObject get(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        this.runtime.getWarnings().warning("global variable `" + name + "' not initialized");
        return this.runtime.getNil();
    }

    public IRubyObject set(String name, IRubyObject value) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't change global variable value");
        }
        GlobalVariable variable = this.createIfNotDefined(name);
        IRubyObject result = variable.getAccessor().setValue(value);
        variable.trace(value);
        return result;
    }

    public void setTraceVar(String name, RubyProc proc) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = this.createIfNotDefined(name);
        variable.addTrace(proc);
    }

    public boolean untraceVar(String name, IRubyObject command) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.isDefined(name)) {
            GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
            return variable.removeTrace(command);
        }
        return false;
    }

    public void untraceVar(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.isDefined(name)) {
            GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
            variable.removeTraces();
        }
    }

    public Iterator getNames() {
        return this.globalVariables.keySet().iterator();
    }

    private GlobalVariable createIfNotDefined(String name) {
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable == null) {
            variable = GlobalVariable.newUndefined(this.runtime, name);
            this.globalVariables.put(name, variable);
        }
        return variable;
    }

    public IRubyObject getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(IRubyObject defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
    }
}

