/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThread
extends RubyObject {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private Map threadLocalVariables = new HashMap();
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private ThreadService threadService;
    private volatile boolean isStopped = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    public final ReentrantLock lock = new ReentrantLock();
    private static boolean USE_POOLING = Ruby.isSecurityRestricted() ? false : Boolean.getBoolean("jruby.thread.pooling");
    private static final boolean DEBUG = false;

    public static RubyClass createThreadClass(Ruby runtime) {
        RubyClass threadClass = runtime.defineClass("Thread", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setThread(threadClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime.getThreadService().setMainThread(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyThread.startThread(recv, args, true, block);
    }

    @JRubyMethod(name={"start"}, rest=true, frame=true, meta=true)
    public static RubyThread start(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyThread.startThread(recv, args, false, block);
    }

    public static RubyThread adopt(IRubyObject recv, Thread t) {
        return RubyThread.adoptThread(recv, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv, Thread t, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        runtime.getThreadService().registerNewThread(rubyThread);
        runtime.getCurrentContext().preAdoptThread();
        rubyThread.threadImpl = USE_POOLING ? new FutureThread(rubyThread, new RubyRunnable(rubyThread, IRubyObject.NULL_ARRAY, block)) : new NativeThread(rubyThread, new RubyNativeThread(rubyThread, IRubyObject.NULL_ARRAY, block));
        rubyThread.threadImpl.start();
        return rubyThread;
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (!block.isGiven()) {
            throw this.getRuntime().newThreadError("must be called with a block");
        }
        this.threadImpl = USE_POOLING ? new FutureThread(this, new RubyRunnable(this, args, block)) : new NativeThread(this, new RubyNativeThread(this, args, block));
        this.threadImpl.start();
        return this;
    }

    private static RubyThread startThread(IRubyObject recv, IRubyObject[] args, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv.getRuntime(), (RubyClass)recv);
        if (callInit) {
            rubyThread.callInit(args, block);
        } else {
            rubyThread.initialize(args, block);
        }
        return rubyThread;
    }

    private void ensureCurrent() {
        if (this != this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    private void ensureNotCurrent() {
        if (this == this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    public void cleanTerminate(IRubyObject result) {
        this.finalResult = result;
        this.isStopped = true;
    }

    public void pollThreadEvents() {
        this.threadService.waitForCritical();
        this.ensureCurrent();
        if (this.killed) {
            throw new ThreadKill();
        }
        if (this.receivedException != null) {
            IRubyObject raiseException = this.receivedException;
            this.receivedException = null;
            RubyModule kernelModule = this.getRuntime().getKernel();
            kernelModule.callMethod(this.getRuntime().getCurrentContext(), "raise", raiseException);
        }
    }

    protected RubyThread(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.threadService = runtime.getThreadService();
        RubyThreadGroup defaultThreadGroup = (RubyThreadGroup)runtime.getThreadGroup().fastGetConstant("Default");
        defaultThreadGroup.add(this, Block.NULL_BLOCK);
        this.finalResult = runtime.getNil();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        return runtime.isGlobalAbortOnExceptionEnabled() ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set(IRubyObject recv, IRubyObject value) {
        recv.getRuntime().setGlobalAbortOnExceptionEnabled(value.isTrue());
        return value;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject recv) {
        return recv.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        ThreadService ts = runtime.getThreadService();
        boolean critical = ts.getCritical();
        ts.setCritical(false);
        Thread.yield();
        ts.setCritical(critical);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject recv) {
        IRubyObject[] activeThreads = recv.getRuntime().getThreadService().getActiveRubyThreads();
        return recv.getRuntime().newArrayNoCopy(activeThreads);
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return this.getRuntime().fastNewSymbol(originalKey.asSymbol());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn("Do not use Fixnums as Symbols");
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject key) {
        if (!this.threadLocalVariables.containsKey(key = this.getSymbolKey(key))) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.threadLocalVariables.get(key);
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject key, IRubyObject value) {
        key = this.getSymbolKey(key);
        this.threadLocalVariables.put(key, value);
        return value;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"join"}, optional=1)
    public RubyThread join(IRubyObject[] args) {
        block12: {
            long timeoutMillis = 0L;
            if (args.length > 0) {
                if (args.length > 1) {
                    throw this.getRuntime().newArgumentError(args.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    return null;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                if (this.threadService.getCritical()) {
                    this.threadImpl.interrupt();
                }
                this.threadImpl.join(timeoutMillis);
            }
            catch (InterruptedException iExcptn) {
                assert (false) : iExcptn;
            }
            catch (TimeoutException iExcptn) {
                assert (false) : iExcptn;
            }
            catch (ExecutionException iExcptn) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)iExcptn);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"value"})
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod(name={"group"})
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuffer part = new StringBuffer();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                part.append(this.getRuntime().newString(" sleep"));
            } else if (this.killed) {
                part.append(this.getRuntime().newString(" aborting"));
            } else {
                part.append(this.getRuntime().newString(" run"));
            }
        } else {
            part.append(" dead");
        }
        part.append(">");
        return this.getRuntime().newString(part.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key) {
        key = this.getSymbolKey(key);
        return this.getRuntime().newBoolean(this.threadLocalVariables.containsKey(key));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] keys = new IRubyObject[this.threadLocalVariables.size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.threadLocalVariables.keySet().toArray(keys));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true)
    public static IRubyObject critical_set(IRubyObject receiver, IRubyObject value) {
        receiver.getRuntime().getThreadService().setCritical(value.isTrue());
        return value;
    }

    @JRubyMethod(name={"critical"}, meta=true)
    public static IRubyObject critical(IRubyObject receiver) {
        return receiver.getRuntime().newBoolean(receiver.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(IRubyObject receiver) {
        Object stopLock;
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object = stopLock = rubyThread.stopLock;
        synchronized (object) {
            try {
                rubyThread.isStopped = true;
                receiver.getRuntime().getThreadService().setCritical(false);
                stopLock.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            rubyThread.isStopped = false;
        }
        return receiver.getRuntime().getNil();
    }

    @JRubyMethod(name={"kill"}, required=1, frame=true, meta=true)
    public static IRubyObject kill(IRubyObject receiver, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver.getRuntime().newTypeError(rubyThread, receiver.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(name={"exit"}, frame=true, meta=true)
    public static IRubyObject s_exit(IRubyObject receiver, Block block) {
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        receiver.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wakeup"})
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return this.priority;
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority) {
        int iPriority = RubyNumeric.fix2int(priority);
        if (iPriority < 1) {
            iPriority = 1;
        } else if (iPriority > 10) {
            iPriority = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), iPriority);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(iPriority);
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"raise"}, optional=1, frame=true)
    public IRubyObject raise(IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        this.ensureNotCurrent();
        Ruby runtime = this.getRuntime();
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.receivedException = this.prepareRaiseException(runtime, args, block);
            this.threadImpl.interrupt();
        }
        finally {
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return this;
    }

    private IRubyObject prepareRaiseException(Ruby runtime, IRubyObject[] args, Block block) {
        IRubyObject exception;
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 3);
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                return new RaiseException(runtime, runtime.fastGetClass("RuntimeError"), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                return runtime.fastGetClass("RuntimeError").newInstance(args, block);
            }
            if (!args[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!exception.isKindOf(runtime.getException())) {
            return runtime.newTypeError("exception object expected").getException();
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"run"})
    public IRubyObject run() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.isStopped) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long millis) throws InterruptedException {
        this.ensureCurrent();
        Object object = this.stopLock;
        synchronized (object) {
            try {
                this.isStopped = true;
                this.stopLock.wait(millis);
            }
            finally {
                this.isStopped = false;
                this.pollThreadEvents();
            }
        }
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.killed = true;
            this.threadImpl.interrupt();
        }
        finally {
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        try {
            this.threadImpl.join();
        }
        catch (InterruptedException ie) {
            currentThread.pollThreadEvents();
        }
        catch (ExecutionException ie) {
            currentThread.pollThreadEvents();
        }
        return this;
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"})
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception) {
        Ruby runtime;
        assert (this.isCurrent());
        RubyException rubyException = exception.getException();
        if (rubyException.isKindOf((runtime = rubyException.getRuntime()).fastGetClass("SystemExit"))) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime)) {
                RubySystemExit systemExit = RubySystemExit.newInstance(runtime, 1);
                systemExit.message = rubyException.message;
                this.threadService.getMainThread().raise(new IRubyObject[]{systemExit}, Block.NULL_BLOCK);
                return;
            }
            if (runtime.getDebug().isTrue()) {
                runtime.printError(exception.getException());
            }
        }
        this.exitingException = exception;
    }

    private boolean abortOnException(Ruby runtime) {
        return runtime.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver) {
        return receiver.getRuntime().getThreadService().getMainThread();
    }
}

