/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime) {
        RubyModule objectSpaceModule = runtime.defineModule("ObjectSpace");
        runtime.setObjectSpaceModule(objectSpaceModule);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyObjectSpace.class);
        objectSpaceModule.defineAnnotatedMethods(RubyObjectSpace.class);
        return objectSpaceModule;
    }

    @JRubyMethod(name={"define_finalizer"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyProc proc = null;
        proc = Arity.checkArgumentCount(runtime, args, 1, 2) == 2 ? (args[1] instanceof RubyProc ? (RubyProc)args[1] : (RubyProc)args[1].convertToType(runtime.getProc(), 0, "to_proc", true)) : runtime.newProc(Block.Type.PROC, block);
        IRubyObject obj = args[0];
        runtime.getObjectSpace().addFinalizer(obj, proc);
        return recv;
    }

    @JRubyMethod(name={"undefine_finalizer"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject recv, IRubyObject arg1, Block block) {
        recv.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(arg1.id()));
        return recv;
    }

    @JRubyMethod(name={"_id2ref"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject recv, IRubyObject id) {
        Ruby runtime = id.getRuntime();
        if (!(id instanceof RubyFixnum)) {
            throw recv.getRuntime().newTypeError(id, recv.getRuntime().getFixnum());
        }
        RubyFixnum idFixnum = (RubyFixnum)id;
        long longId = idFixnum.getLongValue();
        if (longId == 0L) {
            return runtime.getFalse();
        }
        if (longId == 2L) {
            return runtime.getTrue();
        }
        if (longId == 4L) {
            return runtime.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime.newFixnum((longId - 1L) / 2L);
        }
        IRubyObject object = runtime.getObjectSpace().id2ref(longId);
        if (object == null) {
            return runtime.getNil();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"each_object"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object(IRubyObject recv, IRubyObject[] args, Block block) {
        void iter;
        RubyModule rubyClass = args.length == 0 ? recv.getRuntime().getObject() : (RubyModule)args[0];
        Ruby runtime = recv.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        boolean bl = false;
        if (rubyClass != runtime.getClassClass()) {
            if (!runtime.isObjectSpaceEnabled()) {
                throw runtime.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass +O to enable");
            }
            Iterator count = recv.getRuntime().getObjectSpace().iterator(rubyClass);
            IRubyObject obj = null;
            while ((obj = (IRubyObject)count.next()) != null) {
                ++iter;
                block.yield(context, obj);
            }
        } else {
            Iterator count = runtime.getObject().subclasses(true).iterator();
            while (count.hasNext()) {
                ++iter;
                block.yield(context, (IRubyObject)count.next());
            }
        }
        return recv.getRuntime().newFixnum((long)iter);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject garbage_collect(IRubyObject recv) {
        return RubyGC.start(recv);
    }
}

