/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNil
extends RubyObject {
    private final Ruby runtime;
    public static ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return runtime.getNil();
        }
    };

    public RubyNil(Ruby runtime) {
        super(runtime, runtime.getNilClass(), false);
        this.runtime = runtime;
        this.flags |= 3;
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    public static RubyClass createNilClass(Ruby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject(), NIL_ALLOCATOR);
        runtime.setNilClass(nilClass);
        nilClass.index = 5;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNil.class);
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 5;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    @Deprecated
    public boolean safeHasInstanceVariables() {
        return false;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject recv) {
        return RubyFixnum.zero(recv.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject recv) {
        return RubyFloat.newFloat(recv.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject recv) {
        return recv.getRuntime().newString("");
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject recv) {
        return recv.getRuntime().newArray(0);
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject recv) {
        return recv.getRuntime().newString("nil");
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type(IRubyObject recv) {
        return recv.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4L);
    }
}

