/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;

public class RubyFloat
extends RubyNumeric {
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############", new DecimalFormatSymbols(Locale.ENGLISH));

    public static RubyClass createFloatClass(Ruby runtime) {
        RubyClass floatc = runtime.defineClass("Float", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFloat(floatc);
        floatc.index = 11;
        floatc.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFloat;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFloat.class);
        floatc.getSingletonClass().undefineMethod("new");
        floatc.getMetaClass().defineFastMethod("induced_from", callbackFactory.getFastSingletonMethod("induced_from", RubyKernel.IRUBY_OBJECT));
        floatc.includeModule(runtime.getPrecision());
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime, -308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime, 2.220446049250313E-16));
        floatc.defineAnnotatedMethods(RubyFloat.class);
        floatc.dispatcher = callbackFactory.createDispatcher(floatc);
        return floatc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(Ruby runtime, double value) {
        super(runtime, runtime.getFloat());
        this.value = value;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime, double value) {
        return new RubyFloat(runtime, value);
    }

    public static IRubyObject induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum) {
            return number.callMethod(recv.getRuntime().getCurrentContext(), MethodIndex.TO_F, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(this.getRuntime(), this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(this.getRuntime(), "NaN");
        }
        String val = "" + this.value;
        if (val.indexOf(69) != -1) {
            String v2 = FORMAT.format(this.value);
            int ix = v2.length() - 1;
            while (v2.charAt(ix) == '0' && v2.charAt(ix - 1) != '.') {
                --ix;
            }
            val = ix > 15 || "0.0".equals(v2.substring(0, ix + 1)) ? val.replaceFirst("E(\\d)", "e+$1").replaceFirst("E-", "e-") : v2.substring(0, ix + 1);
        }
        return RubyString.newString(this.getRuntime(), val);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newArray(RubyFloat.newFloat(this.getRuntime(), ((RubyNumeric)other).getDoubleValue()), this);
        }
        throw this.getRuntime().newTypeError(other, this.getRuntime().getNumeric());
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("+", other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("-", other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("*", other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("div", other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double x;
            double mod;
            double y = ((RubyNumeric)other).getDoubleValue();
            if (y * (mod = Math.IEEEremainder(x = this.value, y)) < 0.0) {
                mod += y;
            }
            return RubyFloat.newFloat(this.getRuntime(), mod);
        }
        return this.coerceBin("%", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double y = ((RubyNumeric)other).getDoubleValue();
            double x = this.value;
            double mod = Math.IEEEremainder(x, y);
            double div = (x - mod) / y;
            if (y * mod < 0.0) {
                mod += y;
                div -= 1.0;
            }
            Ruby runtime = this.getRuntime();
            IRubyObject car = RubyFloat.dbl2num(runtime, div);
            RubyFloat cdr = RubyFloat.newFloat(runtime, mod);
            return RubyArray.newArray(runtime, car, cdr);
        }
        return this.coerceBin("%", other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
        }
        return this.coerceBin("/", other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (other instanceof RubyNumeric) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)other).getDoubleValue());
        }
        return super.op_equal(other);
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyFloat.dbl_cmp(this.getRuntime(), this.value, b);
        }
        return this.coerceCmp("<=>", other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value > b);
        }
        return this.coerceRelOp(">", other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value >= b);
        }
        return this.coerceRelOp(">=", other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value < b);
        }
        return this.coerceRelOp("<", other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value <= b);
        }
        return this.coerceRelOp("<=", other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).value;
            if (Double.isNaN(this.value) || Double.isNaN(b)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == b) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        if (this.value < 0.0) {
            return RubyFloat.newFloat(this.getRuntime(), Math.abs(this.value));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f < 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f + 0.5);
        }
        if (f < 0.0) {
            f = Math.ceil(f - 0.5);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        String strValue = aFloat.toString();
        if (Double.isInfinite(aFloat.value)) {
            strValue = aFloat.value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(aFloat.value)) {
            strValue = "nan";
        }
        output.writeString(strValue);
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyFloat result = RubyFloat.newFloat(input.getRuntime(), Convert.byteListToDouble(input.unmarshalString(), false));
        input.registerLinkTarget(result);
        return result;
    }
}

