/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CommandlineParser;
import org.jruby.util.SimpleSampler;

public class Main {
    private CommandlineParser commandline;
    private boolean hasPrintedUsage = false;
    private RubyInstanceConfig config;
    private PrintStream out;
    private PrintStream err;

    public Main(RubyInstanceConfig config) {
        this.config = config;
        this.out = config.getOutput();
        this.err = config.getError();
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args) {
        Main main = new Main();
        int status = main.run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public int run(String[] args) {
        int status;
        this.commandline = new CommandlineParser(this, args);
        if (this.commandline.isShowVersion()) {
            this.showVersion();
        }
        if (!this.commandline.shouldRunInterpreter()) {
            return 0;
        }
        long now = -1L;
        if (this.commandline.isBenchmarking()) {
            now = System.currentTimeMillis();
        }
        try {
            status = this.runInterpreter(this.commandline);
        }
        catch (MainExitException mee) {
            this.err.println(mee.getMessage());
            if (mee.isUsageError()) {
                this.printUsage();
            }
            status = mee.getStatus();
        }
        if (this.commandline.isBenchmarking()) {
            this.out.println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
        return status;
    }

    private void showVersion() {
        this.out.print("ruby ");
        this.out.print(Constants.RUBY_VERSION);
        this.out.print(" (");
        this.out.print(Constants.COMPILE_DATE + " rev " + Constants.REVISION);
        this.out.print(") [");
        this.out.print(System.getProperty("os.arch") + "-jruby" + Constants.VERSION);
        this.out.println("]");
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.out.println("Usage: jruby [switches] [--] [rubyfile.rb] [arguments]");
            this.out.println("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]");
            this.out.println("    -b              benchmark mode, times the script execution");
            this.out.println("    -Jjava option   pass an option on to the JVM (e.g. -J-Xmx512m)");
            this.out.println("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)");
            this.out.println("    --              optional -- before rubyfile.rb for compatibility with ruby");
            this.out.println("    -d              set debugging flags (set $DEBUG to true)");
            this.out.println("    -v              print version number, then turn on verbose mode");
            this.out.println("    -O              run with ObjectSpace disabled (improves performance)");
            this.out.println("    -S cmd          run the specified command in JRuby's bin dir");
            this.out.println("    -C              pre-compile scripts before running (EXPERIMENTAL)");
            this.out.println("    -y              read a YARV-compiled Ruby script and run that (EXPERIMENTAL)");
            this.out.println("    -Y              compile a Ruby script into YARV bytecodes and run this (EXPERIMENTAL)");
            this.out.println("    -R              read a Rubinius-compiled Ruby script and run that (EXPERIMENTAL)");
            this.out.println("    --command word  Execute ruby-related shell command (i.e., irb, gem)");
            this.hasPrintedUsage = true;
        }
    }

    private int runInterpreter(CommandlineParser commandline) {
        InputStream in = commandline.getScriptSource();
        String filename = commandline.displayedFileName();
        this.config.updateWithCommandline(commandline);
        Ruby runtime = Ruby.newInstance(this.config);
        runtime.setKCode(commandline.getKCode());
        if (this.config.isSamplingEnabled()) {
            SimpleSampler.startSampleThread();
        }
        if (commandline.isVerbose()) {
            runtime.setVerbose(runtime.getTrue());
        }
        if (in == null) {
            return 0;
        }
        try {
            this.runInterpreter(runtime, in, filename);
            int n = 0;
            return n;
        }
        catch (RaiseException rj) {
            RubyException raisedException = rj.getException();
            if (raisedException.isKindOf(runtime.fastGetClass("SystemExit"))) {
                IRubyObject status = raisedException.callMethod(runtime.getCurrentContext(), "status");
                if (status != null && !status.isNil()) {
                    int n = RubyNumeric.fix2int(status);
                    return n;
                }
                int n = 0;
                return n;
            }
            runtime.printError(raisedException);
            int status = 1;
            return status;
        }
        catch (JumpException.ThrowJump tj) {
            int n = 1;
            return n;
        }
        catch (MainExitException e) {
            if (e.isAborted()) {
                int n = e.getStatus();
                return n;
            }
            throw e;
        }
        finally {
            if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                System.err.println("Runtime information dump:");
                for (Object key : runtime.getRuntimeInformation().keySet()) {
                    System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                }
            }
            if (this.config.isSamplingEnabled()) {
                SimpleSampler.report();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterpreter(Ruby runtime, InputStream in, String filename) {
        try {
            this.initializeRuntime(runtime, filename);
            runtime.runFromMain(in, filename, this.commandline);
        }
        finally {
            runtime.tearDown();
        }
    }

    private void initializeRuntime(Ruby runtime, String filename) {
        runtime.setVerbose(runtime.newBoolean(this.commandline.isVerbose()));
        runtime.setDebug(runtime.newBoolean(this.commandline.isDebug()));
        runtime.getObject().setInternalVariable("$VERBOSE", this.commandline.isVerbose() ? runtime.getTrue() : runtime.getNil());
        this.defineGlobal(runtime, "$-p", this.commandline.isAssumePrinting());
        this.defineGlobal(runtime, "$-n", this.commandline.isAssumeLoop());
        this.defineGlobal(runtime, "$-a", this.commandline.isSplit());
        this.defineGlobal(runtime, "$-l", this.commandline.isProcessLineEnds());
        ValueAccessor d = new ValueAccessor(runtime.newString(filename));
        runtime.getGlobalVariables().define("$PROGRAM_NAME", d);
        runtime.getGlobalVariables().define("$0", d);
        runtime.getLoadService().init(this.commandline.loadPaths());
        for (String scriptName : this.commandline.requiredLibraries()) {
            RubyKernel.require(runtime.getTopSelf(), runtime.newString(scriptName), Block.NULL_BLOCK);
        }
    }

    private void defineGlobal(Ruby runtime, String name, boolean value) {
        runtime.getGlobalVariables().defineReadonly(name, new ValueAccessor(value ? runtime.getTrue() : runtime.getNil()));
    }
}

