/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;

public class JRubyC {
    public static void main(String[] args) {
        Ruby runtime = Ruby.getDefaultInstance();
        try {
            if (args.length < 1) {
                System.out.println("Usage: jrubyc <filename> [<filename> ...]");
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                File srcfile;
                String filename = args[i];
                if (filename.startsWith("./")) {
                    filename = filename.substring(2);
                }
                if (!(srcfile = new File(filename)).exists()) {
                    System.out.println("Error -- file not found: " + filename);
                    return;
                }
                File destfile = new File(System.getProperty("user.dir"));
                int size = (int)srcfile.length();
                byte[] chars = new byte[size];
                new FileInputStream(srcfile).read(chars);
                String content = new String(chars);
                Node scriptNode = runtime.parseFile(new ByteArrayInputStream(content.getBytes("ISO-8859-1")), filename, null);
                ASTInspector inspector = new ASTInspector();
                inspector.inspect(scriptNode);
                String classPath = filename.substring(0, filename.lastIndexOf(".")).replace('-', '_').replace('.', '_');
                int lastSlashIndex = classPath.lastIndexOf(47);
                if (!Character.isJavaIdentifierStart(classPath.charAt(lastSlashIndex + 1))) {
                    classPath = lastSlashIndex == -1 ? "_" + classPath : classPath.substring(0, lastSlashIndex + 1) + "_" + classPath.substring(lastSlashIndex + 1);
                }
                String classDotted = classPath.replace('/', '.').replace('\\', '.');
                StandardASMCompiler compiler = new StandardASMCompiler(classPath, filename);
                System.out.println("Compiling file \"" + filename + "\" as class \"" + classDotted + "\"");
                ASTCompiler.compileRoot(scriptNode, compiler, inspector);
                compiler.writeClass(destfile);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Error -- IO exception during compile: " + ioe.getMessage());
        }
        catch (NotCompilableException nce) {
            System.err.println("Error -- Not compilable: " + nce.getMessage());
        }
    }
}

