/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.RubyIO;
import org.jruby.ext.posix.POSIX;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullWritableChannel;
import org.jruby.util.io.PipeException;

public class ChannelDescriptor {
    private static final boolean DEBUG = false;
    private Channel channel;
    private final int fileno;
    private final FileDescriptor fileDescriptor;
    private final ModeFlags originalModes;
    private final AtomicInteger refCounter;
    private InputStream baseInputStream;

    private ChannelDescriptor(Channel channel, int fileno, ModeFlags originalModes, FileDescriptor fileDescriptor, AtomicInteger refCounter) {
        this.refCounter = refCounter;
        this.channel = channel;
        this.fileno = fileno;
        this.originalModes = originalModes;
        this.fileDescriptor = fileDescriptor;
    }

    public ChannelDescriptor(Channel channel, int fileno, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, fileno, originalModes, fileDescriptor, new AtomicInteger(1));
    }

    public ChannelDescriptor(InputStream baseInputStream, int fileno, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(Channels.newChannel(baseInputStream), fileno, originalModes, fileDescriptor, new AtomicInteger(1));
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(Channel channel, int fileno, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, fileno, ChannelDescriptor.getModesFromChannel(channel), fileDescriptor);
    }

    public int getFileno() {
        return this.fileno;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    InputStream getBaseInputStream() {
        return this.baseInputStream;
    }

    public boolean isSeekable() {
        return this.channel instanceof FileChannel;
    }

    public boolean isWritable() {
        return this.channel instanceof WritableByteChannel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void checkOpen() throws BadDescriptorException {
        if (!this.isOpen()) {
            throw new BadDescriptorException();
        }
    }

    public ModeFlags getOriginalModes() {
        return this.originalModes;
    }

    public void checkNewModes(ModeFlags newModes) throws InvalidValueException {
        if (!newModes.isSubsetOf(this.originalModes)) {
            throw new InvalidValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup() {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            int newFileno = RubyIO.getNewFileno();
            return new ChannelDescriptor(this.channel, newFileno, this.originalModes, this.fileDescriptor, this.refCounter);
        }
    }

    public void dup2(ChannelDescriptor other) {
        other.channel = this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup2(int fileno) {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            return new ChannelDescriptor(this.channel, fileno, this.originalModes, this.fileDescriptor, this.refCounter);
        }
    }

    public long lseek(long offset, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.channel instanceof FileChannel) {
            this.checkOpen();
            FileChannel fileChannel = (FileChannel)this.channel;
            try {
                long pos;
                switch (whence) {
                    case 0: {
                        pos = offset;
                        fileChannel.position(pos);
                        break;
                    }
                    case 1: {
                        pos = fileChannel.position() + offset;
                        fileChannel.position(pos);
                        break;
                    }
                    case 2: {
                        pos = fileChannel.size() + offset;
                        fileChannel.position(pos);
                        break;
                    }
                    default: {
                        throw new InvalidValueException();
                    }
                }
                return pos;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidValueException();
            }
        }
        throw new PipeException();
    }

    public int read(int number, ByteList byteList) throws IOException, BadDescriptorException {
        byte[] ret;
        this.checkOpen();
        ByteBuffer buffer = ByteBuffer.allocate(number);
        int bytesRead = this.read(buffer);
        if (buffer.hasRemaining()) {
            buffer.flip();
            ret = new byte[buffer.remaining()];
            buffer.get(ret);
        } else {
            ret = buffer.array();
        }
        byteList.append(ret);
        return bytesRead;
    }

    public int read(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        ReadableByteChannel readChannel = (ReadableByteChannel)this.channel;
        int bytesRead = 0;
        bytesRead = readChannel.read(buffer);
        return bytesRead;
    }

    public int internalWrite(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        WritableByteChannel writeChannel = (WritableByteChannel)this.channel;
        if (this.isSeekable() && this.originalModes.isAppendable()) {
            FileChannel fileChannel = (FileChannel)this.channel;
            fileChannel.position(fileChannel.size());
        }
        return writeChannel.write(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(buffer);
    }

    public int write(ByteList buf) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
    }

    public int write(int c) throws IOException, BadDescriptorException {
        this.checkOpen();
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)c);
        buf.flip();
        return this.internalWrite(buf);
    }

    public static ChannelDescriptor open(String cwd, String path, ModeFlags flags) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path, flags, 0, null);
    }

    public static ChannelDescriptor open(String cwd, String path, ModeFlags flags, int perm, POSIX posix) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        boolean fileCreated = false;
        if (path.equals("/dev/null")) {
            NullWritableChannel nullChannel = new NullWritableChannel();
            return new ChannelDescriptor(nullChannel, RubyIO.getNewFileno(), flags, new FileDescriptor());
        }
        if (path.startsWith("file:")) {
            String filePath = path.substring(5, path.indexOf("!"));
            String internalPath = path.substring(path.indexOf("!") + 2);
            if (!new File(filePath).exists()) {
                throw new FileNotFoundException(path);
            }
            JarFile jf = new JarFile(filePath);
            ZipEntry zf = jf.getEntry(internalPath);
            if (zf == null) {
                throw new FileNotFoundException(path);
            }
            InputStream is = jf.getInputStream(zf);
            return new ChannelDescriptor(Channels.newChannel(is), RubyIO.getNewFileno(), flags, new FileDescriptor());
        }
        JRubyFile theFile = JRubyFile.create(cwd, path);
        if (theFile.isDirectory() && flags.isWritable()) {
            throw new DirectoryAsFileException();
        }
        if (flags.isCreate()) {
            if (theFile.exists() && flags.isExclusive()) {
                throw new FileExistsException(path);
            }
            fileCreated = theFile.createNewFile();
        } else if (!theFile.exists()) {
            throw new FileNotFoundException(path);
        }
        RandomAccessFile file = new RandomAccessFile(theFile, flags.toJavaModeString());
        if (fileCreated && posix != null && perm != -1) {
            posix.chmod(theFile.getPath(), perm);
        }
        if (flags.isTruncate()) {
            file.setLength(0L);
        }
        return new ChannelDescriptor(file.getChannel(), RubyIO.getNewFileno(), flags, file.getFD());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            if (this.refCounter.get() <= 0) {
                throw new BadDescriptorException();
            }
            if (!this.channel.isOpen()) {
                throw new BadDescriptorException();
            }
            int count = this.refCounter.decrementAndGet();
            if (count <= 0) {
                this.channel.close();
            }
        }
    }

    private static ModeFlags getModesFromChannel(Channel channel) throws InvalidValueException {
        ModeFlags modes;
        if (channel instanceof ReadableByteChannel) {
            if (channel instanceof WritableByteChannel) {
                ModeFlags modeFlags = new ModeFlags(2L);
            }
            modes = new ModeFlags(0L);
        } else {
            modes = channel instanceof WritableByteChannel ? new ModeFlags(1L) : new ModeFlags(2L);
        }
        return modes;
    }
}

