/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCache<T> {
    private ReferenceQueue referenceQueue = new ReferenceQueue();
    private Map<Object, KeyedClassReference> cache = new ConcurrentHashMap<Object, KeyedClassReference>();
    private ClassLoader classLoader;
    private int max;

    public ClassCache(ClassLoader classLoader, int max) {
        this.classLoader = classLoader;
        this.max = max;
    }

    public ClassCache(ClassLoader classLoader) {
        this(classLoader, -1);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class<T> cacheClassByKey(Object key, ClassGenerator classGenerator) throws ClassNotFoundException {
        WeakReference weakRef = this.cache.get(key);
        Class<?> contents = null;
        if (weakRef != null) {
            contents = (Class<?>)weakRef.get();
        }
        if (weakRef == null || contents == null) {
            if (this.isFull()) {
                return null;
            }
            OneShotClassLoader oneShotCL = new OneShotClassLoader(this.getClassLoader());
            contents = oneShotCL.defineClass(classGenerator.name(), classGenerator.bytecode());
            this.cache.put(key, new KeyedClassReference(key, contents, this.referenceQueue));
        }
        return contents;
    }

    public boolean isFull() {
        this.cleanup();
        return this.max > 0 && this.cache.size() >= this.max;
    }

    private void cleanup() {
        KeyedClassReference reference;
        while ((reference = (KeyedClassReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(reference.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneShotClassLoader
    extends URLClassLoader {
        private static final ProtectionDomain DEFAULT_DOMAIN = JRubyClassLoader.class.getProtectionDomain();

        public OneShotClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            return super.defineClass(name, bytes, 0, bytes.length, DEFAULT_DOMAIN);
        }

        public Class<?> defineClass(String name, byte[] bytes, ProtectionDomain domain) {
            return super.defineClass(name, bytes, 0, bytes.length, domain);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedClassReference<T>
    extends WeakReference<Class<T>> {
        private Object key;

        public KeyedClassReference(Object key, Class<T> referent, ReferenceQueue<Class<T>> referenceQueue) {
            super(referent, referenceQueue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static interface ClassGenerator {
        public byte[] bytecode();

        public String name();
    }
}

