/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.Native;
import java.util.HashMap;
import org.jruby.ext.posix.JavaPOSIX;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.LinuxPOSIX;
import org.jruby.ext.posix.MacOSPOSIX;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.WindowsLibCFunctionMapper;
import org.jruby.ext.posix.WindowsPOSIX;
import org.jruby.util.SafePropertyAccessor;

public class POSIXFactory {
    static LibC libc = null;

    public static POSIX getPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        POSIX posix;
        block12: {
            boolean thirtyTwoBit = "32".equals(SafePropertyAccessor.getProperty("sun.arch.data.model", "32"));
            posix = null;
            if (useNativePOSIX && thirtyTwoBit) {
                try {
                    String os = System.getProperty("os.name");
                    if (os.startsWith("Mac OS") || os.startsWith("Darwin")) {
                        posix = new MacOSPOSIX(POSIXFactory.loadMacOSLibC(), handler);
                    } else if (os.startsWith("Linux")) {
                        posix = new LinuxPOSIX(POSIXFactory.loadLinuxLibC(), handler);
                    } else if (os.startsWith("Windows")) {
                        posix = new WindowsPOSIX(POSIXFactory.loadWindowsLibC(), handler);
                    }
                    if (SafePropertyAccessor.getBoolean("jruby.native.verbose")) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!SafePropertyAccessor.getBoolean("jruby.native.verbose")) break block12;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler);
        }
        return posix;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler) {
        return new JavaPOSIX(handler);
    }

    public static LibC loadLinuxLibC() {
        if (libc != null) {
            return libc;
        }
        libc = (LibC)Native.loadLibrary("c", LinuxLibC.class, new HashMap());
        return libc;
    }

    public static LibC loadMacOSLibC() {
        if (libc != null) {
            return libc;
        }
        libc = (LibC)Native.loadLibrary("c", LibC.class, new HashMap());
        return libc;
    }

    public static LibC loadWindowsLibC() {
        if (libc != null) {
            return libc;
        }
        HashMap<String, WindowsLibCFunctionMapper> options = new HashMap<String, WindowsLibCFunctionMapper>();
        options.put("function-mapper", new WindowsLibCFunctionMapper());
        libc = (LibC)Native.loadLibrary("msvcrt", LibC.class, options);
        return libc;
    }
}

