/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxFileStat;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class LinuxPOSIX
extends BaseNativePOSIX {
    private static int STAT_VERSION = 3;

    public LinuxPOSIX(LibC libc, POSIXHandler handler) {
        super(libc, handler);
    }

    public FileStat allocateStat() {
        return new LinuxFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (((LinuxLibC)this.libc).__fxstat(STAT_VERSION, fd, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat;
    }

    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (((LinuxLibC)this.libc).__lxstat(STAT_VERSION, path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (((LinuxLibC)this.libc).__xstat(STAT_VERSION, path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }
}

