/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList marker;
    private final int flags;
    private final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, ByteList lastLine) {
        this.marker = marker;
        this.flags = func;
        this.lastLine = lastLine;
    }

    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean indent;
        boolean bl = indent = (this.flags & 0x20) != 0;
        if (src.peek(-1)) {
            this.syntaxError(src);
        }
        if (src.lastWasBeginOfLine() && src.matchMarker(this.marker, indent, true)) {
            src.unreadMany(this.lastLine);
            lexer.yaccValue = new Token(this.marker, lexer.getPosition());
            return 374;
        }
        ByteList str = new ByteList();
        if ((this.flags & 2) == 0) {
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (!src.peek(-1)) continue;
                this.syntaxError(src);
            } while (!src.matchMarker(this.marker, indent, true));
        } else {
            int c = src.read();
            if (c == 35) {
                c = src.read();
                switch (c) {
                    case 36: 
                    case 64: {
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 373;
                    }
                    case 123: {
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 372;
                    }
                }
                str.append(35);
            }
            src.unread(c);
            do {
                if ((c = new StringTerm(this.flags, 0, 10).parseStringIntoBuffer(lexer, src, str)) == -1) {
                    this.syntaxError(src);
                }
                if (c != 10) {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), str);
                    return 312;
                }
                str.append(src.read());
                if (!src.peek(-1)) continue;
                this.syntaxError(src);
            } while (!src.matchMarker(this.marker, indent, true));
        }
        src.unreadMany(this.lastLine);
        lexer.setStrTerm(new StringTerm(-1, 0, 0));
        lexer.yaccValue = new StrNode(lexer.getPosition(), str);
        return 312;
    }

    private void syntaxError(LexerSource src) {
        throw new SyntaxException(src.getPosition(), "can't find string \"" + this.marker + "\" anywhere before EOF");
    }
}

