/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.parser.EvalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.FourVarDynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.runtime.scope.NoVarsDynamicScope;
import org.jruby.runtime.scope.OneVarDynamicScope;
import org.jruby.runtime.scope.ThreeVarDynamicScope;
import org.jruby.runtime.scope.TwoVarDynamicScope;

public abstract class DynamicScope {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    protected DynamicScope evalScope;

    protected DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this.staticScope = staticScope;
        this.parent = parent;
    }

    protected DynamicScope(StaticScope staticScope) {
        this(staticScope, null);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent) {
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                return new NoVarsDynamicScope(staticScope, parent);
            }
            case 1: {
                return new OneVarDynamicScope(staticScope, parent);
            }
            case 2: {
                return new TwoVarDynamicScope(staticScope, parent);
            }
            case 3: {
                return new ThreeVarDynamicScope(staticScope, parent);
            }
            case 4: {
                return new FourVarDynamicScope(staticScope, parent);
            }
        }
        return new ManyVarsDynamicScope(staticScope, parent);
    }

    public static DynamicScope newDummyScope(StaticScope staticScope, DynamicScope parent) {
        return new ManyVarsDynamicScope(staticScope, parent);
    }

    public DynamicScope getNthParentScope(int n) {
        DynamicScope scope = this;
        for (int i = 0; i < n && scope != null; scope = scope.getNextCapturedScope(), ++i) {
        }
        return scope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public final DynamicScope getEvalScope() {
        if (this.evalScope == null) {
            DynamicScope parent = this.getNextCapturedScope();
            this.evalScope = parent != null && parent.getEvalScope() == this ? this : new ManyVarsDynamicScope(new EvalStaticScope(this.getStaticScope()), this);
        }
        return this.evalScope;
    }

    public DynamicScope getFlipScope() {
        if (this.staticScope.getLocalScope() == this.staticScope) {
            return this;
        }
        return this.parent.getFlipScope();
    }

    public final DynamicScope getNextCapturedScope() {
        return this.parent;
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public abstract void growIfNeeded();

    public abstract String toString(StringBuffer var1, String var2);

    public abstract DynamicScope cloneScope();

    public abstract IRubyObject[] getValues();

    public abstract IRubyObject getValue(int var1, int var2);

    public abstract IRubyObject getValueOrNil(int var1, int var2, IRubyObject var3);

    public abstract IRubyObject getValueDepthZeroOrNil(int var1, IRubyObject var2);

    public abstract IRubyObject getValueZeroDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueOneDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueTwoDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueThreeDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject setValue(int var1, IRubyObject var2, int var3);

    public IRubyObject setValue(IRubyObject value2, int offset2, int depth) {
        return this.setValue(offset2, value2, depth);
    }

    public abstract IRubyObject setValueDepthZero(IRubyObject var1, int var2);

    public abstract IRubyObject setValueZeroDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueOneDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueTwoDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueThreeDepthZero(IRubyObject var1);

    public abstract void setArgValues(IRubyObject[] var1, int var2);

    public abstract void setArgValues(IRubyObject var1);

    public abstract void setArgValues(IRubyObject var1, IRubyObject var2);

    public abstract void setArgValues(IRubyObject var1, IRubyObject var2, IRubyObject var3);

    public abstract void setEndArgValues(IRubyObject[] var1, int var2, int var3);

    public abstract IRubyObject[] getArgValues();
}

