/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class ASTInterpreter {
    @Deprecated
    public static IRubyObject eval(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block block) {
        assert (self != null) : "self during eval must never be null";
        if (node == null) {
            return runtime2.getNil();
        }
        try {
            return node.interpret(runtime2, context, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime2.newSystemStackError("stack level too deep");
        }
    }

    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file2, int lineNumber) {
        assert (!scope.isNil());
        Ruby runtime2 = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw runtime2.newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Binding binding2 = ((RubyBinding)scope).getBinding();
        DynamicScope evalScope = binding2.getDynamicScope().getEvalScope();
        if (file2 == null) {
            file2 = binding2.getFrame().getFile();
        }
        if (lineNumber == -1) {
            lineNumber = binding2.getFrame().getLine();
        }
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject newSelf = binding2.getSelf();
            RubyString source2 = src.convertToString();
            Node node = runtime2.parseEval(source2.getByteList(), file2, evalScope, lineNumber);
            IRubyObject iRubyObject = node.interpret(runtime2, context, newSelf, binding2.getFrame().getBlock());
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, (IRubyObject)rj.getValue(), "unexpected redo");
        }
        catch (StackOverflowError sfe) {
            throw runtime2.newSystemStackError("stack level too deep");
        }
        finally {
            context.postEvalWithBinding(binding2, lastFrame);
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, IRubyObject src, String file2, int lineNumber) {
        RubyString source2 = src.convertToString();
        return ASTInterpreter.evalSimple(context, self, source2, file2, lineNumber);
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file2, int lineNumber) {
        assert (file2 != null);
        Ruby runtime2 = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        RubyString source2 = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        try {
            Node node = runtime2.parseEval(source2.getByteList(), file2, evalScope, lineNumber);
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (StackOverflowError sfe) {
            throw runtime2.newSystemStackError("stack level too deep");
        }
        finally {
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static void callTraceFunction(Ruby runtime2, ThreadContext context, RubyEvent event) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        runtime2.callEventHooks(context, event, context.getFile(), context.getLine(), name2, type2);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime2, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            array[i] = node.get(i).interpret(runtime2, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime2, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime2, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime2, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type2, IRubyObject self, Block block) {
        context.preClassEval(scope, type2);
        try {
            if (runtime2.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.CLASS);
            }
            if (bodyNode == null) {
                IRubyObject iRubyObject = runtime2.getNil();
                return iRubyObject;
            }
            IRubyObject iRubyObject = bodyNode.interpret(runtime2, context, type2, block);
            return iRubyObject;
        }
        finally {
            if (runtime2.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
            }
            context.postClassEval();
        }
    }

    public static String getArgumentDefinition(Ruby runtime2, ThreadContext context, Node node, String type2, IRubyObject self, Block block) {
        if (node == null) {
            return type2;
        }
        if (node instanceof ArrayNode) {
            ArrayNode list2 = (ArrayNode)node;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                if (list2.get(i).definition(runtime2, context, self, block) != null) continue;
                return null;
            }
        } else if (node.definition(runtime2, context, self, block) == null) {
            return null;
        }
        return type2;
    }

    public static Block getBlock(Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(blockNode, context, self);
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime2, context, self, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc2 = bodyNode == null ? runtime2.getNil() : bodyNode.interpret(runtime2, context, self, currentBlock);
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2, currentBlock);
    }

    private static Block getIterNodeBlock(Node blockNode, ThreadContext context, IRubyObject self) {
        IterNode iterNode = (IterNode)blockNode;
        StaticScope scope = iterNode.getScope();
        scope.determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime2) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        if (rubyClass.isSingleton() || rubyClass == runtime2.getDummy()) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() == null) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
            }
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getDefinition(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string2 = node.definition(runtime2, context, self, aBlock);
            return string2;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    public static IRubyObject[] setupArgs(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size2 = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size2];
            for (int i = 0; i < size2; ++i) {
                argsArray[i] = argsArrayNode.get(i).interpret(runtime2, context, self, aBlock);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime2, context, self, aBlock));
    }

    @Deprecated
    public static IRubyObject aValueSplat(Ruby runtime2, IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return runtime2.getNil();
        }
        RubyArray array = (RubyArray)value2;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    @Deprecated
    public static RubyArray arrayValue(Ruby runtime2, IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime2.getKernel()) {
                if (!((value2 = value2.callMethod(runtime2.getCurrentContext(), "to_a")) instanceof RubyArray)) {
                    throw runtime2.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)value2;
            }
            return runtime2.newArray(value2);
        }
        return (RubyArray)tmp;
    }

    @Deprecated
    public static IRubyObject aryToAry(Ruby runtime2, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value2, runtime2.getArray(), "to_ary", false);
        }
        return runtime2.newArray(value2);
    }

    @Deprecated
    public static RubyArray splatValue(Ruby runtime2, IRubyObject value2) {
        if (value2.isNil()) {
            return runtime2.newArray(value2);
        }
        return ASTInterpreter.arrayValue(runtime2, value2);
    }

    @Deprecated
    public static RubyArray splatValue(IRubyObject value2, Ruby runtime2) {
        return ASTInterpreter.splatValue(runtime2, value2);
    }

    @Deprecated
    public static IRubyObject aValueSplat(IRubyObject value2, Ruby runtime2) {
        return ASTInterpreter.aValueSplat(runtime2, value2);
    }

    @Deprecated
    public static IRubyObject aryToAry(IRubyObject value2, Ruby runtime2) {
        return ASTInterpreter.aryToAry(runtime2, value2);
    }
}

