/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Colon2ConstNode
extends Colon2Node {
    public Colon2ConstNode(ISourcePosition position, Node leftNode, String name2) {
        super(position, leftNode, name2);
        assert (leftNode != null) : "Colon2ConstNode cannot have null leftNode";
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return RuntimeHelpers.checkIsModule(this.leftNode.interpret(runtime2, context, self, aBlock)).fastGetConstantFrom(this.name);
    }

    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            if (this.isModuleAndHasConstant(this.leftNode.interpret(runtime2, context, self, aBlock))) {
                return "constant";
            }
        }
        catch (JumpException e) {
            // empty catch block
        }
        return null;
    }

    private boolean isModuleAndHasConstant(IRubyObject left) {
        return left instanceof RubyModule && ((RubyModule)left).fastGetConstantAt(this.name) != null;
    }
}

