/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.posix.POSIX;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Process"})
public class RubyProcess {
    private static String[] signals = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "POLL", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "XCPU", "XFSZ", "VTALRM", "PROF", "USR1", "USR2"};
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public static RubyModule createProcessModule(Ruby runtime2) {
        RubyModule process = runtime2.defineModule("Process");
        runtime2.setProcess(process);
        RubyClass process_status = process.defineClassUnder("Status", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setProcStatus(process_status);
        RubyModule process_uid = process.defineModuleUnder("UID");
        runtime2.setProcUID(process_uid);
        RubyModule process_gid = process.defineModuleUnder("GID");
        runtime2.setProcGID(process_gid);
        RubyModule process_sys = process.defineModuleUnder("Sys");
        runtime2.setProcSys(process_sys);
        process.defineAnnotatedMethods(RubyProcess.class);
        process_status.defineAnnotatedMethods(RubyStatus.class);
        process_uid.defineAnnotatedMethods(UserID.class);
        process_gid.defineAnnotatedMethods(GroupID.class);
        process_sys.defineAnnotatedMethods(Sys.class);
        process.defineConstant("PRIO_PROCESS", runtime2.newFixnum(0));
        process.defineConstant("PRIO_PGRP", runtime2.newFixnum(1));
        process.defineConstant("PRIO_USER", runtime2.newFixnum(2));
        process.defineConstant("WNOHANG", runtime2.newFixnum(1));
        return process;
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.abort(context, recv2, args2);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit_bang(recv2, args2);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(IRubyObject recv2) {
        throw recv2.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"setrlimit"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(IRubyObject recv2, IRubyObject[] args2) {
        throw recv2.getRuntime().newNotImplementedError("Process#setrlimit not yet implemented");
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getpgrp());
    }

    @JRubyMethod(name={"groups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        int pid2 = -1;
        int flags = 0;
        if (args2.length > 0) {
            pid2 = (int)args2[0].convertToInteger().getLongValue();
        }
        if (args2.length > 1) {
            flags = (int)args2[1].convertToInteger().getLongValue();
        }
        int[] status2 = new int[1];
        pid2 = runtime2.getPosix().waitpid(pid2, status2, flags);
        if (pid2 == -1) {
            throw runtime2.newErrnoECHILDError();
        }
        runtime2.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(runtime2, status2[0]));
        return runtime2.newFixnum(pid2);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        if (args2.length > 0) {
            return RubyProcess.waitpid(recv2, args2);
        }
        int[] status2 = new int[1];
        int pid2 = runtime2.getPosix().wait(status2);
        if (pid2 == -1) {
            throw runtime2.newErrnoECHILDError();
        }
        runtime2.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(runtime2, status2[0]));
        return runtime2.newFixnum(pid2);
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        RubyArray results = recv2.getRuntime().newArray();
        int[] status2 = new int[1];
        int result = posix.wait(status2);
        while (result != -1) {
            results.append(runtime2.newArray(runtime2.newFixnum(result), RubyStatus.newProcessStatus(runtime2, status2[0])));
            result = posix.wait(status2);
        }
        return results;
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().setsid());
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().setpgid(0, 0));
    }

    @JRubyMethod(name={"egid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(IRubyObject recv2, IRubyObject arg2) {
        recv2.getRuntime().getPosix().setegid((int)arg2.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().geteuid());
    }

    @JRubyMethod(name={"uid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(IRubyObject recv2, IRubyObject arg2) {
        recv2.getRuntime().getPosix().setuid((int)arg2.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getgid());
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(IRubyObject recv2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups not yet implemented");
    }

    @JRubyMethod(name={"getpriority"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int result = recv2.getRuntime().getPosix().getpriority(which, who);
        return recv2.getRuntime().newFixnum(result);
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getuid());
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        int pid2 = -1;
        int flags = 0;
        if (args2.length > 0) {
            pid2 = (int)args2[0].convertToInteger().getLongValue();
        }
        if (args2.length > 1) {
            flags = (int)args2[1].convertToInteger().getLongValue();
        }
        int[] status2 = new int[1];
        pid2 = runtime2.getPosix().waitpid(pid2, status2, flags);
        if (pid2 == -1) {
            throw runtime2.newErrnoECHILDError();
        }
        return runtime2.newArray(runtime2.newFixnum(pid2), RubyStatus.newProcessStatus(runtime2, status2[0]));
    }

    @JRubyMethod(name={"initgroups"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#initgroups not yet implemented");
    }

    @JRubyMethod(name={"maxgroups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups_set not yet implemented");
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getppid());
    }

    @JRubyMethod(name={"gid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().setgid((int)arg2.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(recv2, args2);
    }

    @JRubyMethod(name={"euid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(IRubyObject recv2, IRubyObject arg2) {
        recv2.getRuntime().getPosix().seteuid((int)arg2.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod(name={"setpriority"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int prio = (int)arg3.convertToInteger().getLongValue();
        int result = recv2.getRuntime().getPosix().setpriority(which, who, prio);
        return recv2.getRuntime().newFixnum(result);
    }

    @JRubyMethod(name={"setpgid"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        int pid2 = (int)arg1.convertToInteger().getLongValue();
        int gid2 = (int)arg2.convertToInteger().getLongValue();
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().setpgid(pid2, gid2));
    }

    @JRubyMethod(name={"getpgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getpgid((int)arg2.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"getrlimit"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#getrlimit not yet implemented");
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getegid());
    }

    private static int parseSignalString(Ruby runtime2, String value2) {
        boolean signalString;
        int startIndex = 0;
        boolean negative = value2.startsWith("-");
        if (negative) {
            ++startIndex;
        }
        if (signalString = value2.startsWith("SIG", startIndex)) {
            startIndex += 3;
        }
        String signalName = value2.substring(startIndex);
        for (int i = 0; i < signals.length; ++i) {
            if (!signals[i].equals(signalName)) continue;
            return negative ? -i : i;
        }
        throw runtime2.newArgumentError("unsupported name `SIG" + signalName + "'");
    }

    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(IRubyObject recv2, IRubyObject[] args2) {
        boolean processGroupKill;
        if (args2.length < 2) {
            throw recv2.getRuntime().newArgumentError("wrong number of arguments -- kill(sig, pid...)");
        }
        Ruby runtime2 = recv2.getRuntime();
        int signal2 = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubySymbol ? RubyProcess.parseSignalString(runtime2, args2[0].toString()) : (args2[0] instanceof RubyString ? RubyProcess.parseSignalString(runtime2, args2[0].toString()) : RubyProcess.parseSignalString(runtime2, args2[0].checkStringType().toString())));
        boolean bl = processGroupKill = signal2 < 0;
        if (processGroupKill) {
            signal2 = -signal2;
        }
        POSIX posix = runtime2.getPosix();
        for (int i = 1; i < args2.length; ++i) {
            int pid2 = RubyNumeric.num2int(args2[i]);
            if (pid2 == 0) {
                pid2 = runtime2.getPosix().getpid();
            }
            posix.kill(processGroupKill ? -pid2 : pid2, signal2);
        }
        return runtime2.newFixnum(args2.length - 1);
    }

    @JRubyMethod(name={"detach"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        final int pid2 = (int)arg2.convertToInteger().getLongValue();
        Ruby runtime2 = recv2.getRuntime();
        BlockCallback callback = new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                int[] status2 = new int[1];
                int result = context.getRuntime().getPosix().waitpid(pid2, status2, 0);
                return context.getRuntime().newFixnum(result);
            }
        };
        return RubyThread.newInstance(runtime2.getThread(), IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(recv2, (RubyModule)recv2, Arity.NO_ARGUMENTS, callback, context));
    }

    @JRubyMethod(name={"times"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(IRubyObject recv2, Block unusedBlock) {
        boolean gotTime = false;
        double userTime = 0.0;
        double systemTime = 0.0;
        double realTime = 0.0;
        try {
            if (threadBean != null && threadBean.isThreadCpuTimeSupported() && threadBean.isThreadCpuTimeEnabled()) {
                long[] threads;
                for (long id2 : threads = threadBean.getAllThreadIds()) {
                    long uTime = threadBean.getThreadUserTime(id2);
                    long sTime = threadBean.getThreadCpuTime(id2) - uTime;
                    if (uTime != -1L) {
                        userTime += (double)uTime / 1.0E9;
                    }
                    if (sTime < 0L) continue;
                    systemTime += (double)sTime / 1.0E9;
                }
                gotTime = true;
            }
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Ruby runtime2 = recv2.getRuntime();
        if (!gotTime) {
            double currentTime = (double)System.currentTimeMillis() / 1000.0;
            double startTime = (double)runtime2.getStartTime() / 1000.0;
            systemTime = 0.0;
            userTime = currentTime - startTime;
        }
        RubyFloat zero = runtime2.newFloat(0.0);
        return RubyStruct.newStruct(runtime2.getTmsStruct(), new IRubyObject[]{runtime2.newFloat(userTime), runtime2.newFloat(systemTime), zero, zero}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(recv2.getRuntime().getPosix().getpid());
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit(recv2, args2);
    }

    @JRubyModule(name={"Process::Sys"})
    public static class Sys {
        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(IRubyObject self) {
            return RubyProcess.egid(self);
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(IRubyObject self) {
            return RubyProcess.euid(self);
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(IRubyObject self) {
            return RubyProcess.gid(self);
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(IRubyObject self) {
            return RubyProcess.uid(self);
        }

        @JRubyMethod(name={"setegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(recv2, arg2);
        }

        @JRubyMethod(name={"seteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(recv2, arg2);
        }

        @JRubyMethod(name={"setgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(recv2, arg2);
        }

        @JRubyMethod(name={"setuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(recv2, arg2);
        }
    }

    @JRubyModule(name={"Process::GID"})
    public static class GroupID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::GID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject self) {
            return RubyProcess.egid(self);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(IRubyObject self, IRubyObject arg2) {
            return RubyProcess.egid_set(self, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return GroupID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject self) {
            return RubyProcess.gid(self);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime2 = self.getRuntime();
            int gid2 = runtime2.getPosix().getgid();
            int egid2 = runtime2.getPosix().getegid();
            if (block.isGiven()) {
                try {
                    runtime2.getPosix().setegid(gid2);
                    runtime2.getPosix().setgid(egid2);
                    IRubyObject iRubyObject = block.yield(context, runtime2.getNil());
                    return iRubyObject;
                }
                finally {
                    runtime2.getPosix().setegid(egid2);
                    runtime2.getPosix().setgid(gid2);
                }
            }
            runtime2.getPosix().setegid(gid2);
            runtime2.getPosix().setgid(egid2);
            return RubyFixnum.zero(runtime2);
        }
    }

    @JRubyModule(name={"Process::UID"})
    public static class UserID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::UID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject self) {
            return RubyProcess.euid(self);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(IRubyObject self, IRubyObject arg2) {
            return RubyProcess.euid_set(self, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return UserID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject self) {
            return RubyProcess.uid(self);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime2 = self.getRuntime();
            int uid2 = runtime2.getPosix().getuid();
            int euid2 = runtime2.getPosix().geteuid();
            if (block.isGiven()) {
                try {
                    runtime2.getPosix().seteuid(uid2);
                    runtime2.getPosix().setuid(euid2);
                    IRubyObject iRubyObject = block.yield(context, runtime2.getNil());
                    return iRubyObject;
                }
                finally {
                    runtime2.getPosix().seteuid(euid2);
                    runtime2.getPosix().setuid(uid2);
                }
            }
            runtime2.getPosix().seteuid(uid2);
            runtime2.getPosix().setuid(euid2);
            return RubyFixnum.zero(runtime2);
        }
    }

    @JRubyClass(name={"Process::Status"})
    public static class RubyStatus
    extends RubyObject {
        private long status = 0L;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby runtime2, RubyClass metaClass, long status2) {
            super(runtime2, metaClass);
            this.status = status2;
        }

        public static RubyStatus newProcessStatus(Ruby runtime2, long status2) {
            return new RubyStatus(runtime2, runtime2.getProcStatus(), status2);
        }

        @JRubyMethod(name={"to_int", "pid", "stopped?", "stopsig", "signaled?", "termsig?", "exited?", "coredump?"})
        public IRubyObject not_implemented() {
            String error = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error);
        }

        @JRubyMethod(name={"&"})
        public IRubyObject not_implemented1(IRubyObject arg2) {
            String error = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error);
        }

        @JRubyMethod
        public IRubyObject exitstatus() {
            return this.getRuntime().newFixnum(this.status);
        }

        @JRubyMethod(name={">>"})
        public IRubyObject op_rshift(IRubyObject other) {
            long shiftValue = other.convertToInteger().getLongValue();
            return this.getRuntime().newFixnum(this.status >> (int)shiftValue);
        }

        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
            return other.callMethod(context, "==", this.to_i());
        }

        @JRubyMethod
        public IRubyObject to_i() {
            return this.getRuntime().newFixnum(this.shiftedValue());
        }

        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString(String.valueOf(this.shiftedValue()));
        }

        @JRubyMethod
        public IRubyObject inspect() {
            return this.getRuntime().newString("#<Process::Status: pid=????,exited(" + String.valueOf(this.status) + ")>");
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p() {
            return this.getRuntime().newBoolean(this.status == 0L);
        }

        private long shiftedValue() {
            return this.status << 8;
        }
    }
}

