/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
CoreObjectType,
InstanceVariables,
InternalVariables {
    protected transient RubyClass metaClass;
    protected int flags;
    protected transient Object dataStruct;
    private transient Finalizer finalizer;
    protected volatile transient VariableTableEntry[] variableTable;
    protected transient int variableTableSize;
    protected transient int variableTableThreshold;
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int FL_USHIFT = 4;
    public static final int USER0_F = 16;
    public static final int USER1_F = 32;
    public static final int USER2_F = 64;
    public static final int USER3_F = 128;
    public static final int USER4_F = 256;
    public static final int USER5_F = 512;
    public static final int USER6_F = 1024;
    public static final int USER7_F = 2048;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicObject(runtime2, klass);
        }
    };
    protected static final int VARIABLE_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int VARIABLE_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float VARIABLE_TABLE_LOAD_FACTOR = 0.75f;
    protected static final VariableTableEntry[] VARIABLE_TABLE_EMPTY_TABLE = new VariableTableEntry[0];

    private RubyBasicObject() {
    }

    public static RubyClass createBasicObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.defineAnnotatedMethods(RubyBasicObject.class);
        return objectClass;
    }

    public RubyBasicObject(Ruby runtime2, RubyClass metaClass) {
        assert (metaClass != null) : "NULL Metaclass!!?!?!";
        this.metaClass = metaClass;
        if (runtime2.isObjectSpaceEnabled()) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
        if (canBeTainted && runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    private void addToObjectSpace(Ruby runtime2) {
        assert (runtime2.isObjectSpaceEnabled());
        runtime2.getObjectSpace().add(this);
    }

    protected void taint(Ruby runtime2) {
        runtime2.secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2 + " " + this.getMetaClass().getName());
        }
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    @Deprecated
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean taint2) {
        this.flags = taint2 ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass);
        this.setMetaClass(klass);
        klass.setAttached(this);
        klass.setMetaClass(superClass.getRealClass().getMetaClass());
        superClass.addSubclass(klass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public RubyClass getType() {
        return this.getMetaClass().getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name2, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(name2)).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public Class getJavaClass() {
        if (this.dataGetStruct() instanceof JavaObject) {
            return ((JavaObject)this.dataGetStruct()).getValue().getClass();
        }
        return this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject asString = this.checkStringType();
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    @Override
    public RubyString asString() {
        IRubyObject str = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)TypeConverter.convertToType(this, this.getRuntime().getArray(), "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)TypeConverter.convertToType(this, this.getRuntime().getHash(), "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)TypeConverter.convertToType(this, this.getRuntime().getFloat(), "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger("to_int");
    }

    @Override
    @Deprecated
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject val = TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getInteger(), convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)TypeConverter.convertToType(this, this.getRuntime().getString(), "to_str");
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(this.getRuntime());
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getArray(), "to_ary");
    }

    @Override
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup2 = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        RubyBasicObject.initCopy(dup2, this);
        return dup2;
    }

    private static void initCopy(IRubyObject clone, IRubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original.getVariableList());
        }
        if (original instanceof RubyModule) {
            ((RubyModule)clone).syncConstants((RubyModule)original);
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    @Override
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyObject clone = (RubyObject)this.getMetaClass().getRealClass().allocate();
        clone.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone.setTaint(true);
        }
        RubyBasicObject.initCopy(clone, this);
        if (this.isFrozen()) {
            clone.setFrozen(true);
        }
        return clone;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime());
        clone.flags = this.flags;
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        clone.setSuperClass(klass.getSuperClass());
        if (klass.hasVariables()) {
            clone.syncVariables(klass.getVariableList());
        }
        clone.syncConstants(klass);
        klass.cloneMethods(clone);
        ((MetaClass)clone.getMetaClass()).setAttached(clone);
        clone.setAttached(((MetaClass)klass).getAttached());
        return clone;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        this.dataStruct = obj;
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    @Override
    public synchronized IRubyObject id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables()) {
            StringBuilder part = new StringBuilder();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (runtime2.isInspecting(this)) {
                part.append(" ...>");
                return runtime2.newString(part.toString());
            }
            try {
                runtime2.registerInspecting(this);
                RubyString rubyString = runtime2.newString(this.inspectObj(part).toString());
                return rubyString;
            }
            finally {
                runtime2.unregisterInspecting(this);
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return RuntimeHelpers.invoke(runtime2.getCurrentContext(), this, "to_s");
    }

    private StringBuilder inspectObj(StringBuilder part) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        String sep = "";
        for (Variable<IRubyObject> ivar : this.getInstanceVariableList()) {
            part.append(sep).append(" ").append(ivar.getName()).append("=");
            part.append(ivar.getValue().callMethod(context, "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    @JRubyMethod(name={"!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not(ThreadContext context) {
        return context.getRuntime().newBoolean(!this.isTrue());
    }

    @JRubyMethod(name={"!="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(!RubyBasicObject.equalInternal(context, this, other));
    }

    @Override
    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(RubyBasicObject.equalInternal(context, this, other));
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || that.callMethod(context, "==", other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "eql?", other).isTrue();
    }

    @Override
    public void addFinalizer(IRubyObject finalizer) {
        if (this.finalizer == null) {
            this.finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.getRuntime().addFinalizer(this.finalizer);
        }
        this.finalizer.addFinalizer(finalizer);
    }

    @Override
    public void removeFinalizers() {
        if (this.finalizer != null) {
            this.finalizer.removeFinalizers();
            this.finalizer = null;
            this.getRuntime().removeFinalizer(this.finalizer);
        }
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                IRubyObject readValue = e.value;
                if (readValue == null) {
                    readValue = this.variableTableReadLocked(e);
                }
                list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list2 = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                list2.add(e.name);
                e = e.next;
            }
        }
        return list2;
    }

    @Deprecated
    public Map getVariableMap() {
        return this.variableTableGetMap();
    }

    protected static final boolean isRubyVariable(String name2) {
        char c;
        return name2.length() > 0 && ((c = name2.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    protected synchronized IRubyObject variableTableReadLocked(VariableTableEntry entry) {
        return entry.value;
    }

    protected boolean variableTableContains(String name2) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int hash2 = name2.hashCode();
            VariableTableEntry e = table[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected boolean variableTableFastContains(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected IRubyObject variableTableFetch(String name2) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int hash2 = name2.hashCode();
            VariableTableEntry e = table[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue != null) {
                        return readValue;
                    }
                    return this.variableTableReadLocked(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    protected IRubyObject variableTableFastFetch(String internedName) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    IRubyObject readValue = e.value;
                    if (readValue != null) {
                        return readValue;
                    }
                    return this.variableTableReadLocked(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableStore(String name2, IRubyObject value2) {
        int hash2 = name2.hashCode();
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash2 & 7] = e = new VariableTableEntry(hash2, name2.intern(), value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value2;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    e.value = value2;
                    return value2;
                }
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, name2.intern(), value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value2) {
        if (IdUtil.isConstant(internedName)) {
            new Exception().printStackTrace();
        }
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash2 = internedName.hashCode();
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash2 & 7] = e = new VariableTableEntry(hash2, internedName, value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value2;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                if (internedName == e.name) {
                    e.value = value2;
                    return value2;
                }
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, internedName, value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableRemove(String name2) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable != null) {
                VariableTableEntry first2;
                int hash2 = name2.hashCode();
                int index2 = hash2 & table.length - 1;
                VariableTableEntry e = first2 = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && name2.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        VariableTableEntry newFirst = e.next;
                        VariableTableEntry p2 = first2;
                        while (p2 != e) {
                            newFirst = new VariableTableEntry(p2.hash, p2.name, p2.value, newFirst);
                            p2 = p2.next;
                        }
                        table[index2] = newFirst;
                        --this.variableTableSize;
                        this.variableTable = table;
                        return oldValue;
                    }
                    e = e.next;
                }
            }
        }
        return null;
    }

    protected VariableTableEntry[] variableTableGetTable() {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            return table;
        }
        return VARIABLE_TABLE_EMPTY_TABLE;
    }

    protected int variableTableGetSize() {
        if (this.variableTable != null) {
            return this.variableTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    protected final VariableTableEntry[] variableTableRehash() {
        VariableTableEntry[] oldTable = this.variableTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        VariableTableEntry[] newTable = new VariableTableEntry[newCapacity];
        this.variableTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            int k;
            VariableTableEntry e = oldTable[i];
            if (e == null) continue;
            VariableTableEntry next2 = e.next;
            int idx = e.hash & sizeMask;
            if (next2 == null) {
                newTable[idx] = e;
                continue;
            }
            VariableTableEntry lastRun = e;
            int lastIdx = idx;
            VariableTableEntry last2 = next2;
            while (last2 != null) {
                k = last2.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last2;
                }
                last2 = last2.next;
            }
            newTable[lastIdx] = lastRun;
            VariableTableEntry p2 = e;
            while (p2 != lastRun) {
                VariableTableEntry m;
                k = p2.hash & sizeMask;
                newTable[k] = m = new VariableTableEntry(p2.hash, p2.name, p2.value, newTable[k]);
                p2 = p2.next;
            }
        }
        this.variableTable = newTable;
        return newTable;
    }

    protected Map variableTableGetMap() {
        HashMap<String, IRubyObject> map = new HashMap<String, IRubyObject>();
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int i = table.length;
            while (--i >= 0) {
                VariableTableEntry e = table[i];
                while (e != null) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    map.put(e.name, readValue);
                    e = e.next;
                }
            }
        }
        return map;
    }

    protected Map variableTableGetMap(Map map) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int i = table.length;
            while (--i >= 0) {
                VariableTableEntry e = table[i];
                while (e != null) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    map.put(e.name, readValue);
                    e = e.next;
                }
            }
        }
        return map;
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInternalVariable(String internedName) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInternalVariable(String internedName) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public void setInternalVariable(String name2, IRubyObject value2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public void fastSetInternalVariable(String internedName, IRubyObject value2) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    public List<Variable<IRubyObject>> getInternalVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (!RubyBasicObject.isRubyVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(name2) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(internedName) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        this.ensureInstanceVariablesSettable();
        return this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list2 = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    list2.add(e.name);
                }
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public void copyInstanceVariablesInto(InstanceVariables other) {
        VariableTableEntry[] table = this.variableTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    other.setInstanceVariable(e.name, e.value);
                }
                e = e.next;
            }
        }
    }

    protected void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public int getNativeTypeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class Finalizer
    implements Finalizable {
        private long id;
        private List<IRubyObject> finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.finalizers == null) {
                this.finalizers = new ArrayList<IRubyObject>();
            }
            this.finalizers.add(finalizer);
        }

        public void removeFinalizers() {
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true) && this.finalizers != null) {
                for (int i = 0; i < this.finalizers.size(); ++i) {
                    IRubyObject finalizer = this.finalizers.get(i);
                    RuntimeHelpers.invoke(finalizer.getRuntime().getCurrentContext(), finalizer, "call", RubyBasicObject.this.id());
                }
            }
        }
    }

    protected static final class VariableTableEntry {
        final int hash;
        final String name;
        volatile IRubyObject value;
        final VariableTableEntry next;

        VariableTableEntry(int hash2, String name2, IRubyObject value2, VariableTableEntry next2) {
            assert (name2 == name2.intern()) : name2 + " is not interned";
            this.hash = hash2;
            this.name = name2;
            this.value = value2;
            this.next = next2;
        }
    }

    public static class BasicObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
        public static IRubyObject intialize(IRubyObject self) {
            return self.getRuntime().getNil();
        }
    }
}

