/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.unicode.UnicodeEncoding;

abstract class BaseUTF8Encoding
extends UnicodeEncoding {
    static final boolean USE_INVALID_CODE_SCHEME = true;
    private static final int INVALID_CODE_FE = -2;
    private static final int INVALID_CODE_FF = -1;

    protected BaseUTF8Encoding(int[] EncLen, int[][] Trans) {
        super(1, 6, EncLen, Trans);
    }

    public String toString() {
        return "UTF-8";
    }

    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 < end2 && bytes[p2] == 10;
    }

    public int codeToMbcLength(int code) {
        if ((code & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((code & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((code & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((code & 0xFFE00000) == 0) {
            return 4;
        }
        if ((code & 0xFC000000) == 0) {
            return 5;
        }
        if ((code & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        if (code == -2) {
            return 1;
        }
        if (code == -1) {
            return 1;
        }
        throw new EncodingException("invalid code point value");
    }

    public int mbcToCode(byte[] bytes, int p2, int end2) {
        int len = this.length(bytes, p2, end2);
        int c = bytes[p2++] & 0xFF;
        if (len > 1) {
            int n = c & (1 << 6 - --len) - 1;
            while (len-- != 0) {
                c = bytes[p2++] & 0xFF;
                n = n << 6 | c & 0x3F;
            }
            return n;
        }
        if (c > 253) {
            return c == 254 ? -2 : -1;
        }
        return c;
    }

    static byte trailS(int code, int shift2) {
        return (byte)(code >>> shift2 & 0x3F | 0x80);
    }

    static byte trail0(int code) {
        return (byte)(code & 0x3F | 0x80);
    }

    public int codeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFFFFFF80) == 0) {
            bytes[p_] = (byte)code;
            return 1;
        }
        if ((code & 0xFFFFF800) == 0) {
            bytes[p_++] = (byte)(code >>> 6 & 0x1F | 0xC0);
        } else if ((code & 0xFFFF0000) == 0) {
            bytes[p_++] = (byte)(code >>> 12 & 0xF | 0xE0);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 6);
        } else if ((code & 0xFFE00000) == 0) {
            bytes[p_++] = (byte)(code >>> 18 & 7 | 0xF0);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 12);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 6);
        } else if ((code & 0xFC000000) == 0) {
            bytes[p_++] = (byte)(code >>> 24 & 3 | 0xF8);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 18);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 12);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 6);
        } else if ((code & Integer.MIN_VALUE) == 0) {
            bytes[p_++] = (byte)(code >>> 30 & 1 | 0xFC);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 24);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 18);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 12);
            bytes[p_++] = BaseUTF8Encoding.trailS(code, 6);
        } else {
            if (code == -2) {
                bytes[p_] = -2;
                return 1;
            }
            if (code == -1) {
                bytes[p_] = -1;
                return 1;
            }
            throw new EncodingException("too big wide-char value");
        }
        bytes[p_++] = BaseUTF8Encoding.trail0(code);
        return p_ - p2;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value++;
        int foldP = 0;
        if (BaseUTF8Encoding.isMbcAscii(bytes[p2])) {
            fold[foldP] = AsciiTables.ToLowerCaseTable[bytes[p2] & 0xFF];
            return 1;
        }
        return super.mbcCaseFold(flag, bytes, pp, end2, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 128;
        return super.ctypeCodeRange(ctype);
    }

    private static boolean utf8IsLead(int c) {
        return (c & 0xC0 & 0xFF) != 128;
    }

    public int leftAdjustCharHead(byte[] bytes, int p2, int s, int end2) {
        int p_;
        if (s <= p2) {
            return s;
        }
        for (p_ = s; !BaseUTF8Encoding.utf8IsLead(bytes[p_] & 0xFF) && p_ > p2; --p_) {
        }
        return p_;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        return true;
    }
}

