/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIPSocket(runtime2, klass);
        }
    };

    static void createIPSocket(Ruby runtime2) {
        RubyClass rb_cIPSocket = runtime2.defineClass("IPSocket", runtime2.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        runtime2.getObject().fastSetConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected static RuntimeException sockerr(Ruby runtime2, String msg) {
        return new RaiseException(runtime2, runtime2.fastGetClass("SocketError"), msg, true);
    }

    private IRubyObject addrFor(Ruby r, InetSocketAddress addr2) {
        IRubyObject[] ret = new IRubyObject[]{r.newString("AF_INET"), r.newFixnum(addr2.getPort()), r.isDoNotReverseLookupEnabled() ? r.newString(addr2.getAddress().getHostAddress()) : r.newString(addr2.getHostName()), r.newString(addr2.getAddress().getHostAddress())};
        return r.newArrayNoCopy(ret);
    }

    @Deprecated
    public IRubyObject addr() {
        return this.addr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        InetSocketAddress address2 = this.getLocalSocket();
        if (address2 == null) {
            throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(context.getRuntime(), address2);
    }

    @Deprecated
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        InetSocketAddress address2 = this.getRemoteSocket();
        if (address2 == null) {
            throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(context.getRuntime(), address2);
    }

    @Deprecated
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        return RubyIPSocket.getaddress(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            return context.getRuntime().newString(InetAddress.getByName(hostname.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw RubyIPSocket.sockerr(context.getRuntime(), "getaddress: name or service not known");
        }
    }
}

