/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.util;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.util.ASMifierClassVisitor;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class HandleFactory {
    private static final boolean DEBUG = false;

    public static Handle createHandle(JRubyClassLoader classLoader, Method method2, boolean debug) {
        ClassVisitor cv = debug ? new ASMifierClassVisitor(new PrintWriter(System.out)) : new ClassWriter(1);
        Class<?> returnType = method2.getReturnType();
        Class[] paramTypes = method2.getParameterTypes();
        String name2 = "H" + (method2.getName() + CodegenUtils.pretty(returnType, paramTypes)).hashCode();
        try {
            Class<?> existing = classLoader.loadClass(name2);
            return (Handle)existing.newInstance();
        }
        catch (Exception e) {
            String signature;
            cv.visit(49, 49, name2, null, CodegenUtils.p(Handle.class), null);
            switch (paramTypes.length) {
                case 0: {
                    signature = CodegenUtils.sig(Object.class, Object.class);
                    break;
                }
                case 1: {
                    signature = CodegenUtils.sig(Object.class, Object.class, Object.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class, Object.class);
                    break;
                }
                default: {
                    signature = CodegenUtils.sig(Object.class, Object.class, Object[].class);
                }
            }
            SkinnyMethodAdapter m = new SkinnyMethodAdapter(cv.visitMethod(4113, "invoke", signature, null, null));
            m.start();
            if (!Modifier.isStatic(method2.getModifiers())) {
                m.aload(1);
                if (method2.getDeclaringClass() != Object.class) {
                    m.checkcast(CodegenUtils.p(method2.getDeclaringClass()));
                }
            }
            switch (paramTypes.length) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int i;
                    for (i = 0; i < paramTypes.length; ++i) {
                        HandleFactory.loadUnboxedArgument(m, i + 2, paramTypes[i]);
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < paramTypes.length; ++i) {
                        m.aload(2);
                        m.pushInt(i);
                        m.aaload();
                        Class paramClass = paramTypes[i];
                        if (paramClass.isPrimitive()) {
                            Class boxType = HandleFactory.getBoxType(paramClass);
                            m.checkcast(CodegenUtils.p(boxType));
                            m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
                            continue;
                        }
                        if (paramClass == Object.class) continue;
                        m.checkcast(CodegenUtils.p(paramClass));
                    }
                }
            }
            if (Modifier.isStatic(method2.getModifiers())) {
                m.invokestatic(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
            } else if (Modifier.isInterface(method2.getDeclaringClass().getModifiers())) {
                m.invokeinterface(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
            } else {
                m.invokevirtual(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
            }
            if (returnType == Void.TYPE) {
                m.aload(1);
            } else if (returnType.isPrimitive()) {
                Class boxType = HandleFactory.getBoxType(returnType);
                m.invokestatic(CodegenUtils.p(boxType), "valueOf", CodegenUtils.sig(boxType, returnType));
            }
            m.areturn();
            m.end();
            m = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
            m.start();
            m.aload(0);
            m.invokespecial(CodegenUtils.p(Handle.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            m.voidreturn();
            m.end();
            cv.visitEnd();
            if (debug) {
                ((ASMifierClassVisitor)cv).print(new PrintWriter(System.out));
                return HandleFactory.createHandle(classLoader, method2, false);
            }
            byte[] bytes = ((ClassWriter)cv).toByteArray();
            Class<?> handleClass = (classLoader != null ? classLoader : new JRubyClassLoader(JRubyClassLoader.class.getClassLoader())).defineClass(name2, bytes);
            try {
                return (Handle)handleClass.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static void loadUnboxedArgument(SkinnyMethodAdapter m, int index2, Class type2) {
        m.aload(index2);
        HandleFactory.unboxAndCast(m, type2);
    }

    public static void unboxAndCast(SkinnyMethodAdapter m, Class paramClass) {
        if (paramClass.isPrimitive()) {
            Class boxType = HandleFactory.getBoxType(paramClass);
            m.checkcast(CodegenUtils.p(boxType));
            m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
        } else if (paramClass != Object.class) {
            m.checkcast(CodegenUtils.p(paramClass));
        }
    }

    public static Handle createHandle(JRubyClassLoader classLoader, Method method2) {
        return HandleFactory.createHandle(classLoader, method2, false);
    }

    protected static Class getBoxType(Class type2) {
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Not a native type: " + type2);
    }

    public static void main(String[] args2) {
        try {
            Method method2 = HandleFactory.class.getMethod("dummy", String.class);
            Handle handle = HandleFactory.createHandle(null, method2);
            String prop1 = "java.class.path";
            String prop2 = "";
            for (int i = 0; i < 10; ++i) {
                String tmp;
                Object result;
                int j;
                System.out.print("handle invocation: ");
                long time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result = handle.invoke((Object)null, (Object)prop1);
                    if (j % 10000000 == 0) {
                        System.out.println(result);
                    }
                    handle.invoke((Object)null, (Object)prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                }
                System.out.println(System.currentTimeMillis() - time);
                System.out.print("reflected invocation: ");
                time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result = method2.invoke(null, prop1);
                    if (j % 10000000 == 0) {
                        System.out.println(result);
                    }
                    method2.invoke(null, prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time);
                System.out.print("method invocation: ");
                time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result = HandleFactory.dummy(prop1);
                    if (j % 10000000 == 0) {
                        System.out.println(result);
                    }
                    HandleFactory.dummy(prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String dummy(String str) {
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    public static int dummy2() {
        return 1;
    }

    public static Object dummy3(Object obj) {
        return obj;
    }

    public static class Handle {
        private Error fail() {
            return new AbstractMethodError("invalid call signature for target method");
        }

        public Object invoke(Object receiver2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1, Object arg2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object ... args2) {
            throw this.fail();
        }
    }
}

