/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.yaml.JRubyConstructor;
import org.jruby.yaml.JRubyRepresenter;
import org.jruby.yaml.JRubySerializer;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.EmitterImpl;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Position;
import org.jvyamlb.Positionable;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.exceptions.YAMLException;

@JRubyModule(name={"YAML"})
public class RubyYAML {
    private static final Pattern AFTER_NEWLINE = Pattern.compile("\n.+", 32);

    public static RubyModule createYAMLModule(Ruby runtime2) {
        RubyModule result = runtime2.defineModule("YAML");
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", runtime2.newString("stringio"));
        result.defineAnnotatedMethods(RubyYAML.class);
        RubyClass obj = runtime2.getObject();
        RubyClass clazz = runtime2.getClassClass();
        RubyClass hash2 = runtime2.getHash();
        RubyClass array = runtime2.getArray();
        RubyClass struct = runtime2.getStructClass();
        RubyClass exception2 = runtime2.getException();
        RubyClass string2 = runtime2.getString();
        RubyClass symbol = runtime2.getSymbol();
        RubyClass range = runtime2.getRange();
        RubyClass regexp = runtime2.getRegexp();
        RubyClass time = runtime2.getTime();
        RubyClass date = runtime2.fastGetClass("Date");
        RubyClass fixnum = runtime2.getFixnum();
        RubyClass bignum = runtime2.getBignum();
        RubyClass flt = runtime2.getFloat();
        RubyClass trueClass = runtime2.getTrueClass();
        RubyClass falseClass = runtime2.getFalseClass();
        RubyClass nilClass = runtime2.getNilClass();
        clazz.defineAnnotatedMethods(YAMLClassMethods.class);
        obj.defineAnnotatedMethods(YAMLObjectMethods.class);
        hash2.defineAnnotatedMethods(YAMLHashMethods.class);
        array.defineAnnotatedMethods(YAMLArrayMethods.class);
        struct.defineAnnotatedMethods(YAMLStructMethods.class);
        exception2.defineAnnotatedMethods(YAMLExceptionMethods.class);
        string2.defineAnnotatedMethods(YAMLStringMethods.class);
        symbol.defineAnnotatedMethods(YAMLSymbolMethods.class);
        range.defineAnnotatedMethods(YAMLRangeMethods.class);
        regexp.defineAnnotatedMethods(YAMLRegexpMethods.class);
        time.defineAnnotatedMethods(YAMLTimeMethods.class);
        date.defineAnnotatedMethods(YAMLDateMethods.class);
        bignum.defineAnnotatedMethods(YAMLNumericMethods.class);
        fixnum.defineAnnotatedMethods(YAMLNumericMethods.class);
        flt.defineAnnotatedMethods(YAMLNumericMethods.class);
        trueClass.defineAnnotatedMethods(YAMLTrueMethods.class);
        falseClass.defineAnnotatedMethods(YAMLFalseMethods.class);
        nilClass.defineAnnotatedMethods(YAMLNilMethods.class);
        runtime2.setObjectToYamlMethod(runtime2.getObject().searchMethod("to_yaml"));
        return result;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(IRubyObject self, IRubyObject[] args2) {
        IRubyObject obj = args2[0];
        Ruby runtime2 = self.getRuntime();
        RubyArray val = runtime2.newArray(obj);
        if (args2.length > 1) {
            return RuntimeHelpers.invoke(runtime2.getCurrentContext(), self, "dump_all", (IRubyObject)val, args2[1]);
        }
        return self.callMethod(runtime2.getCurrentContext(), "dump_all", val);
    }

    @JRubyMethod(name={"dump_all"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_all(IRubyObject self, IRubyObject[] args2) {
        ThreadContext context = self.getRuntime().getCurrentContext();
        RubyArray objs = (RubyArray)args2[0];
        IRubyObject io2 = null;
        IRubyObject io22 = null;
        if (args2.length == 2 && args2[1] != null && !args2[1].isNil()) {
            io2 = args2[1];
        }
        YAMLConfig cfg = YAML.config().version("1.0");
        IOOutputStream iox = null;
        if (null == io2) {
            io22 = self.getRuntime().fastGetClass("StringIO").callMethod(context, "new");
            iox = new IOOutputStream(io22);
        } else {
            iox = new IOOutputStream(io2);
        }
        JRubySerializer ser = new JRubySerializer(new EmitterImpl(iox, cfg), new ResolverImpl(), cfg);
        try {
            ser.open();
            JRubyRepresenter r = new JRubyRepresenter(ser, cfg);
            Iterator iter = objs.getList().iterator();
            while (iter.hasNext()) {
                r.represent(iter.next());
            }
            ser.close();
        }
        catch (IOException e) {
            throw self.getRuntime().newIOErrorFromException(e);
        }
        if (null == io2) {
            io22.callMethod(context, "rewind");
            return io22.callMethod(context, "read");
        }
        return io2;
    }

    @JRubyMethod(name={"_parse_internal"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject parse_internal(IRubyObject self, IRubyObject arg2) {
        boolean debug = self.getRuntime().getDebug().isTrue();
        IRubyObject io2 = RubyYAML.check_yaml_port(arg2);
        ScannerImpl scn = null;
        try {
            ComposerImpl ctor;
            scn = io2 instanceof RubyString ? (debug ? new PositioningScannerImpl(((RubyString)io2).getByteList()) : new ScannerImpl(((RubyString)io2).getByteList())) : (debug ? new PositioningScannerImpl(new IOInputStream(io2)) : new ScannerImpl(new IOInputStream(io2)));
            ComposerImpl composerImpl = ctor = debug ? new PositioningComposerImpl(new PositioningParserImpl((PositioningScanner)((Object)scn), YAML.config().version("1.0")), (Resolver)new ResolverImpl()) : new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl());
            if (ctor.checkNode()) {
                return JavaEmbedUtils.javaToRuby(self.getRuntime(), ctor.getNode());
            }
            return self.getRuntime().getNil();
        }
        catch (YAMLException e) {
            if (self.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)((Object)e)).getRange();
                throw self.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + e.getMessage());
            }
            throw self.getRuntime().newArgumentError("syntax error:" + e.getMessage());
        }
    }

    @JRubyMethod(name={"load"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject self, IRubyObject arg2) {
        boolean debug = self.getRuntime().getDebug().isTrue();
        IRubyObject io2 = RubyYAML.check_yaml_port(arg2);
        ScannerImpl scn = null;
        try {
            JRubyConstructor ctor;
            scn = io2 instanceof RubyString ? (debug ? new PositioningScannerImpl(((RubyString)io2).getByteList()) : new ScannerImpl(((RubyString)io2).getByteList())) : (debug ? new PositioningScannerImpl(new IOInputStream(io2)) : new ScannerImpl(new IOInputStream(io2)));
            JRubyConstructor jRubyConstructor = ctor = debug ? new JRubyConstructor(self, (Composer)new PositioningComposerImpl(new PositioningParserImpl((PositioningScanner)((Object)scn), YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(self, (Composer)new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl()));
            if (ctor.checkData()) {
                return JavaEmbedUtils.javaToRuby(self.getRuntime(), ctor.getData());
            }
            return self.getRuntime().getNil();
        }
        catch (YAMLException e) {
            if (self.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)((Object)e)).getRange();
                throw self.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + e.getMessage());
            }
            throw self.getRuntime().newArgumentError("syntax error:" + e.getMessage());
        }
    }

    @JRubyMethod(name={"load_file"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_file(IRubyObject self, IRubyObject arg2) {
        Ruby runtime2 = self.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", arg2, runtime2.newString("r"));
        IRubyObject val = self.callMethod(context, "load", io2);
        io2.callMethod(context, "close");
        return val;
    }

    @JRubyMethod(name={"each_document"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_document(IRubyObject self, IRubyObject arg2, Block block) {
        boolean debug = self.getRuntime().getDebug().isTrue();
        ThreadContext context = self.getRuntime().getCurrentContext();
        IRubyObject io2 = arg2;
        ScannerImpl scn = null;
        try {
            JRubyConstructor ctor;
            scn = io2 instanceof RubyString ? (debug ? new PositioningScannerImpl(((RubyString)io2).getByteList()) : new ScannerImpl(((RubyString)io2).getByteList())) : (debug ? new PositioningScannerImpl(new IOInputStream(io2)) : new ScannerImpl(new IOInputStream(io2)));
            JRubyConstructor jRubyConstructor = ctor = debug ? new JRubyConstructor(self, (Composer)new PositioningComposerImpl(new PositioningParserImpl((PositioningScanner)((Object)scn), YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(self, (Composer)new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl()));
            while (ctor.checkData()) {
                block.yield(context, JavaEmbedUtils.javaToRuby(self.getRuntime(), ctor.getData()));
            }
            return self.getRuntime().getNil();
        }
        catch (YAMLException e) {
            if (self.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)((Object)e)).getRange();
                throw self.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + e.getMessage());
            }
            throw self.getRuntime().newArgumentError("syntax error:" + e.getMessage());
        }
    }

    @JRubyMethod(name={"load_documents"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_documents(IRubyObject self, IRubyObject arg2, Block block) {
        boolean debug = self.getRuntime().getDebug().isTrue();
        ThreadContext context = self.getRuntime().getCurrentContext();
        IRubyObject io2 = RubyYAML.check_yaml_port(arg2);
        ScannerImpl scn = null;
        try {
            JRubyConstructor ctor;
            scn = io2 instanceof RubyString ? (debug ? new PositioningScannerImpl(((RubyString)io2).getByteList()) : new ScannerImpl(((RubyString)io2).getByteList())) : (debug ? new PositioningScannerImpl(new IOInputStream(io2)) : new ScannerImpl(new IOInputStream(io2)));
            JRubyConstructor jRubyConstructor = ctor = debug ? new JRubyConstructor(self, (Composer)new PositioningComposerImpl(new PositioningParserImpl((PositioningScanner)((Object)scn), YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(self, (Composer)new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl()));
            while (ctor.checkData()) {
                block.yield(context, JavaEmbedUtils.javaToRuby(self.getRuntime(), ctor.getData()));
            }
            return self.getRuntime().getNil();
        }
        catch (YAMLException e) {
            if (self.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)((Object)e)).getRange();
                throw self.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + e.getMessage());
            }
            throw self.getRuntime().newArgumentError("syntax error:" + e.getMessage());
        }
    }

    @JRubyMethod(name={"load_stream"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_stream(IRubyObject self, IRubyObject arg2) {
        boolean debug = self.getRuntime().getDebug().isTrue();
        ThreadContext context = self.getRuntime().getCurrentContext();
        IRubyObject d = self.getRuntime().getNil();
        IRubyObject io2 = arg2;
        ScannerImpl scn = null;
        try {
            JRubyConstructor ctor;
            scn = io2 instanceof RubyString ? (debug ? new PositioningScannerImpl(((RubyString)io2).getByteList()) : new ScannerImpl(((RubyString)io2).getByteList())) : (debug ? new PositioningScannerImpl(new IOInputStream(io2)) : new ScannerImpl(new IOInputStream(io2)));
            JRubyConstructor jRubyConstructor = ctor = debug ? new JRubyConstructor(self, (Composer)new PositioningComposerImpl(new PositioningParserImpl((PositioningScanner)((Object)scn), YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(self, (Composer)new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl()));
            while (ctor.checkData()) {
                if (d.isNil()) {
                    d = self.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(context, "new", d);
                }
                d.callMethod(context, "add", JavaEmbedUtils.javaToRuby(self.getRuntime(), ctor.getData()));
            }
            return d;
        }
        catch (YAMLException e) {
            if (self.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)((Object)e)).getRange();
                throw self.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + e.getMessage());
            }
            throw self.getRuntime().newArgumentError("syntax error:" + e.getMessage());
        }
    }

    @JRubyMethod(name={"dump_stream"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_stream(IRubyObject self, IRubyObject[] args2) {
        ThreadContext context = self.getRuntime().getCurrentContext();
        IRubyObject stream = self.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(context, "new");
        int j = args2.length;
        for (int i = 0; i < j; ++i) {
            stream.callMethod(context, "add", args2[i]);
        }
        return stream.callMethod(context, "emit");
    }

    @JRubyMethod(name={"quick_emit_node"}, required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject quick_emit_node(IRubyObject self, IRubyObject[] args2, Block block) {
        return block.yield(self.getRuntime().getCurrentContext(), args2[0]);
    }

    public static IRubyObject quick_emit(IRubyObject self, IRubyObject[] args2) {
        return self.getRuntime().getNil();
    }

    private static IRubyObject check_yaml_port(IRubyObject port) {
        if (!(port instanceof RubyString)) {
            if (port.respondsTo("read")) {
                if (port.respondsTo("binmode")) {
                    ThreadContext context = port.getRuntime().getCurrentContext();
                    port.callMethod(context, "binmode");
                }
            } else {
                throw port.getRuntime().newTypeError("instance of IO needed");
            }
        }
        return port;
    }

    @JRubyClass(name={"NilClass"})
    public static class YAMLNilMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject nil_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), (IRubyObject)self.getRuntime().newString(""), self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"FalseClass"})
    public static class YAMLFalseMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject false_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self.callMethod(context, "to_s"), self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject false_taguri(IRubyObject self) {
            return self.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    @JRubyClass(name={"TrueClass"})
    public static class YAMLTrueMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject true_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self.callMethod(context, "to_s"), self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject true_taguri(IRubyObject self) {
            return self.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    @JRubyClass(name={"Date"})
    public static class YAMLDateMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject date_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self.callMethod(context, "to_s"), self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Time"})
    public static class YAMLTimeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject time_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            IRubyObject tz = self.getRuntime().newString("Z");
            RubyString difference_sign = self.getRuntime().newString("-");
            if (!(self = self.dup()).callMethod(context, "utc?").isTrue()) {
                IRubyObject absolute_difference;
                IRubyObject utc_same_instant = self.callMethod(context, "utc");
                IRubyObject utc_same_writing = RuntimeHelpers.invoke(context, (IRubyObject)self.getRuntime().getTime(), "utc", new IRubyObject[]{self.callMethod(context, "year"), self.callMethod(context, "month"), self.callMethod(context, "day"), self.callMethod(context, "hour"), self.callMethod(context, "min"), self.callMethod(context, "sec"), self.callMethod(context, "usec")});
                IRubyObject difference_to_utc = utc_same_writing.callMethod(context, MethodIndex.OP_MINUS, "-", utc_same_instant);
                if (difference_to_utc.callMethod(context, MethodIndex.OP_LT, "<", RubyFixnum.zero(self.getRuntime())).isTrue()) {
                    difference_sign = self.getRuntime().newString("-");
                    absolute_difference = RubyFixnum.zero(self.getRuntime()).callMethod(context, MethodIndex.OP_MINUS, "-", difference_to_utc);
                } else {
                    difference_sign = self.getRuntime().newString("+");
                    absolute_difference = difference_to_utc;
                }
                IRubyObject difference_minutes = absolute_difference.callMethod(context, "/", self.getRuntime().newFixnum(60)).callMethod(context, "round");
                tz = self.getRuntime().newString("%s%02d:%02d").callMethod(context, "%", self.getRuntime().newArrayNoCopy(new IRubyObject[]{difference_sign, difference_minutes.callMethod(context, "/", self.getRuntime().newFixnum(60)), difference_minutes.callMethod(context, "%", self.getRuntime().newFixnum(60))}));
            }
            IRubyObject standard = self.callMethod(context, "strftime", self.getRuntime().newString("%Y-%m-%d %H:%M:%S"));
            if (self.callMethod(context, "usec").callMethod(context, "nonzero?").isTrue()) {
                standard = standard.callMethod(context, MethodIndex.OP_PLUS, "+", self.getRuntime().newString(".%06d").callMethod(context, "%", self.getRuntime().newArray(self.callMethod(context, "usec"))));
            }
            standard = standard.callMethod(context, MethodIndex.OP_PLUS, "+", self.getRuntime().newString(" %s").callMethod(context, "%", self.getRuntime().newArray(tz)));
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), standard, self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Regexp"})
    public static class YAMLRegexpMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject regexp_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self.callMethod(context, "inspect"), self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Range"})
    public static class YAMLRangeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject range_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            RubyHash mep = new RubyHash(self.getRuntime());
            mep.put(self.getRuntime().newString("begin"), self.callMethod(context, "begin"));
            mep.put(self.getRuntime().newString("end"), self.callMethod(context, "end"));
            mep.put(self.getRuntime().newString("excl"), self.callMethod(context, "exclude_end?"));
            Iterator iter = ((RubyArray)self.callMethod(context, "to_yaml_properties")).getList().iterator();
            while (iter.hasNext()) {
                String m = iter.next().toString();
                mep.put(self.getRuntime().newString(m.substring(1)), self.callMethod(context, "instance_variable_get", self.getRuntime().newString(m)));
            }
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), (IRubyObject)mep, self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Numeric"})
    public static class YAMLNumericMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject numeric_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            String val = self.toString();
            if ("Infinity".equals(val)) {
                val = ".Inf";
            } else if ("-Infinity".equals(val)) {
                val = "-.Inf";
            } else if ("NaN".equals(val)) {
                val = ".NaN";
            }
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), (IRubyObject)self.getRuntime().newString(val), self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Symbol"})
    public static class YAMLSymbolMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject symbol_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self.callMethod(context, "inspect"), self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject symbol_taguri(IRubyObject self) {
            return self.getRuntime().newString("tag:yaml.org,2002:str");
        }
    }

    @JRubyClass(name={"String"})
    public static class YAMLStringMethods {
        @JRubyMethod(name={"is_complex_yaml?"})
        public static IRubyObject string_is_complex(IRubyObject self) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return self.callMethod(context, "to_yaml_style").isTrue() || ((List)((Object)self.callMethod(context, "to_yaml_properties"))).isEmpty() || AFTER_NEWLINE.matcher(self.toString()).find() ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
        }

        @JRubyMethod(name={"is_binary_data?"})
        public static IRubyObject string_is_binary(IRubyObject self) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            if (self.callMethod(context, "empty?").isTrue()) {
                return self.getRuntime().getNil();
            }
            return self.toString().indexOf(0) != -1 ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
        }

        private static JRubyRepresenter into(IRubyObject arg2) {
            IRubyObject jobj = arg2.getInstanceVariables().fastGetInstanceVariable("@java_object");
            if (jobj != null) {
                return (JRubyRepresenter)((JavaObject)jobj).getValue();
            }
            return null;
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject string_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            Ruby rt = self.getRuntime();
            if (self.callMethod(context, "is_binary_data?").isTrue()) {
                return RuntimeHelpers.invoke(context, arg2, "scalar", (IRubyObject)rt.newString("tag:yaml.org,2002:binary"), rt.newArray(self).callMethod(context, "pack", rt.newString("m")), rt.newString("|"));
            }
            if (((List)((Object)self.callMethod(context, "to_yaml_properties"))).isEmpty()) {
                JRubyRepresenter rep = YAMLStringMethods.into(arg2);
                if (rep != null) {
                    try {
                        return JavaUtil.convertJavaToRuby(rt, rep.scalar(self.callMethod(context, "taguri").toString(), self.convertToString().getByteList(), self.toString().startsWith(":") ? "\"" : self.callMethod(context, "to_yaml_style").toString()));
                    }
                    catch (IOException e) {
                        throw rt.newIOErrorFromException(e);
                    }
                }
                return RuntimeHelpers.invoke(context, arg2, "scalar", self.callMethod(context, "taguri"), self, self.toString().startsWith(":") ? rt.newString("\"") : self.callMethod(context, "to_yaml_style"));
            }
            RubyHash mep = new RubyHash(self.getRuntime());
            mep.put(self.getRuntime().newString("str"), rt.newString(self.toString()));
            Iterator iter = ((RubyArray)self.callMethod(context, "to_yaml_properties")).getList().iterator();
            while (iter.hasNext()) {
                String m = iter.next().toString();
                mep.put(self.getRuntime().newString(m), self.callMethod(context, "instance_variable_get", self.getRuntime().newString(m)));
            }
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), (IRubyObject)mep, self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Exception"})
    public static class YAMLExceptionMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject exception_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            RubyHash mep = new RubyHash(self.getRuntime());
            mep.put(self.getRuntime().newString("message"), self.callMethod(context, "message"));
            Iterator iter = ((RubyArray)self.callMethod(context, "to_yaml_properties")).getList().iterator();
            while (iter.hasNext()) {
                String m = iter.next().toString();
                mep.put(self.getRuntime().newString(m.substring(1)), self.callMethod(context, "instance_variable_get", self.getRuntime().newString(m)));
            }
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), (IRubyObject)mep, self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject exception_taguri(IRubyObject self) {
            return self.getRuntime().newString("!ruby/exception:" + self.getType().getName());
        }
    }

    @JRubyClass(name={"Struct"})
    public static class YAMLStructMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject struct_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            RubyHash mep = new RubyHash(self.getRuntime());
            Iterator iter = ((RubyArray)self.callMethod(context, "members")).getList().iterator();
            while (iter.hasNext()) {
                RubyString key = self.getRuntime().newString(iter.next().toString());
                mep.put(key, self.callMethod(context, MethodIndex.AREF, "[]", key));
            }
            iter = ((RubyArray)self.callMethod(context, "to_yaml_properties")).getList().iterator();
            while (iter.hasNext()) {
                String m = iter.next().toString();
                mep.put(self.getRuntime().newString(m.substring(1)), self.callMethod(context, "instance_variable_get", self.getRuntime().newString(m)));
            }
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), (IRubyObject)mep, self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject struct_taguri(IRubyObject self) {
            return self.getRuntime().newString("!ruby/struct:" + self.getType().getName());
        }
    }

    @JRubyClass(name={"Array"})
    public static class YAMLArrayMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject array_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "seq", self.callMethod(context, "taguri"), self, self.callMethod(context, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Class"})
    public static class YAMLClassMethods {
        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject class_to_yaml(IRubyObject self, IRubyObject[] args2) {
            throw self.getRuntime().newTypeError("can't dump anonymous class " + self.getType().getName());
        }
    }

    @JRubyClass(name={"Object"})
    public static class YAMLObjectMethods {
        @JRubyMethod(name={"to_yaml_properties"})
        public static IRubyObject obj_to_yaml_properties(IRubyObject self) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return self.callMethod(context, "instance_variables").callMethod(context, "sort");
        }

        @JRubyMethod(name={"to_yaml_style"})
        public static IRubyObject obj_to_yaml_style(IRubyObject self) {
            return self.getRuntime().getNil();
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject obj_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            RubyHash mep = new RubyHash(self.getRuntime());
            RubyArray props = (RubyArray)self.callMethod(context, "to_yaml_properties");
            Iterator iter = props.getList().iterator();
            while (iter.hasNext()) {
                String m = iter.next().toString();
                mep.put(self.getRuntime().newString(m.substring(1)), self.callMethod(context, "instance_variable_get", self.getRuntime().newString(m)));
            }
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), (IRubyObject)mep, self.callMethod(context, "to_yaml_style"));
        }

        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject obj_to_yaml(IRubyObject self, IRubyObject[] args2) {
            ThreadContext context = self.getRuntime().getCurrentContext();
            return self.getRuntime().fastGetModule("YAML").callMethod(context, "dump", self);
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject obj_taguri(IRubyObject self) {
            return self.getRuntime().newString("!ruby/object:" + self.getType().getName());
        }
    }

    @JRubyClass(name={"Hash"})
    public static class YAMLHashMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject hash_to_yaml_node(IRubyObject self, IRubyObject arg2) {
            Ruby runtime2 = self.getRuntime();
            ThreadContext context = runtime2.getCurrentContext();
            return RuntimeHelpers.invoke(context, arg2, "map", self.callMethod(context, "taguri"), self, self.callMethod(context, "to_yaml_style"));
        }
    }
}

