/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CallSite {
    public final String methodName;
    protected final CallType callType;

    public CallSite(String methodName, CallType callType) {
        this.methodName = methodName;
        this.callType = callType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public static class GeCallSite
    extends InlineCachingCallSite {
        public GeCallSite() {
            super(">=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_ge(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class GtCallSite
    extends InlineCachingCallSite {
        public GtCallSite() {
            super(">", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_gt(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class LeCallSite
    extends InlineCachingCallSite {
        public LeCallSite() {
            super("<=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_le(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class LtCallSite
    extends InlineCachingCallSite {
        public LtCallSite() {
            super("<", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_lt(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class DivCallSite
    extends InlineCachingCallSite {
        public DivCallSite() {
            super("/", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_div(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class MulCallSite
    extends InlineCachingCallSite {
        public MulCallSite() {
            super("*", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_mul(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class MinusCallSite
    extends InlineCachingCallSite {
        public MinusCallSite() {
            super("-", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_minus(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class PlusCallSite
    extends InlineCachingCallSite {
        public PlusCallSite() {
            super("+", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_plus(context, arg2);
            }
            return super.call(context, self, arg2);
        }
    }

    public static class InlineCachingCallSite
    extends CallSite
    implements CacheMap.CacheSite {
        private static final CacheEntry NULL_CACHE = new CacheEntry(null, null);
        private volatile CacheEntry cache = NULL_CACHE;
        private int misses = 0;
        private static final int MAX_MISSES = 50;
        public static volatile int totalCallSites;
        public static volatile int failedCallSites;

        public InlineCachingCallSite(String methodName, CallType callType) {
            super(methodName, callType);
            ++totalCallSites;
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, args2, block);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMising(context, self, method2, args2);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, args2);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, selfType, this.methodName);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, block);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg2) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg2);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg2) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg2, block);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg1, arg2);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg1, arg2, block);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg1, arg2, arg3);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method2 = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method2, context)) {
                return this.callMethodMissing(context, self, method2, arg1, arg2, arg3, block);
            }
            this.updateCacheEntry(method2, selfType);
            return method2.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
        }

        private IRubyObject callMethodMising(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, args2, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg2) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg2, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, args2, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg2, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg2, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, arg3, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, arg3, context.getFrameSelf(), this.callType, block);
        }

        private boolean methodMissing(DynamicMethod method2, ThreadContext context) {
            return method2.isUndefined() || !this.methodName.equals("method_missing") && !method2.isCallableFrom(context.getFrameSelf(), this.callType);
        }

        private RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
            context.callThreadPoll();
            RubyClass selfType = self.getMetaClass();
            return selfType;
        }

        private void updateCacheEntry(DynamicMethod method2, RubyClass selfType) {
            if (this.misses < 50) {
                ++this.misses;
                if (this.misses >= 50) {
                    ++failedCallSites;
                }
                this.cache = new CacheEntry(method2, selfType);
                selfType.getRuntime().getCacheMap().add(method2, this);
            }
        }

        public void removeCachedMethod() {
            this.cache = NULL_CACHE;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
            CacheEntry myCache = this.cache;
            RubyClass selfType = this.pollAndGetClass(context, self);
            if (myCache.isOk(selfType)) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args2);
            }
            return this.cacheAndCall(selfType, args2, context, self);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
                }
                return this.cacheAndCall(selfType, block, args2, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(context, bj);
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
        }

        public IRubyObject callIter(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    IRubyObject iRubyObject = myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.cacheAndCall(selfType, block, args2, context, self);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = this.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self) {
            CacheEntry myCache = this.cache;
            RubyClass selfType = this.pollAndGetClass(context, self);
            if (myCache.isOk(selfType)) {
                return myCache.cachedMethod.call(context, self, selfType, this.methodName);
            }
            return this.cacheAndCall(selfType, context, self);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, block);
                }
                return this.cacheAndCall(selfType, block, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(context, bj);
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
        }

        public IRubyObject callIter(ThreadContext context, IRubyObject self, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    IRubyObject iRubyObject = myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.cacheAndCall(selfType, block, context, self);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = this.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1) {
            CacheEntry myCache = this.cache;
            RubyClass selfType = this.pollAndGetClass(context, self);
            if (myCache.isOk(selfType)) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1);
            }
            return this.cacheAndCall(selfType, context, self, arg1);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(context, bj);
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
        }

        public IRubyObject callIter(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    IRubyObject iRubyObject = myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.cacheAndCall(selfType, block, context, self, arg1);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = this.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            CacheEntry myCache = this.cache;
            RubyClass selfType = this.pollAndGetClass(context, self);
            if (myCache.isOk(selfType)) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(context, bj);
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
        }

        public IRubyObject callIter(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    IRubyObject iRubyObject = myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.cacheAndCall(selfType, block, context, self, arg1, arg2);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = this.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            CacheEntry myCache = this.cache;
            RubyClass selfType = this.pollAndGetClass(context, self);
            if (myCache.isOk(selfType)) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2, arg3);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    return myCache.cachedMethod.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2, arg3);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(context, bj);
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
        }

        public IRubyObject callIter(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.isOk(selfType)) {
                    IRubyObject iRubyObject = myCache.cachedMethod.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.cacheAndCall(selfType, block, context, self, arg1, arg2, arg3);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = this.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                throw this.retryJumpError(context);
            }
            catch (StackOverflowError soe) {
                throw this.systemStackError(context);
            }
            finally {
                block.escape();
            }
        }

        private IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
            if (context.getFrameJumpTarget() == bj.getTarget()) {
                return (IRubyObject)bj.getValue();
            }
            throw bj;
        }

        private RaiseException retryJumpError(ThreadContext context) {
            return context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not supported");
        }

        private RaiseException systemStackError(ThreadContext context) {
            return context.getRuntime().newSystemStackError("stack level too deep");
        }

        private static class CacheEntry {
            public final DynamicMethod cachedMethod;
            public final RubyClass cachedType;

            public CacheEntry(DynamicMethod method2, RubyClass type2) {
                this.cachedMethod = method2;
                this.cachedType = type2;
            }

            public boolean isOk(RubyClass otherType) {
                return this.cachedType == otherType;
            }
        }
    }
}

