/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.util.Iterator;

public abstract class Union
extends Structure {
    private Structure.StructField activeField;
    private Structure.StructField biggestField;

    protected Union() {
    }

    protected Union(int size2) {
        super(size2);
    }

    protected Union(int size2, int alignType) {
        super(size2, alignType);
    }

    public void setType(Class type2) {
        Iterator i = this.fields().values().iterator();
        while (i.hasNext()) {
            Structure.StructField f = (Structure.StructField)i.next();
            if (f.type != type2) continue;
            this.activeField = f;
            return;
        }
        throw new IllegalArgumentException("No field of type " + type2 + " in " + this);
    }

    void writeField(Structure.StructField field2) {
        if (field2 == this.activeField) {
            super.writeField(field2);
        }
    }

    Object readField(Structure.StructField field2) {
        if (field2 == this.activeField || !Structure.class.isAssignableFrom(field2.type) && !String.class.isAssignableFrom(field2.type) && !WString.class.isAssignableFrom(field2.type)) {
            return super.readField(field2);
        }
        return null;
    }

    int calculateSize(boolean force) {
        int size2 = super.calculateSize(force);
        if (size2 != -1) {
            int fsize = 0;
            Iterator i = this.fields().values().iterator();
            while (i.hasNext()) {
                Structure.StructField f = (Structure.StructField)i.next();
                f.offset = 0;
                if (f.size <= fsize) continue;
                fsize = f.size;
                this.biggestField = f;
            }
            size2 = this.calculateAlignedSize(fsize);
        }
        return size2;
    }

    protected int getNativeAlignment(Class type2, Object value2, boolean isFirstElement) {
        return super.getNativeAlignment(type2, value2, true);
    }

    Pointer getTypeInfo() {
        return Union.getTypeInfo(this.getField(this.biggestField));
    }
}

