/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pointer {
    public static final int SIZE = Native.POINTER_SIZE;
    public static final Pointer NULL;
    long peer;

    public static final Pointer createConstant(long peer) {
        return new Opaque(peer);
    }

    Pointer() {
    }

    Pointer(long peer) {
        this.peer = peer;
    }

    public Pointer share(long offset2) {
        return this.share(offset2, 0L);
    }

    public Pointer share(long offset2, long sz) {
        return new Pointer(this.peer + offset2);
    }

    void clear(long size2) {
        this.setMemory(0L, size2, (byte)0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return this.peer == 0L;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public long indexOf(long offset2, byte value2) {
        return Pointer._indexOf(this.peer + offset2, value2);
    }

    private static native long _indexOf(long var0, byte var2);

    public void read(long offset2, byte[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, byte[] var2, int var3, int var4);

    public void read(long offset2, short[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, short[] var2, int var3, int var4);

    public void read(long offset2, char[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, char[] var2, int var3, int var4);

    public void read(long offset2, int[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, int[] var2, int var3, int var4);

    public void read(long offset2, long[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, long[] var2, int var3, int var4);

    public void read(long offset2, float[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, float[] var2, int var3, int var4);

    public void read(long offset2, double[] buf, int index2, int length2) {
        Pointer._read(this.peer + offset2, buf, index2, length2);
    }

    private static native void _read(long var0, double[] var2, int var3, int var4);

    public void read(long offset2, Pointer[] buf, int index2, int length2) {
        for (int i = 0; i < length2; ++i) {
            buf[i + index2] = this.getPointer(offset2 + (long)(i * SIZE));
        }
    }

    public void write(long offset2, byte[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, byte[] var2, int var3, int var4);

    public void write(long offset2, short[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, short[] var2, int var3, int var4);

    public void write(long offset2, char[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, char[] var2, int var3, int var4);

    public void write(long offset2, int[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, int[] var2, int var3, int var4);

    public void write(long offset2, long[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, long[] var2, int var3, int var4);

    public void write(long offset2, float[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, float[] var2, int var3, int var4);

    public void write(long offset2, double[] buf, int index2, int length2) {
        Pointer._write(this.peer + offset2, buf, index2, length2);
    }

    private static native void _write(long var0, double[] var2, int var3, int var4);

    public void write(long bOff, Pointer[] buf, int index2, int length2) {
        for (int i = 0; i < length2; ++i) {
            this.setPointer(bOff + (long)(i * SIZE), buf[index2 + i]);
        }
    }

    public byte getByte(long offset2) {
        return Pointer._getByte(this.peer + offset2);
    }

    private static native byte _getByte(long var0);

    public char getChar(long offset2) {
        return Pointer._getChar(this.peer + offset2);
    }

    private static native char _getChar(long var0);

    public short getShort(long offset2) {
        return Pointer._getShort(this.peer + offset2);
    }

    private static native short _getShort(long var0);

    public int getInt(long offset2) {
        return Pointer._getInt(this.peer + offset2);
    }

    private static native int _getInt(long var0);

    public long getLong(long offset2) {
        return Pointer._getLong(this.peer + offset2);
    }

    private static native long _getLong(long var0);

    public NativeLong getNativeLong(long offset2) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset2) : (long)this.getInt(offset2));
    }

    public float getFloat(long offset2) {
        return this._getFloat(this.peer + offset2);
    }

    private native float _getFloat(long var1);

    public double getDouble(long offset2) {
        return Pointer._getDouble(this.peer + offset2);
    }

    private static native double _getDouble(long var0);

    public Pointer getPointer(long offset2) {
        return Pointer._getPointer(this.peer + offset2);
    }

    private static native Pointer _getPointer(long var0);

    public ByteBuffer getByteBuffer(long offset2, long length2) {
        return this._getDirectByteBuffer(this.peer + offset2, length2).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer _getDirectByteBuffer(long var1, long var3);

    public String getString(long offset2, boolean wide) {
        return Pointer._getString(this.peer + offset2, wide);
    }

    private static native String _getString(long var0, boolean var2);

    public String getString(long offset2) {
        long len;
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null && (len = this.indexOf(offset2, (byte)0)) != -1L) {
            if (len > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("String exceeds maximum length: " + len);
            }
            byte[] data = this.getByteArray(offset2, (int)len);
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.getString(offset2, false);
    }

    public byte[] getByteArray(long offset2, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(long offset2, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(long offset2, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(long offset2, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(long offset2, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(long offset2, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(long offset2, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(long offset2, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public void setMemory(long offset2, long length2, byte value2) {
        Pointer._setMemory(this.peer + offset2, length2, value2);
    }

    private static native void _setMemory(long var0, long var2, byte var4);

    public void setByte(long offset2, byte value2) {
        Pointer._setByte(this.peer + offset2, value2);
    }

    private static native void _setByte(long var0, byte var2);

    public void setShort(long offset2, short value2) {
        Pointer._setShort(this.peer + offset2, value2);
    }

    private static native void _setShort(long var0, short var2);

    public void setChar(long offset2, char value2) {
        Pointer._setChar(this.peer + offset2, value2);
    }

    private static native void _setChar(long var0, char var2);

    public void setInt(long offset2, int value2) {
        Pointer._setInt(this.peer + offset2, value2);
    }

    private static native void _setInt(long var0, int var2);

    public void setLong(long offset2, long value2) {
        Pointer._setLong(this.peer + offset2, value2);
    }

    private static native void _setLong(long var0, long var2);

    public void setNativeLong(long offset2, NativeLong value2) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset2, value2.longValue());
        } else {
            this.setInt(offset2, value2.intValue());
        }
    }

    public void setFloat(long offset2, float value2) {
        Pointer._setFloat(this.peer + offset2, value2);
    }

    private static native void _setFloat(long var0, float var2);

    public void setDouble(long offset2, double value2) {
        Pointer._setDouble(this.peer + offset2, value2);
    }

    private static native void _setDouble(long var0, double var2);

    public void setPointer(long offset2, Pointer value2) {
        Pointer._setPointer(this.peer + offset2, value2 != null ? value2.peer : 0L);
    }

    private static native void _setPointer(long var0, long var2);

    public void setString(long offset2, String value2, boolean wide) {
        Pointer._setString(this.peer + offset2, value2, wide);
    }

    private static native void _setString(long var0, String var2, boolean var3);

    public void setString(long offset2, String value2) {
        byte[] data = Native.getBytes(value2);
        this.write(offset2, data, 0, data.length);
        this.setByte(offset2 + (long)data.length, (byte)0);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    static {
        if (SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        NULL = null;
    }

    private static class Opaque
    extends Pointer {
        private String MSG = "This pointer is opaque: " + this;

        private Opaque(long peer) {
            super(peer);
        }

        public long indexOf(long offset2, byte value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, byte[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, char[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, short[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, int[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, long[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, float[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, double[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, byte[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, char[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, short[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, int[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, long[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, float[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, double[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String getString(long bOff, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setByte(long bOff, byte value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setChar(long bOff, char value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setShort(long bOff, short value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setInt(long bOff, int value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setLong(long bOff, long value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setFloat(long bOff, float value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setDouble(long bOff, double value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setPointer(long offset2, Pointer value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setString(long offset2, String value2, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String toString() {
            return "opaque@0x" + Long.toHexString(this.peer);
        }
    }
}

