/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.IArityNode;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Arity> arities = new HashMap<Integer, Arity>();
    private final int value;
    public static final Arity NO_ARGUMENTS = Arity.newArity(0);
    public static final Arity ONE_ARGUMENT = Arity.newArity(1);
    public static final Arity TWO_ARGUMENTS = Arity.newArity(2);
    public static final Arity THREE_ARGUMENTS = Arity.newArity(3);
    public static final Arity OPTIONAL = Arity.newArity(-1);
    public static final Arity ONE_REQUIRED = Arity.newArity(-2);
    public static final Arity TWO_REQUIRED = Arity.newArity(-3);
    public static final Arity THREE_REQUIRED = Arity.newArity(-3);

    private Arity(int value) {
        this.value = value;
    }

    public static Arity createArity(int value) {
        switch (value) {
            case -4: {
                return THREE_REQUIRED;
            }
            case -3: {
                return TWO_REQUIRED;
            }
            case -2: {
                return ONE_REQUIRED;
            }
            case -1: {
                return OPTIONAL;
            }
            case 0: {
                return NO_ARGUMENTS;
            }
            case 1: {
                return ONE_ARGUMENT;
            }
            case 2: {
                return TWO_ARGUMENTS;
            }
            case 3: {
                return THREE_ARGUMENTS;
            }
        }
        return Arity.newArity(value);
    }

    public static Arity fromAnnotation(JRubyMethod anno) {
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(anno.required() + 1));
        }
        return Arity.createArity(anno.required());
    }

    public static Arity fromAnnotation(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(actualRequired + 1));
        }
        return Arity.createArity(actualRequired);
    }

    public static Arity fromAnnotation(JRubyMethod anno, Class[] parameterTypes, boolean isStatic) {
        int required = 0;
        if (anno.optional() == 0 && !anno.rest() && anno.required() == 0) {
            int i = parameterTypes.length;
            if (isStatic) {
                --i;
            }
            if (parameterTypes.length > 0) {
                if (parameterTypes[0] == ThreadContext.class) {
                    --i;
                }
                if (parameterTypes[parameterTypes.length - 1] == Block.class) {
                    --i;
                }
            }
            required = i;
        } else {
            required = anno.required();
        }
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(required + 1));
        }
        return Arity.createArity(required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Arity newArity(int value) {
        Arity result;
        Integer integerValue = new Integer(value);
        Map<Integer, Arity> map = arities;
        synchronized (map) {
            result = arities.get(integerValue);
            if (result == null) {
                result = new Arity(value);
                arities.put(integerValue, result);
            }
        }
        return result;
    }

    public static Arity fixed(int arity) {
        assert (arity >= 0);
        return Arity.createArity(arity);
    }

    public static Arity optional() {
        return OPTIONAL;
    }

    public static Arity required(int minimum) {
        assert (minimum >= 0);
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return NO_ARGUMENTS;
    }

    public static Arity singleArgument() {
        return ONE_ARGUMENT;
    }

    public static Arity twoArguments() {
        return TWO_ARGUMENTS;
    }

    public static Arity procArityOf(Node node) {
        if (node instanceof AttrAssignNode && node != null) {
            node = ((AttrAssignNode)node).getArgsNode();
        }
        if (node == null) {
            return Arity.optional();
        }
        if (node instanceof IArityNode) {
            return ((IArityNode)((Object)node)).getArity();
        }
        if (node instanceof CallNode) {
            return Arity.singleArgument();
        }
        if (node instanceof ArrayNode) {
            return Arity.singleArgument();
        }
        throw new Error("unexpected type " + node.getClass() + " at " + node.getPosition());
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby runtime, IRubyObject[] args) {
        if (this.isFixed() ? args.length != this.required() : args.length < this.required()) {
            throw runtime.newArgumentError("wrong number of arguments(" + args.length + " for " + this.required() + ")");
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    public int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.isFixed()) {
            return "Fixed" + this.required();
        }
        return "Opt";
    }

    public static int checkArgumentCount(Ruby runtime, IRubyObject[] args, int min, int max) {
        if (args.length < min) {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + min + ")");
        }
        if (max > -1 && args.length > max) {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + max + ")");
        }
        return args.length;
    }

    public static void raiseArgumentError(Ruby runtime, int length, int min, int max) {
        if (length < min) {
            throw runtime.newArgumentError("wrong number of arguments (" + length + " for " + min + ")");
        }
        if (max > -1 && length > max) {
            throw runtime.newArgumentError("wrong number of arguments (" + length + " for " + max + ")");
        }
    }

    public static IRubyObject[] scanArgs(Ruby runtime, IRubyObject[] args, int required, int optional) {
        int total = required + optional;
        int real = Arity.checkArgumentCount(runtime, args, required, total);
        IRubyObject[] narr = new IRubyObject[total];
        System.arraycopy(args, 0, narr, 0, real);
        for (int i = real; i < total; ++i) {
            narr[i] = runtime.getNil();
        }
        return narr;
    }
}

