/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyClassLoader;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal<Ruby> runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private final ArrayList<JavaProxyMethod> methods = new ArrayList();
    private final HashMap<String, List<JavaProxyMethod>> methodMap = new HashMap();
    private final RubyArray constructors;
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet();
    private static final HashSet<String> EXCLUDE_METHODS;

    JavaProxyClass(Class proxyClass) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().fastGetModule("Java").fastGetClass("JavaProxyClass"));
        this.proxyClass = proxyClass;
        this.constructors = this.buildRubyArray(this.getConstructors());
    }

    public boolean equals(Object other) {
        return other instanceof JavaProxyClass && this.proxyClass == ((JavaProxyClass)other).proxyClass;
    }

    public int hashCode() {
        return this.proxyClass.hashCode();
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces, Set names) throws InvocationTargetException {
        Ruby save = runtimeTLS.get();
        runtimeTLS.set(runtime);
        try {
            JRubyClassLoader loader = runtime.getJRubyClassLoader();
            JavaProxyClass javaProxyClass = JavaProxyClassFactory.newProxyClass(loader, null, superClass, interfaces, names);
            return javaProxyClass;
        }
        finally {
            runtimeTLS.set(save);
        }
    }

    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces) throws InvocationTargetException {
        return JavaProxyClass.getProxyClass(runtime, superClass, interfaces, null);
    }

    public static Object newProxyInstance(Ruby runtime, Class superClass, Class[] interfaces, Class[] constructorParameters, Object[] constructorArgs, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(runtime, superClass, interfaces);
        JavaProxyConstructor cons = jpc.getConstructor(constructorParameters == null ? new Class[]{} : constructorParameters);
        return cons.newInstance(constructorArgs, handler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result = new Class[ifaces.length - 1];
        int pos = 0;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] == InternalJavaProxy.class) continue;
            result[pos++] = ifaces[i];
        }
        return result;
    }

    public JavaProxyConstructor[] getConstructors() {
        Constructor<?>[] cons = this.proxyClass.getConstructors();
        JavaProxyConstructor[] result = new JavaProxyConstructor[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            result[i] = new JavaProxyConstructor(this.getRuntime(), this, cons[i]);
        }
        return result;
    }

    public JavaProxyConstructor getConstructor(Class[] args) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args.length + 1];
        System.arraycopy(args, 0, realArgs, 0, args.length);
        realArgs[args.length] = JavaProxyInvocationHandler.class;
        Constructor constructor = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name, Class[] parameterTypes) {
        List<JavaProxyMethod> methods = this.methodMap.get(name);
        if (methods != null) {
            int i = methods.size();
            while (--i >= 0) {
                ProxyMethodImpl jpm = (ProxyMethodImpl)methods.get(i);
                if (!jpm.matches(name, parameterTypes)) continue;
                return jpm;
            }
        }
        return null;
    }

    Class getProxyClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String name, String desc, boolean hasSuper) {
        Class proxy = this.proxyClass;
        try {
            Class[] parms = JavaProxyClass.parse(proxy.getClassLoader(), desc);
            Method m = proxy.getDeclaredMethod(name, parms);
            Method sm = null;
            if (hasSuper) {
                sm = proxy.getDeclaredMethod("__super$" + name, parms);
            }
            ProxyMethodImpl jpm = new ProxyMethodImpl(this.getRuntime(), this, m, sm);
            this.methods.add(jpm);
            List<JavaProxyMethod> methodsWithName = this.methodMap.get(name);
            if (methodsWithName == null) {
                methodsWithName = new ArrayList<JavaProxyMethod>(2);
                this.methodMap.put(name, methodsWithName);
            }
            methodsWithName.add(jpm);
            return jpm;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> al = new ArrayList<Class<Byte>>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                            @Override
                            public Class run() throws ClassNotFoundException {
                                return Class.forName(name.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type = Short.TYPE;
                    break;
                }
                case 'I': {
                    type = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type = Long.TYPE;
                    break;
                }
                case 'F': {
                    type = Float.TYPE;
                    break;
                }
                case 'D': {
                    type = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type = Array.newInstance(type, new int[arr]).getClass();
            }
            al.add(type);
        }
        return al.toArray(new Class[al.size()]);
    }

    public static RubyClass createJavaProxyClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaProxyClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result);
        result.defineAnnotatedMethods(JavaProxyClass.class);
        return result;
    }

    @JRubyMethod(meta=true)
    public static RubyObject get(IRubyObject recv, IRubyObject obj) {
        if (!(obj instanceof JavaClass)) {
            throw recv.getRuntime().newTypeError(obj, recv.getRuntime().getJavaSupport().getJavaClassClass());
        }
        JavaClass type = (JavaClass)obj;
        try {
            return JavaProxyClass.getProxyClass(recv.getRuntime(), (Class)type.getValue(), new Class[0]);
        }
        catch (Error e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @JRubyMethod(meta=true)
    public static RubyObject get_with_class(IRubyObject recv, IRubyObject obj) {
        runtime = recv.getRuntime();
        if (!(obj instanceof RubyClass)) {
            throw runtime.newTypeError(obj, runtime.getClassClass());
        }
        clazz = (RubyClass)obj;
        javaClass = null;
        names = new HashSet<String>();
        interfaceList = new ArrayList<Class>();
        ancestors = clazz.getAncestorList();
        skipRemainingClasses = false;
        i$ = ancestors.iterator();
        block7: while (true) {
            block29: {
                block30: {
                    block27: {
                        block28: {
                            if (!i$.hasNext()) break block27;
                            ancestorObject = i$.next();
                            ancestor = (RubyModule)ancestorObject;
                            if (!(ancestor instanceof RubyClass)) break block28;
                            if (skipRemainingClasses) continue;
                            if (!ancestor.getInstanceVariables().fastHasInstanceVariable("@java_proxy_class")) {
                                skipRemainingClasses = true;
                                continue;
                            }
                            var = ancestor.getInstanceVariables().fastGetInstanceVariable("@java_class");
                            if (var == null) {
                                throw runtime.newTypeError("no java_class defined for proxy (or ancestor): " + ancestor);
                            }
                            if (!(var instanceof JavaClass)) {
                                throw runtime.newTypeError("invalid java_class defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            if (javaClass == null) {
                                javaClass = (JavaClass)var;
                            } else if (javaClass != var) {
                                throw runtime.newTypeError("java_class defined for " + clazz + " (" + javaClass + ") does not match java_class for ancestor " + ancestor + " (" + var + ")");
                            }
                            var = ancestor.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                            if (var == null || var instanceof RubyNil) break block29;
                            if (!(var instanceof RubyArray)) {
                                throw runtime.newTypeError("invalid java_interfaces defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            ifcArray = (RubyArray)var;
                            i = size = ifcArray.size();
                            break block30;
                        }
                        if (JavaProxyClass.EXCLUDE_MODULES.contains(ancestor.getName())) continue;
                        var13_17 = methods = ancestor.getMethods();
                        // MONITORENTER : methods
                        for (String methodName : methods.keySet()) {
                            if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                            names.add(methodName);
                        }
                        // MONITOREXIT : var13_17
                        continue;
                    }
                    if (javaClass == null) {
                        throw runtime.newArgumentError("unable to create proxy class: no java_class defined for " + clazz);
                    }
                    interfaceCount = interfaceList.size();
                    interfaces = new Class[interfaceCount];
                    i = interfaceCount;
                    while (--i >= 0) {
                        interfaces[i] = (Class)interfaceList.get(i);
                    }
                    try {
                        return JavaProxyClass.getProxyClass(recv.getRuntime(), javaClass.javaClass(), interfaces, names);
                    }
                    catch (Error e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (InvocationTargetException e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
                while (--i >= 0) {
                    ifc = ifcArray.eltInternal(i);
                    if (!(ifc instanceof JavaClass)) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc);
                    }
                    interfaceClass = ((JavaClass)ifc).javaClass();
                    if (!interfaceClass.isInterface()) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc + " (not an interface)");
                    }
                    if (interfaceList.contains(interfaceClass)) continue;
                    interfaceList.add(interfaceClass);
                }
            }
            if ((var = ancestor.getInstanceVariables().fastGetInstanceVariable("@__java_ovrd_methods")) == null) {
                i = methods = ancestor.getMethods();
                // MONITORENTER : methods
                methodNames = RubyArray.newArrayLight(runtime, methods.size());
                for (String methodName : methods.keySet()) {
                    if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                    names.add(methodName);
                    methodNames.add(runtime.newString(methodName));
                }
                // MONITOREXIT : i
                ancestor.fastSetInstanceVariable("@__java_ovrd_methods", methodNames);
                continue;
            }
            if (!(var instanceof RubyArray)) {
                throw runtime.newTypeError("invalid @__java_ovrd_methods defined for proxy: " + ancestor + ": " + var);
            }
            methodNames = (RubyArray)var;
            i = size = methodNames.size();
            while (true) {
                if (--i >= 0) ** break;
                continue block7;
                methodName = methodNames.eltInternal(i);
                if (!(methodName instanceof RubyString)) {
                    throw runtime.newTypeError("invalid method name defined for proxy (or ancestor): " + ancestor + ": " + methodName);
                }
                names.add(methodName.asJavaString());
            }
            break;
        }
    }

    @JRubyMethod
    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    @JRubyMethod
    public RubyArray methods() {
        return this.buildRubyArray(this.getMethods());
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return this.buildRubyArray(this.getInterfaces());
    }

    @JRubyMethod
    public RubyArray constructors() {
        return this.constructors;
    }

    public static void createJavaProxyModule(Ruby runtime) {
        RubyModule javaProxyModule = runtime.getJavaSupport().getJavaModule();
        JavaProxyClass.createJavaProxyClassClass(runtime, javaProxyModule);
        ProxyMethodImpl.createJavaProxyMethodClass(runtime, javaProxyModule);
        JavaProxyConstructor.createJavaProxyConstructorClass(runtime, javaProxyModule);
    }

    public String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        EXCLUDE_METHODS = new HashSet();
        EXCLUDE_METHODS.add("class");
        EXCLUDE_METHODS.add("finalize");
        EXCLUDE_METHODS.add("initialize");
        EXCLUDE_METHODS.add("java_class");
        EXCLUDE_METHODS.add("java_object");
        EXCLUDE_METHODS.add("__jcreate!");
        EXCLUDE_METHODS.add("__jsend!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JRubyClass(name={"JavaProxy::JavaProxyMethod"})
    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method m;
        private Object state;
        private final Method sm;
        private final Class[] parameterTypes;
        private final JavaProxyClass clazz;

        public ProxyMethodImpl(Ruby runtime, JavaProxyClass clazz, Method m, Method sm) {
            super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaProxyMethod"));
            this.m = m;
            this.parameterTypes = m.getParameterTypes();
            this.sm = sm;
            this.clazz = clazz;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof ProxyMethodImpl && this.m == ((ProxyMethodImpl)other).m;
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public Method getMethod() {
            return this.m;
        }

        @Override
        public Method getSuperMethod() {
            return this.sm;
        }

        @Override
        public int getModifiers() {
            return this.m.getModifiers();
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public Class<?>[] getExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.sm != null;
        }

        @Override
        public Object invoke(Object proxy, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.sm.invoke(proxy, args);
        }

        @Override
        public void setState(Object state) {
            this.state = state;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }

        @Override
        public Object defaultResult() {
            Class<?> rt = this.m.getReturnType();
            if (rt == Void.TYPE) {
                return null;
            }
            if (rt == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (rt == Byte.TYPE) {
                return new Byte(0);
            }
            if (rt == Short.TYPE) {
                return new Short(0);
            }
            if (rt == Integer.TYPE) {
                return new Integer(0);
            }
            if (rt == Long.TYPE) {
                return new Long(0L);
            }
            if (rt == Float.TYPE) {
                return new Float(0.0f);
            }
            if (rt == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public boolean matches(String name, Class[] parameterTypes) {
            return this.m.getName().equals(name) && Arrays.equals(this.parameterTypes, parameterTypes);
        }

        public Class getReturnType() {
            return this.m.getReturnType();
        }

        public static RubyClass createJavaProxyMethodClass(Ruby runtime, RubyModule javaProxyModule) {
            RubyClass result = javaProxyModule.defineClassUnder("JavaProxyMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            JavaProxyReflectionObject.registerRubyMethods(runtime, result);
            result.defineAnnotatedMethods(ProxyMethodImpl.class);
            return result;
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        @Override
        @JRubyMethod(name={"declaring_class"})
        public JavaProxyClass getDeclaringClass() {
            return this.clazz;
        }

        @JRubyMethod
        public RubyArray argument_types() {
            return this.buildRubyArray(this.getParameterTypes());
        }

        @JRubyMethod(name={"super?"})
        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        @Override
        @JRubyMethod
        public IRubyObject inspect() {
            StringBuffer result = new StringBuffer();
            result.append(this.nameOnInspection());
            result.append("(");
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result.append(parameterTypes[i].getName());
                if (i >= parameterTypes.length - 1) continue;
                result.append(',');
            }
            result.append(")>");
            return this.getRuntime().newString(result.toString());
        }

        @JRubyMethod(name={"invoke"}, rest=true)
        public IRubyObject do_invoke(IRubyObject[] nargs) {
            if (nargs.length != 1 + this.getArity()) {
                throw this.getRuntime().newArgumentError(nargs.length, 1 + this.getArity());
            }
            IRubyObject invokee = nargs[0];
            if (!(invokee instanceof JavaObject)) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            Object receiver_value = ((JavaObject)invokee).getValue();
            Object[] arguments = new Object[nargs.length - 1];
            System.arraycopy(nargs, 1, arguments, 0, arguments.length);
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = JavaUtil.convertRubyToJava((IRubyObject)arguments[i], parameterTypes[i]);
            }
            try {
                Object javaResult = this.sm.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(this.getRuntime(), javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException iae) {
                throw this.getRuntime().newTypeError("illegal access on '" + this.sm.getName() + "': " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                if (this.getRuntime().getDebug().isTrue()) {
                    ite.getTargetException().printStackTrace();
                }
                this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
                return this.getRuntime().getNil();
            }
        }

        private int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

