/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.ClassProvider;

@JRubyModule(name={"Java"})
public class Java
implements Library {
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;

    public void load(Ruby runtime, boolean wrap) throws IOException {
        Java.createJavaModule(runtime);
        runtime.getLoadService().smartLoad("builtin/javasupport");
        RubyClassPathVariable.createClassPathVariable(runtime);
    }

    public static RubyModule createJavaModule(Ruby runtime) {
        RubyModule javaModule = runtime.defineModule("Java");
        javaModule.defineAnnotatedMethods(Java.class);
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        JavaProxyClass.createJavaProxyModule(runtime);
        RubyModule javaUtils = runtime.defineModule("JavaUtilities");
        javaUtils.defineAnnotatedMethods(JavaUtilities.class);
        runtime.getJavaSupport().setConcreteProxyCallback(new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block block) {
                Arity.checkArgumentCount(recv.getRuntime(), args, 1, 1);
                return Java.concrete_proxy_inherited(recv, args[0]);
            }

            public Arity getArity() {
                return Arity.ONE_ARGUMENT;
            }
        });
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime);
        RubyClass javaProxy = runtime.defineClass("JavaProxy", runtime.getObject(), runtime.getObject().getAllocator());
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        return javaModule;
    }

    public static IRubyObject is_primitive_type(IRubyObject recv, IRubyObject sym) {
        return recv.getRuntime().newBoolean(JAVA_PRIMITIVES.containsKey(sym.asJavaString()));
    }

    public static IRubyObject create_proxy_class(IRubyObject recv, IRubyObject constant, IRubyObject javaClass, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw recv.getRuntime().newTypeError(module, recv.getRuntime().getModule());
        }
        return ((RubyModule)module).const_set(constant, Java.get_proxy_class(recv, javaClass));
    }

    public static IRubyObject get_java_class(IRubyObject recv, IRubyObject name) {
        try {
            return JavaClass.for_name(recv, name);
        }
        catch (Exception e) {
            return recv.getRuntime().getNil();
        }
    }

    public static IRubyObject new_instance_for(IRubyObject recv, IRubyObject java_object) {
        if (java_object instanceof JavaObject) {
            return Java.getInstance(((JavaObject)java_object).getValue(), (RubyClass)recv);
        }
        IRubyObject new_instance = ((RubyClass)recv).allocate();
        new_instance.getInstanceVariables().fastSetInstanceVariable("@java_object", java_object);
        return new_instance;
    }

    public static IRubyObject getInstance(Object rawJavaObject, RubyClass clazz) {
        return clazz.getRuntime().getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, clazz);
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject) {
        if (rawJavaObject != null) {
            return runtime.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, (RubyClass)Java.getProxyClass(runtime, JavaClass.get(runtime, rawJavaObject.getClass())));
        }
        return runtime.getNil();
    }

    public static IRubyObject to_java_object(IRubyObject recv) {
        return recv.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Deprecated
    public static IRubyObject add_proxy_extender(IRubyObject recv, IRubyObject extender) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "JavaUtilities.add_proxy_extender is deprecated - use JavaUtilities.extend_proxy instead", "add_proxy_extender", "JavaUtilities.extend_proxy");
        IRubyObject javaClassVar = extender.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (!(javaClassVar instanceof JavaClass)) {
            throw recv.getRuntime().newArgumentError("extender does not have a valid @java_class");
        }
        ((JavaClass)javaClassVar).addProxyExtender(extender);
        return recv.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby runtime, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw runtime.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule interfaceModule = javaClass.getProxyModule();
        if (interfaceModule != null) {
            return interfaceModule;
        }
        javaClass.lockProxy();
        try {
            interfaceModule = javaClass.getProxyModule();
            if (interfaceModule == null) {
                interfaceModule = (RubyModule)runtime.getJavaSupport().getJavaInterfaceTemplate().dup();
                interfaceModule.fastSetInstanceVariable("@java_class", javaClass);
                Java.addToJavaPackageModule(interfaceModule, javaClass);
                javaClass.setupInterfaceModule(interfaceModule);
                Class<?>[] extended = javaClass.javaClass().getInterfaces();
                int i = extended.length;
                while (--i >= 0) {
                    JavaClass extendedClass = JavaClass.get(runtime, extended[i]);
                    RubyModule extModule = Java.getInterfaceModule(runtime, extendedClass);
                    interfaceModule.includeModule(extModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return interfaceModule;
    }

    public static IRubyObject get_interface_module(IRubyObject recv, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime = recv.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        return Java.getInterfaceModule(runtime, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_deprecated_interface_proxy(IRubyObject recv, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime = recv.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        if (!javaClass.javaClass().isInterface()) {
            throw runtime.newArgumentError("expected Java interface class, got " + javaClassObject);
        }
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                RubyModule interfaceModule = Java.getInterfaceModule(runtime, javaClass);
                RubyClass interfaceJavaProxy = runtime.fastGetClass("InterfaceJavaProxy");
                proxyClass = RubyClass.newClass(runtime, interfaceJavaProxy);
                proxyClass.setAllocator(interfaceJavaProxy.getAllocator());
                proxyClass.makeMetaClass(interfaceJavaProxy.getMetaClass());
                proxyClass.inherit(interfaceJavaProxy);
                proxyClass.callMethod(recv.getRuntime().getCurrentContext(), "java_class=", javaClass);
                proxyClass.includeModule(interfaceModule);
                javaClass.setupProxy(proxyClass);
                if (proxyClass.fastGetConstantAt("Includable") == null) {
                    proxyClass.fastSetConstant("Includable", interfaceModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getProxyClass(Ruby runtime, JavaClass javaClass) {
        Class c = javaClass.javaClass();
        if (c.isInterface()) {
            return Java.getInterfaceModule(runtime, javaClass);
        }
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                if (c.isArray()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getArrayProxyClass(), javaClass, true);
                } else if (c.isPrimitive()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (c == Object.class) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    proxyClass.getMetaClass().defineFastMethod("inherited", runtime.getJavaSupport().getConcreteProxyCallback());
                    Java.addToJavaPackageModule(proxyClass, javaClass);
                } else {
                    proxyClass = Java.createProxyClass(runtime, (RubyClass)Java.getProxyClass(runtime, JavaClass.get(runtime, c.getSuperclass())), javaClass, false);
                    Class<?>[] interfaces = c.getInterfaces();
                    int i = interfaces.length;
                    while (--i >= 0) {
                        JavaClass ifc = JavaClass.get(runtime, interfaces[i]);
                        proxyClass.includeModule(Java.getInterfaceModule(runtime, ifc));
                    }
                    if (Modifier.isPublic(c.getModifiers())) {
                        Java.addToJavaPackageModule(proxyClass, javaClass);
                    }
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject recv, IRubyObject java_class_object) {
        JavaClass javaClass;
        Ruby runtime = recv.getRuntime();
        if (java_class_object instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, java_class_object);
        } else if (java_class_object instanceof JavaClass) {
            javaClass = (JavaClass)java_class_object;
        } else {
            throw runtime.newTypeError(java_class_object, runtime.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(runtime, javaClass);
    }

    private static RubyClass createProxyClass(Ruby runtime, RubyClass baseType, JavaClass javaClass, boolean invokeInherited) {
        RubyClass.checkInheritable(baseType);
        RubyClass superClass = baseType;
        RubyClass proxyClass = RubyClass.newClass(runtime, superClass);
        proxyClass.makeMetaClass(superClass.getMetaClass());
        proxyClass.setAllocator(superClass.getAllocator());
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        proxyClass.callMethod(runtime.getCurrentContext(), "java_class=", javaClass);
        javaClass.setupProxy(proxyClass);
        return proxyClass;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject recv, IRubyObject subclass) {
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        JavaSupport javaSupport = runtime.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        RuntimeHelpers.invokeAs(tc, javaProxyClass, recv, "inherited", new IRubyObject[]{subclass}, CallType.SUPER, Block.NULL_BLOCK);
        return javaSupport.getJavaUtilitiesModule().callMethod(tc, "setup_java_subclass", new IRubyObject[]{subclass, recv.callMethod(tc, "java_class")});
    }

    private static void addToJavaPackageModule(RubyModule proxyClass, JavaClass javaClass) {
        String className;
        String packageString;
        Class clazz = javaClass.javaClass();
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        int endPackage = fullName.lastIndexOf(46);
        if (fullName.indexOf(36) != -1 || !Character.isUpperCase(fullName.charAt(endPackage + 1))) {
            return;
        }
        Ruby runtime = proxyClass.getRuntime();
        RubyModule packageModule = Java.getJavaPackageModule(runtime, packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage));
        if (packageModule != null && packageModule.getConstantAt(className = fullName.substring(endPackage + 1)) == null) {
            packageModule.const_set(runtime.newSymbol(className), proxyClass);
        }
    }

    private static RubyModule getJavaPackageModule(Ruby runtime, String packageString) {
        String packageName;
        int length = packageString.length();
        if (length == 0) {
            packageName = "Default";
        } else {
            StringBuffer buf = new StringBuffer();
            int start = 0;
            int offset = 0;
            while (start < length) {
                offset = packageString.indexOf(46, start);
                if (offset == -1) {
                    offset = length;
                }
                buf.append(Character.toUpperCase(packageString.charAt(start))).append(packageString.substring(start + 1, offset));
                start = offset + 1;
            }
            packageName = buf.toString();
        }
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule parent, String name, String packageString) {
        Ruby runtime = parent.getRuntime();
        RubyModule packageModule = (RubyModule)runtime.getJavaSupport().getPackageModuleTemplate().dup();
        packageModule.fastSetInstanceVariable("@package_name", runtime.newString(packageString.length() > 0 ? packageString + '.' : packageString));
        packageModule.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        parent.const_set(runtime.newSymbol(name), packageModule);
        MetaClass metaClass = (MetaClass)packageModule.getMetaClass();
        metaClass.setAttached(packageModule);
        return packageModule;
    }

    public static RubyModule getPackageModule(Ruby runtime, String name) {
        String packageName;
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject value = javaModule.getConstantAt(name);
        if (value instanceof RubyModule) {
            return (RubyModule)value;
        }
        if ("Default".equals(name)) {
            packageName = "";
        } else {
            Matcher m = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name);
            packageName = m.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(javaModule, name, packageName);
    }

    public static IRubyObject get_package_module(IRubyObject recv, IRubyObject symObject) {
        return Java.getPackageModule(recv.getRuntime(), symObject.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject recv, IRubyObject dottedName) {
        Ruby runtime = recv.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime, dottedName.asJavaString());
        return module == null ? runtime.getNil() : module;
    }

    public static RubyModule getProxyOrPackageUnderPackage(final Ruby runtime, RubyModule parentPackage, String sym) {
        IRubyObject packageNameObj = parentPackage.fastGetInstanceVariable("@package_name");
        if (packageNameObj == null) {
            throw runtime.newArgumentError("invalid package module");
        }
        String packageName = packageNameObj.asJavaString();
        String name = sym.trim().intern();
        if (name.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        String fullName = packageName + name;
        if (Character.isLowerCase(name.charAt(0))) {
            if (JAVA_PRIMITIVES.containsKey(name)) {
                throw runtime.newArgumentError("illegal package name component: " + name);
            }
            try {
                return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, fullName));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(runtime.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, fullName);
            if (packageModule == null) {
                return null;
            }
            final String ivarName = ("@__pkg__" + name).intern();
            parentPackage.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = parentPackage.getSingletonClass();
            singleton.addMethod(name, new org.jruby.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject variable;
                    if (args.length != 0) {
                        Arity.raiseArgumentError(runtime, args.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        return Java.getProxyClass(runtime, JavaClass.forNameVerbose(runtime, fullName));
    }

    public static IRubyObject get_proxy_or_package_under_package(IRubyObject recv, IRubyObject parentPackage, IRubyObject sym) {
        Ruby runtime = recv.getRuntime();
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime.newTypeError(parentPackage, runtime.getModule());
        }
        RubyModule result = Java.getProxyOrPackageUnderPackage(runtime, (RubyModule)parentPackage, sym.asJavaString());
        if (result != null) {
            return result;
        }
        return runtime.getNil();
    }

    public static RubyModule getTopLevelProxyOrPackage(final Ruby runtime, String sym) {
        String name = sym.trim().intern();
        if (name.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name.charAt(0))) {
            try {
                return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, name));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(runtime.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, name);
            if (packageModule == null) {
                return null;
            }
            RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
            if (javaModule.getMetaClass().isMethodBound(name, false)) {
                return packageModule;
            }
            final String ivarName = ("@__pkg__" + name).intern();
            javaModule.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = javaModule.getSingletonClass();
            singleton.addMethod(name, new org.jruby.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject variable;
                    if (args.length != 0) {
                        Arity.raiseArgumentError(runtime, args.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        try {
            return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, name));
        }
        catch (RaiseException re) {
            RubyException rubyEx = re.getException();
            if (rubyEx.kind_of_p(runtime.getStandardError()).isTrue()) {
                RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Java.getPackageModule(runtime, name);
    }

    public static IRubyObject get_top_level_proxy_or_package(IRubyObject recv, IRubyObject sym) {
        Ruby runtime = recv.getRuntime();
        RubyModule result = Java.getTopLevelProxyOrPackage(runtime, sym.asJavaString());
        if (result != null) {
            return result;
        }
        return runtime.getNil();
    }

    public static IRubyObject matching_method(IRubyObject recv, IRubyObject methods, IRubyObject args) {
        Map matchCache = recv.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arg_types = new ArrayList();
        int alen = ((RubyArray)args).getLength();
        IRubyObject[] aargs = ((RubyArray)args).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < alen; ++i) {
            if (aargs[i] instanceof JavaObject) {
                arg_types.add(((JavaClass)((JavaObject)aargs[i]).java_class()).javaClass());
                continue;
            }
            arg_types.add(aargs[i].getClass());
        }
        HashMap ms = (HashMap)matchCache.get(methods);
        if (ms == null) {
            ms = new HashMap();
            matchCache.put(methods, ms);
        } else {
            IRubyObject method = (IRubyObject)ms.get(arg_types);
            if (method != null) {
                return method;
            }
        }
        int mlen = ((RubyArray)methods).getLength();
        IRubyObject[] margs = ((RubyArray)methods).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < mlen; ++k) {
                IRubyObject method = margs[k];
                List<Class<?>> types = Arrays.asList(((ParameterTypes)((Object)method)).getParameterTypes());
                if (arg_types.size() != types.size()) continue;
                if (((Object)types).equals(arg_types)) {
                    ms.put(arg_types, method);
                    return method;
                }
                boolean match = true;
                for (int j = 0; j < types.size(); ++j) {
                    if (JavaClass.assignable(types.get(j), (Class)arg_types.get(j)) && (i > 0 || Java.primitive_match(types.get(j), arg_types.get(j))) || JavaUtil.isDuckTypeConvertable((Class)arg_types.get(j), types.get(j))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ms.put(arg_types, method);
                return method;
            }
        }
        IRubyObject o1 = margs[0];
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject matching_method_internal(IRubyObject recv, IRubyObject methods, IRubyObject[] args, int start, int len) {
        Class<?>[] types;
        IRubyObject method;
        int k;
        Map matchCache = recv.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arg_types = new ArrayList();
        int aend = start + len;
        for (int i = start; i < aend; ++i) {
            if (args[i] instanceof JavaObject) {
                arg_types.add(((JavaClass)((JavaObject)args[i]).java_class()).javaClass());
                continue;
            }
            arg_types.add(args[i].getClass());
        }
        HashMap ms = (HashMap)matchCache.get(methods);
        if (ms == null) {
            ms = new HashMap();
            matchCache.put(methods, ms);
        } else {
            IRubyObject method2 = (IRubyObject)ms.get(arg_types);
            if (method2 != null) {
                return method2;
            }
        }
        int mlen = ((RubyArray)methods).getLength();
        IRubyObject[] margs = ((RubyArray)methods).toJavaArrayMaybeUnsafe();
        block1: for (k = 0; k < mlen; ++k) {
            method = margs[k];
            types = ((ParameterTypes)((Object)method)).getParameterTypes();
            if (len != types.length) continue;
            boolean same = true;
            int y = len;
            for (int x = 0; x < y; ++x) {
                if (types[x].equals(arg_types.get(x))) continue;
                same = false;
                break;
            }
            if (same) {
                ms.put(arg_types, method);
                return method;
            }
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], (Class)arg_types.get(j)) || !Java.primitive_match(types[j], arg_types.get(j))) continue block1;
            }
            ms.put(arg_types, method);
            return method;
        }
        block4: for (k = 0; k < mlen; ++k) {
            method = margs[k];
            types = ((ParameterTypes)((Object)method)).getParameterTypes();
            if (len != types.length) continue;
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], (Class)arg_types.get(j)) && !JavaUtil.isDuckTypeConvertable((Class)arg_types.get(j), types[j])) continue block4;
            }
            ms.put(arg_types, method);
            return method;
        }
        IRubyObject o1 = margs[0];
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject access(IRubyObject recv, IRubyObject java_type) {
        int modifiers = ((JavaClass)java_type).javaClass().getModifiers();
        return recv.getRuntime().newString(Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject recv, IRubyObject name) {
        RubyString sname = name.convertToString();
        if (sname.getByteList().length() == 0) {
            return recv.getRuntime().getFalse();
        }
        return Character.isUpperCase(sname.getByteList().charAt(0)) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object v1, Object v2) {
        if (((Class)v1).isPrimitive()) {
            if (v1 == Integer.TYPE || v1 == Long.TYPE || v1 == Short.TYPE || v1 == Character.TYPE) {
                return v2 == Integer.class || v2 == Long.class || v2 == Short.class || v2 == Character.class;
            }
            if (v1 == Float.TYPE || v1 == Double.TYPE) {
                return v2 == Float.class || v2 == Double.class;
            }
            if (v1 == Boolean.TYPE) {
                return v2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject recv, IRubyObject t1, IRubyObject t2) {
        if (((JavaClass)t1).primitive_p().isTrue()) {
            Object v2;
            Object v1 = ((JavaObject)t1).getValue();
            return Java.primitive_match(v1, v2 = ((JavaObject)t2).getValue()) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
        }
        return recv.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject recv, IRubyObject java_object) {
        return Java.getInstance(recv.getRuntime(), ((JavaObject)java_object).getValue());
    }

    public static IRubyObject wrap(Ruby runtime, IRubyObject java_object) {
        return Java.getInstance(runtime, ((JavaObject)java_object).getValue());
    }

    @JRubyMethod(required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args, Block block) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : recv.getRuntime().newProc(Block.Type.PROC, block);
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime = recv.getRuntime();
        switch (object.getMetaClass().index) {
            case 5: {
                javaObject = null;
                break;
            }
            case 1: {
                javaObject = new Long(((RubyFixnum)object).getLongValue());
                break;
            }
            case 2: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case 11: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case 4: {
                try {
                    ByteList bytes = ((RubyString)object).getByteList();
                    javaObject = new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    javaObject = object.toString();
                }
                break;
            }
            case 6: {
                javaObject = Boolean.TRUE;
                break;
            }
            case 7: {
                javaObject = Boolean.FALSE;
                break;
            }
            default: {
                javaObject = object instanceof RubyTime ? ((RubyTime)object).getJavaDate() : object;
            }
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result = object.getInstanceVariables().fastGetInstanceVariable("@java_object");
            if (result == null) {
                result = object.callMethod(recv.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (result instanceof JavaObject) {
                recv.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)result).getValue(), object);
            }
            return result;
        }
        return Java.primitive_to_java(recv, object, unusedBlock);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    @JRubyMethod(required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args, Block block) {
        RubyProc proc;
        int size = Arity.checkArgumentCount(recv.getRuntime(), args, 1, -1) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = recv.getRuntime().newProc(Block.Type.PROC, block);
            ++size;
        }
        Class[] interfaces = new Class[size];
        for (int i = 0; i < size; ++i) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected. got: " + args[i]);
            }
            interfaces[i] = ((JavaClass)args[i]).javaClass();
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJRubyClassLoader(), interfaces, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method);
                if (parameterTypes == null) {
                    parameterTypes = method.getParameterTypes();
                    this.parameterTypeCache.put(method, parameterTypes);
                }
                int methodArgsLength = parameterTypes.length;
                String methodName = method.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && parameterTypes[0].equals(Object.class)) {
                    return proxy == nargs[0];
                }
                Ruby runtime = recv.getRuntime();
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(runtime, proxy);
                rubyArgs[1] = new JavaMethod(runtime, method);
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(runtime, nargs[i]);
                }
                return JavaUtil.convertArgument(runtime, proc.call(runtime.getCurrentContext(), rubyArgs), method.getReturnType());
            }
        }));
    }

    static {
        String[] primitives;
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            public RubyClass defineClassUnder(RubyModule pkg, String name, RubyClass superClazz) {
                if (superClazz != null) {
                    return null;
                }
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyClass)Java.get_proxy_class(runtime.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name));
            }

            public RubyModule defineModuleUnder(RubyModule pkg, String name) {
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyModule)Java.get_interface_module(runtime.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String primitive : primitives = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(primitive, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
    }

    @JRubyClass(name={"JavaProxy"})
    public static class JavaProxy {
        @JRubyMethod(meta=true)
        public static IRubyObject new_instance_for(IRubyObject recv, IRubyObject arg0) {
            return Java.new_instance_for(recv, arg0);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject to_java_object(IRubyObject recv) {
            return Java.to_java_object(recv);
        }
    }

    @JRubyModule(name={"JavaUtilities"})
    public static class JavaUtilities {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject wrap(IRubyObject recv, IRubyObject arg0) {
            return Java.wrap(recv, arg0);
        }

        @JRubyMethod(name={"valid_constant_name?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject valid_constant_name_p(IRubyObject recv, IRubyObject arg0) {
            return Java.valid_constant_name_p(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject primitive_match(IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.primitive_match(recv, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject access(IRubyObject recv, IRubyObject arg0) {
            return Java.access(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject matching_method(IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.matching_method(recv, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_deprecated_interface_proxy(IRubyObject recv, IRubyObject arg0) {
            return Java.get_deprecated_interface_proxy(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_interface_module(IRubyObject recv, IRubyObject arg0) {
            return Java.get_interface_module(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module(IRubyObject recv, IRubyObject arg0) {
            return Java.get_package_module(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module_dot_format(IRubyObject recv, IRubyObject arg0) {
            return Java.get_package_module_dot_format(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_class(IRubyObject recv, IRubyObject arg0) {
            return Java.get_proxy_class(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject is_primitive_type(IRubyObject recv, IRubyObject arg0) {
            return Java.is_primitive_type(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject create_proxy_class(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return Java.create_proxy_class(recv, arg0, arg1, arg2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_java_class(IRubyObject recv, IRubyObject arg0) {
            return Java.get_java_class(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_top_level_proxy_or_package(IRubyObject recv, IRubyObject arg0) {
            return Java.get_top_level_proxy_or_package(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_or_package_under_package(IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.get_proxy_or_package_under_package(recv, arg0, arg1);
        }

        @Deprecated
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject add_proxy_extender(IRubyObject recv, IRubyObject arg0) {
            return Java.add_proxy_extender(recv, arg0);
        }
    }
}

