/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ConstructorImpl;
import org.jvyamlb.SafeConstructorImpl;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;

public class JRubyConstructor
extends ConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private final Ruby runtime;

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        return (Constructor.YamlConstructor)yamlConstructors.get(key);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
    }

    public Pattern getYamlMultiRegexp(Object key) {
        return (Pattern)yamlMultiRegexps.get(key);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public JRubyConstructor(IRubyObject receiver, Composer composer) {
        super(composer);
        this.runtime = receiver.getRuntime();
    }

    public Object constructRubyScalar(Node node) {
        ByteList sc = (ByteList)super.constructScalar(node);
        if (sc.length() > 0 && sc.charAt(0) == ':' && ((ScalarNode)node).getStyle() == '\u0000') {
            return this.runtime.evalScript(sc.toString());
        }
        return RubyString.newString(this.runtime, (ByteList)super.constructScalar(node));
    }

    public Object constructPrivateType(Node node) {
        Object val = null;
        val = node.getValue() instanceof Map ? this.constructRubyMapping(node) : (node.getValue() instanceof List ? this.constructRubySequence(node) : this.constructRubyScalar(node));
        return this.runtime.getModule("YAML").getConstant("PrivateType").callMethod(this.runtime.getCurrentContext(), "new", new IRubyObject[]{this.runtime.newString(node.getTag()), (IRubyObject)val});
    }

    public Object constructRubySequence(Node node) {
        final RubyArray arr = this.runtime.newArray();
        List l = (List)super.constructSequence(node);
        this.doRecursionFix(node, arr);
        int i = 0;
        for (Object oo : l) {
            if (oo instanceof LinkNode) {
                arr.append(this.runtime.getNil());
                final RubyFixnum ix = this.runtime.newFixnum(i);
                this.addFixer((Node)((LinkNode)oo).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object real) {
                        arr.aset(new IRubyObject[]{ix, (IRubyObject)real});
                    }
                });
            } else {
                arr.append((IRubyObject)oo);
            }
            ++i;
        }
        return arr;
    }

    public Object constructRubyMapping(Node node) {
        RubyHash h1 = RubyHash.newHash(this.runtime, (Map)super.constructMapping(node), this.runtime.getNil());
        return h1;
    }

    public Object constructRubyPairs(Node node) {
        return this.runtime.newArray((List)super.constructPairs(node));
    }

    public static Object constructYamlNull(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.getNil();
    }

    public static Object constructYamlBool(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlBool(ctor, node) == Boolean.TRUE ? ((JRubyConstructor)ctor).runtime.getTrue() : ((JRubyConstructor)ctor).runtime.getFalse();
    }

    public static Object constructYamlOmap(Constructor ctor, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyArray arr = (RubyArray)runtime.getModule("YAML").getConstant("Omap").callMethod(runtime.getCurrentContext(), "new");
        List l = (List)ctor.constructSequence(node);
        ctor.doRecursionFix(node, arr);
        for (IRubyObject v : l) {
            if (v instanceof RubyHash) {
                arr.concat(((RubyHash)v).to_a());
                continue;
            }
            throw new ConstructorException(null, "Invalid !omap entry: " + l, null);
        }
        return arr;
    }

    public static Object constructYamlPairs(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyPairs(node);
    }

    public static Object constructYamlSet(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlSet(ctor, node);
    }

    public static Object constructYamlStr(Constructor ctor, Node node) {
        Object _str = ((JRubyConstructor)ctor).constructRubyScalar(node);
        if (_str instanceof RubyString) {
            RubyString str = (RubyString)_str;
            return str.getValue().length() == 0 && ((ScalarNode)node).getStyle() == '\u0000' ? str.getRuntime().getNil() : str;
        }
        return _str;
    }

    public static Object constructYamlSeq(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubySequence(node);
    }

    public static Object constructYamlMap(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyMapping(node);
    }

    public static Object constructUndefined(Constructor ctor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor ctor, Node node) {
        Calendar c = (Calendar)SafeConstructorImpl.constructYamlTimestamp(ctor, node);
        return RubyTime.newTime(((JRubyConstructor)ctor).runtime, c);
    }

    public static Object constructYamlTimestampYMD(Constructor ctor, Node node) {
        Date d = (Date)SafeConstructorImpl.constructYamlTimestamp(ctor, node);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        return runtime.getClass("Date").callMethod(runtime.getCurrentContext(), "new", new IRubyObject[]{runtime.newFixnum(c.get(1)), runtime.newFixnum(c.get(2) + 1), runtime.newFixnum(c.get(5))});
    }

    public static Object constructYamlInt(Constructor ctor, Node node) {
        return JavaUtil.convertJavaToRuby(((JRubyConstructor)ctor).runtime, SafeConstructorImpl.constructYamlInt(ctor, node));
    }

    public static Object constructYamlFloat(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newFloat((Double)SafeConstructorImpl.constructYamlFloat(ctor, node));
    }

    public static Object constructYamlBinary(Constructor ctor, Node node) {
        Object b = SafeConstructorImpl.constructYamlBinary(ctor, node);
        if (b instanceof byte[]) {
            return RubyString.newString(((JRubyConstructor)ctor).runtime, new ByteList((byte[])b, false));
        }
        return ((JRubyConstructor)ctor).runtime.newString((String)b);
    }

    public static Object constructJava(Constructor ctor, String pref, Node node) {
        return SafeConstructorImpl.constructJava(ctor, pref, node);
    }

    public static Object constructRubyStruct(Constructor ctor, String tag, Node node) {
        RubyClass struct_type;
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule sClass = runtime.getModule("Struct");
        String[] nms = tag.split("::");
        int j = nms.length;
        for (int i = 0; i < j && sClass != null; sClass = (RubyModule)sClass.getConstant(nms[i]), ++i) {
        }
        HashMap props = new HashMap();
        Map val = (Map)ctor.constructMapping(node);
        Iterator iter = val.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry em = iter.next();
            if (!em.getKey().toString().startsWith("@")) continue;
            props.put(em.getKey(), em.getValue());
            iter.remove();
        }
        if (sClass == null) {
            IRubyObject[] params = new IRubyObject[val.size() + 1];
            params[0] = runtime.newString(tag);
            int i = 1;
            for (Map.Entry em : val.entrySet()) {
                params[i] = ((RubyString)em.getKey()).intern();
                ++i;
            }
            struct_type = RubyStruct.newInstance(runtime.getModule("Struct"), params, Block.NULL_BLOCK);
        } else {
            struct_type = (RubyClass)sClass;
        }
        IRubyObject st = struct_type.callMethod(runtime.getCurrentContext(), "new");
        RubyArray members = RubyStruct.members(struct_type, Block.NULL_BLOCK);
        int j2 = members.size();
        for (int i = 0; i < j2; ++i) {
            IRubyObject m = members.eltInternal(i);
            st.callMethod(runtime.getCurrentContext(), m.toString() + "=", (IRubyObject)val.get(m));
        }
        for (Map.Entry em : props.entrySet()) {
            ((RubyObject)st).instance_variable_set((IRubyObject)em.getKey(), (IRubyObject)em.getValue());
        }
        return st;
    }

    public static Object constructRuby(Constructor ctor, RubyClass theCls, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        if (theCls.respondsTo("yaml_new")) {
            RubyHash vars = (RubyHash)((JRubyConstructor)ctor).constructRubyMapping(node);
            return theCls.callMethod(runtime.getCurrentContext(), "yaml_new", new IRubyObject[]{theCls, runtime.newString(node.getTag()), vars});
        }
        final RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        ctor.doRecursionFix(node, oo);
        for (IRubyObject key : vars.keySet()) {
            Object val = vars.get(key);
            if (val instanceof LinkNode) {
                final String KEY = "@" + key.toString();
                ctor.addFixer((Node)((LinkNode)val).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object real) {
                        oo.setInstanceVariable(KEY, (IRubyObject)real);
                    }
                });
                continue;
            }
            oo.setInstanceVariable("@" + key.toString(), (IRubyObject)val);
        }
        return oo;
    }

    public static Object constructRuby(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        return JRubyConstructor.constructRuby(ctor, theCls, node);
    }

    public static Object constructRubyRegexp(Constructor ctor, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        String s1 = ctor.constructScalar(node).toString();
        return runtime.evalScript(s1);
    }

    public static Object constructRubyRange(Constructor ctor, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        if (node instanceof ScalarNode) {
            String second;
            String first;
            String s1 = ctor.constructScalar(node).toString();
            boolean exc = false;
            int ix = -1;
            ix = s1.indexOf("...");
            if (ix != -1) {
                first = s1.substring(0, ix);
                second = s1.substring(ix + 3);
                exc = true;
            } else {
                ix = s1.indexOf("..");
                first = s1.substring(0, ix);
                second = s1.substring(ix + 2);
            }
            IRubyObject fist = runtime.getModule("YAML").callMethod(runtime.getCurrentContext(), "load", runtime.newString(first));
            IRubyObject sic = runtime.getModule("YAML").callMethod(runtime.getCurrentContext(), "load", runtime.newString(second));
            return RubyRange.newRange(runtime, fist, sic, exc);
        }
        Map vars = (Map)ctor.constructMapping(node);
        IRubyObject beg = (IRubyObject)vars.get(runtime.newString("begin"));
        IRubyObject end = (IRubyObject)vars.get(runtime.newString("end"));
        boolean excl = ((IRubyObject)vars.get(runtime.newString("excl"))).isTrue();
        return RubyRange.newRange(runtime, beg, end, excl);
    }

    public static Object findAndCreateFromCustomTagging(Constructor ctor, Node node) {
        String tag = node.getTag();
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyClass clazz = (RubyClass)runtime.getModule("YAML").callMethod(runtime.getCurrentContext(), "tagged_classes").callMethod(runtime.getCurrentContext(), "[]", runtime.newString(tag));
        if (clazz != null && !clazz.isNil()) {
            return JRubyConstructor.constructRuby(ctor, clazz, node);
        }
        return null;
    }

    public static Object constructRubyInt(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        IRubyObject val = (IRubyObject)JRubyConstructor.constructYamlInt(ctor, node);
        oo.callInit(new IRubyObject[]{val}, Block.NULL_BLOCK);
        return oo;
    }

    public static Object constructRubyMap(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        for (IRubyObject key : vars.keySet()) {
            oo.callMethod(oo.getRuntime().getCurrentContext(), 5, "[]=", new IRubyObject[]{key, (IRubyObject)vars.get(key)});
        }
        return oo;
    }

    public static Object constructRubySequence(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        List vars = (List)ctor.constructSequence(node);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            oo.callMethod(oo.getRuntime().getCurrentContext(), 12, "<<", new IRubyObject[]{(IRubyObject)iter.next()});
        }
        return oo;
    }

    static {
        JRubyConstructor.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlNull(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBool(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlOmap(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlPairs(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSet(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlInt(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlFloat(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlTimestamp(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlTimestampYMD(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlStr(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBinary(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSeq(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlMap(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:range", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructRubyRange(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:regexp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructRubyRegexp(self, node);
            }
        });
        JRubyConstructor.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                Object v1 = JRubyConstructor.findAndCreateFromCustomTagging(self, node);
                if (null != v1) {
                    return v1;
                }
                return self.constructPrivateType(node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyMap(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:int:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyInt(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubySequence(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:ruby/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructJava(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:java.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructJava(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:struct:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyStruct(self, pref, node);
            }
        });
    }
}

