/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;

public class IOHandlerProcess
extends IOHandlerJavaIO {
    protected InputStream input = null;
    protected OutputStream output = null;
    protected Process process = null;

    public IOHandlerProcess(Ruby runtime, Process process, IOModes modes) throws IOException {
        super(runtime);
        if (process == null) {
            throw new IOException("Null process");
        }
        this.process = process;
        this.input = process.getInputStream();
        this.output = process.getOutputStream();
        this.isOpen = true;
        this.modes = modes;
        this.isSync = true;
        this.fileno = RubyIO.getNewFileno();
    }

    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerProcess(this.getRuntime(), this.process, this.modes);
    }

    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        this.input.close();
        this.output.close();
        this.process.destroy();
        this.process = null;
    }

    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWriteable();
        this.output.flush();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.input.read();
        if (c == -1) {
            return true;
        }
        this.ungetc(c);
        return false;
    }

    public int pid() {
        return this.process.hashCode();
    }

    public long pos() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void resetByModes(IOModes newModes) {
    }

    public void rewind() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void seek(long offset, int type) throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void sync() throws IOException {
        this.output.flush();
    }

    public int sysread() throws IOException {
        return this.input.read();
    }

    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        int read;
        int n;
        this.checkReadable();
        byte[] buf = new byte[number];
        for (read = 0; read < number; read += n) {
            n = this.input.read(buf, read, number - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        return new ByteList(buf, 0, read, false);
    }

    public int syswrite(ByteList buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        if (buf == null || buf.realSize == 0) {
            return 0;
        }
        this.output.write(buf.bytes, 0, buf.realSize);
        if (this.isSync) {
            this.sync();
        }
        return buf.realSize;
    }

    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.output.write(c);
        if (this.isSync) {
            this.sync();
        }
        return 1;
    }

    public void truncate(long newLength) throws IOException, IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public FileChannel getFileChannel() {
        assert (false) : "No file channel for process streams";
        return null;
    }
}

