/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(Ruby runtime, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg, JumpException.JumpType.RaiseJump);
        if (msg == null) {
            msg = "No message available";
        }
        this.setException((RubyException)excptnClass.callMethod(runtime.getCurrentContext(), "new", new IRubyObject[]{excptnClass.getRuntime().newString(msg)}, Block.NULL_BLOCK), nativeException);
    }

    public RaiseException(RubyException exception, boolean isNativeException) {
        super(JumpException.JumpType.RaiseJump);
        this.setException(exception, isNativeException);
    }

    public static RaiseException createNativeRaiseException(Ruby runtime, Throwable cause) {
        NativeException nativeException = new NativeException(runtime, runtime.getClass("NativeException"), cause);
        return new RaiseException(cause, nativeException);
    }

    private static String buildMessage(Throwable exception) {
        StringBuffer sb = new StringBuffer();
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        sb.append("Native Exception: '").append(exception.getClass()).append("'; ");
        sb.append("Message: ").append(exception.getMessage()).append("; ");
        sb.append("StackTrace: ").append(stackTrace.getBuffer().toString());
        return sb.toString();
    }

    public RaiseException(Throwable cause, NativeException nativeException) {
        super(RaiseException.buildMessage(cause), cause, JumpException.JumpType.RaiseJump);
        this.setException(nativeException, false);
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException newException, boolean nativeException) {
        Ruby runtime = newException.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (!context.isWithinDefined()) {
            runtime.getGlobalVariables().set("$!", newException);
        }
        if (runtime.getTraceFunction() != null) {
            runtime.callTraceFunction(context, "return", context.getPosition(), RubyBinding.newBinding(runtime), context.getFrameName(), context.getFrameKlazz());
        }
        this.exception = newException;
        if (runtime.getStackTraces() > 5) {
            return;
        }
        runtime.setStackTraces(runtime.getStackTraces() + 1);
        if (newException.callMethod(context, "backtrace").isNil() && context.getSourceFile() != null) {
            IRubyObject backtrace = context.createBacktrace(0, nativeException);
            newException.callMethod(context, "set_backtrace", backtrace);
        }
        runtime.setStackTraces(runtime.getStackTraces() - 1);
    }

    public Throwable fillInStackTrace() {
        return this.originalFillInStackTrace();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        StackTraceElement[] trace = this.getStackTrace();
        int externalIndex = 0;
        int i = trace.length - 1;
        while (i > 0 && trace[i].getClassName().indexOf("org.jruby.evaluator") < 0) {
            externalIndex = i--;
        }
        IRubyObject backtrace = this.exception.backtrace();
        Ruby runtime = backtrace.getRuntime();
        if (runtime.getNil() != backtrace) {
            String firstLine = backtrace.callMethod(runtime.getCurrentContext(), "first").callMethod(runtime.getCurrentContext(), 14, "to_s").toString();
            ps.print(firstLine + ": ");
        }
        ps.println(this.exception.message + " (" + this.exception.getMetaClass().toString() + ")");
        this.exception.printBacktrace(ps);
        ps.println("\t...internal jruby stack elided...");
        for (int i2 = externalIndex; i2 < trace.length; ++i2) {
            ps.println("\tfrom " + trace[i2].toString());
        }
    }

    public void printStackTrace(PrintWriter pw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(baos));
        pw.print(baos.toString());
    }
}

