/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

public class JumpException
extends RuntimeException {
    private static final long serialVersionUID = -228162532535826617L;
    private JumpType jumpType;
    private Object target;
    private Object value;
    private boolean inKernelLoop = false;

    public JumpException() {
    }

    public JumpException(JumpType jumpType) {
        this.jumpType = jumpType;
    }

    public JumpException(String msg, JumpType jumpType) {
        super(msg);
        this.jumpType = jumpType;
    }

    public JumpException(String msg, Throwable cause, JumpType jumpType) {
        super(msg, cause);
        this.jumpType = jumpType;
    }

    public Throwable fillInStackTrace() {
        return this;
    }

    protected Throwable originalFillInStackTrace() {
        return super.fillInStackTrace();
    }

    public JumpType getJumpType() {
        return this.jumpType;
    }

    public void setJumpType(JumpType jumpType) {
        this.jumpType = jumpType;
        this.target = null;
        this.value = null;
        this.inKernelLoop = false;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setBreakInKernelLoop(boolean inKernelLoop) {
        this.inKernelLoop = inKernelLoop;
    }

    public boolean isBreakInKernelLoop() {
        return this.inKernelLoop;
    }

    public static final class JumpType {
        public static final int BREAK = 0;
        public static final int NEXT = 1;
        public static final int REDO = 2;
        public static final int RETRY = 3;
        public static final int RETURN = 4;
        public static final int THROW = 5;
        public static final int RAISE = 6;
        public static final int SPECIAL = 7;
        public static final JumpType BreakJump = new JumpType(0);
        public static final JumpType NextJump = new JumpType(1);
        public static final JumpType RedoJump = new JumpType(2);
        public static final JumpType RetryJump = new JumpType(3);
        public static final JumpType ReturnJump = new JumpType(4);
        public static final JumpType ThrowJump = new JumpType(5);
        public static final JumpType RaiseJump = new JumpType(6);
        public static final JumpType SpecialJump = new JumpType(7);
        private final int typeId;

        private JumpType(int typeId) {
            this.typeId = typeId;
        }

        public int getTypeId() {
            return this.typeId;
        }
    }
}

