/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalCache;
import org.jruby.util.ByteList;

public class UnmarshalStream
extends BufferedInputStream {
    protected final Ruby runtime;
    private UnmarshalCache cache;
    private IRubyObject proc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UnmarshalStream(Ruby runtime, InputStream in, IRubyObject proc) throws IOException {
        super(in);
        this.runtime = runtime;
        this.cache = new UnmarshalCache(runtime);
        this.proc = proc;
        in.read();
        in.read();
    }

    public IRubyObject unmarshalObject() throws IOException {
        int type = this.readUnsignedByte();
        IRubyObject result = this.cache.isLinkType(type) ? this.cache.readLink(this, type) : this.unmarshalObjectDirectly(type);
        return result;
    }

    public void registerLinkTarget(IRubyObject newObject) {
        this.cache.register(newObject);
    }

    private IRubyObject unmarshalObjectDirectly(int type) throws IOException {
        IRubyObject rubyObj = null;
        switch (type) {
            case 73: {
                rubyObj = this.unmarshalObject();
                this.defaultInstanceVarsUnmarshal(rubyObj);
                break;
            }
            case 48: {
                rubyObj = this.runtime.getNil();
                break;
            }
            case 84: {
                rubyObj = this.runtime.getTrue();
                break;
            }
            case 70: {
                rubyObj = this.runtime.getFalse();
                break;
            }
            case 34: {
                rubyObj = RubyString.unmarshalFrom(this);
                break;
            }
            case 105: {
                rubyObj = RubyFixnum.unmarshalFrom(this);
                break;
            }
            case 102: {
                rubyObj = RubyFloat.unmarshalFrom(this);
                break;
            }
            case 47: {
                rubyObj = RubyRegexp.unmarshalFrom(this);
                break;
            }
            case 58: {
                rubyObj = RubySymbol.unmarshalFrom(this);
                break;
            }
            case 91: {
                rubyObj = RubyArray.unmarshalFrom(this);
                break;
            }
            case 123: {
                rubyObj = RubyHash.unmarshalFrom(this, false);
                break;
            }
            case 125: {
                rubyObj = RubyHash.unmarshalFrom(this, true);
                break;
            }
            case 99: {
                rubyObj = RubyClass.unmarshalFrom(this);
                break;
            }
            case 109: {
                rubyObj = RubyModule.unmarshalFrom(this);
                break;
            }
            case 101: {
                RubySymbol moduleName = (RubySymbol)this.unmarshalObject();
                RubyModule tp = null;
                try {
                    tp = this.runtime.getClassFromPath(moduleName.asSymbol());
                }
                catch (RaiseException e) {
                    if (e.getException().isKindOf(this.runtime.getModule("NameError"))) {
                        throw this.runtime.newArgumentError("undefined class/module " + moduleName.asSymbol());
                    }
                    throw e;
                }
                rubyObj = this.unmarshalObject();
                tp.extend_object(rubyObj);
                tp.callMethod(this.runtime.getCurrentContext(), "extended", rubyObj);
                break;
            }
            case 108: {
                rubyObj = RubyBignum.unmarshalFrom(this);
                break;
            }
            case 83: {
                rubyObj = RubyStruct.unmarshalFrom(this);
                break;
            }
            case 111: {
                rubyObj = this.defaultObjectUnmarshal();
                break;
            }
            case 117: {
                rubyObj = this.userUnmarshal();
                break;
            }
            case 85: {
                rubyObj = this.userNewUnmarshal();
                break;
            }
            case 67: {
                rubyObj = this.uclassUnmarshall();
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError("dump format error(" + (char)type + ")");
            }
        }
        if (this.proc != null && type != 58) {
            this.proc.callMethod(this.getRuntime().getCurrentContext(), "call", new IRubyObject[]{rubyObj});
        }
        return rubyObj;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.read();
        if (result == -1) {
            throw new IOException("Unexpected end of stream");
        }
        return result;
    }

    public byte readSignedByte() throws IOException {
        int b = this.readUnsignedByte();
        if (b > 127) {
            return (byte)(b - 256);
        }
        return (byte)b;
    }

    public ByteList unmarshalString() throws IOException {
        int length = this.unmarshalInt();
        byte[] buffer = new byte[length];
        int b = 0;
        int i = 0;
        while (i < length && (b = this.read()) != -1) {
            buffer[i++] = (byte)b;
        }
        if (i < length) {
            throw new IOException("Unexpected end of stream");
        }
        return new ByteList(buffer, false);
    }

    public int unmarshalInt() throws IOException {
        long result;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (5 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -5) {
            return c + 5;
        }
        if (c > 0) {
            result = 0L;
            for (int i = 0; i < c; ++i) {
                result |= (long)this.readUnsignedByte() << 8 * i;
            }
        } else {
            c = -c;
            result = -1L;
            for (int i = 0; i < c; ++i) {
                result &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                result |= (long)this.readUnsignedByte() << 8 * i;
            }
        }
        return (int)result;
    }

    private IRubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        RubyClass type = null;
        try {
            type = (RubyClass)this.runtime.getClassFromPath(className.asSymbol());
        }
        catch (RaiseException e) {
            if (e.getException().isKindOf(this.runtime.getModule("NameError"))) {
                throw this.runtime.newArgumentError("undefined class/module " + className.asSymbol());
            }
            throw e;
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)"type shouldn't be null.");
        }
        IRubyObject result = (IRubyObject)type.unmarshal(this);
        return result;
    }

    public void defaultInstanceVarsUnmarshal(IRubyObject object) throws IOException {
        int count = this.unmarshalInt();
        for (int i = 0; i < count; ++i) {
            String name = this.unmarshalObject().asSymbol();
            IRubyObject value = this.unmarshalObject();
            object.setInstanceVariable(name, value);
        }
    }

    private IRubyObject uclassUnmarshall() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        RubyClass type = (RubyClass)this.runtime.getClassFromPath(className.asSymbol());
        IRubyObject result = this.unmarshalObject();
        result.setMetaClass(type);
        return result;
    }

    private IRubyObject userUnmarshal() throws IOException {
        String className = this.unmarshalObject().asSymbol();
        ByteList marshaled = this.unmarshalString();
        RubyClass classInstance = this.findClass(className);
        if (!classInstance.respondsTo("_load")) {
            throw this.runtime.newTypeError("class " + classInstance.getName() + " needs to have method `_load'");
        }
        IRubyObject result = classInstance.callMethod(this.getRuntime().getCurrentContext(), "_load", RubyString.newString(this.getRuntime(), marshaled));
        this.registerLinkTarget(result);
        return result;
    }

    private IRubyObject userNewUnmarshal() throws IOException {
        String className = this.unmarshalObject().asSymbol();
        IRubyObject marshaled = this.unmarshalObject();
        RubyClass classInstance = this.findClass(className);
        IRubyObject result = classInstance.allocate();
        result.callMethod(this.getRuntime().getCurrentContext(), "marshal_load", marshaled);
        this.registerLinkTarget(result);
        return result;
    }

    private RubyClass findClass(String className) {
        RubyModule classInstance;
        try {
            classInstance = this.runtime.getClassFromPath(className);
        }
        catch (RaiseException e) {
            if (e.getException().isKindOf(this.runtime.getModule("NameError"))) {
                throw this.runtime.newArgumentError("undefined class/module " + className);
            }
            throw e;
        }
        if (!(classInstance instanceof RubyClass)) {
            throw this.runtime.newArgumentError(className + " does not refer class");
        }
        return (RubyClass)classInstance;
    }

    static {
        $assertionsDisabled = !UnmarshalStream.class.desiredAssertionStatus();
    }
}

