/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.collections.SinglyLinkedList;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final String COMPILED_SUPER_CLASS = CompiledMethod.class.getName().replace('.', '/');
    private static final String IRUB_ID = "Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String BLOCK_ID = "Lorg/jruby/runtime/Block;";
    private static final String COMPILED_CALL_SIG = "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/Block;)Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String COMPILED_SUPER_SIG = "(" + InvocationMethodFactory.ci(RubyModule.class) + InvocationMethodFactory.ci(Arity.class) + InvocationMethodFactory.ci(Visibility.class) + InvocationMethodFactory.ci(SinglyLinkedList.class) + InvocationMethodFactory.ci(StaticScope.class) + ")V";
    private JRubyClassLoader classLoader;

    public InvocationMethodFactory() {
    }

    public InvocationMethodFactory(JRubyClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    private static String ci(Class n) {
        return "L" + InvocationMethodFactory.p(n) + ";";
    }

    private ClassWriter createCompiledCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", COMPILED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitVarInsn(25, 5);
        mv.visitMethodInsn(183, sup, "<init>", COMPILED_SUPER_SIG);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private Class tryClass(Ruby runtime, String name) {
        try {
            if (this.classLoader == null) {
                return Class.forName(name, true, runtime.getJRubyClassLoader());
            }
            return this.classLoader.loadClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class endCall(Ruby runtime, ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        if (this.classLoader == null) {
            this.classLoader = runtime.getJRubyClassLoader();
        }
        return this.classLoader.defineClass(name, code);
    }

    private DynamicMethod getCompleteMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility, SinglyLinkedList cref, StaticScope scope, String sup) {
        String typePath = InvocationMethodFactory.p(type);
        String mname = type.getName() + "Invoker" + method + arity;
        String mnamePath = typePath + "Invoker" + method + arity;
        Class c = this.tryClass(implementationClass.getRuntime(), mname);
        try {
            if (c == null) {
                ClassWriter cw = this.createCompiledCtor(mnamePath, sup);
                MethodVisitor mv = null;
                String ret = IRUB_ID;
                mv = cw.visitMethod(1, "call", COMPILED_CALL_SIG, null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitMethodInsn(184, typePath, method, "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/Block;)" + ret);
                mv.visitInsn(176);
                c = this.endCall(implementationClass.getRuntime(), cw, mv, mname);
            }
            return (DynamicMethod)c.getConstructor(RubyModule.class, Arity.class, Visibility.class, SinglyLinkedList.class, StaticScope.class).newInstance(implementationClass, arity, visibility, cref, scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    public DynamicMethod getCompiledMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility, SinglyLinkedList cref, StaticScope scope) {
        return this.getCompleteMethod(implementationClass, type, method, arity, visibility, cref, scope, COMPILED_SUPER_CLASS);
    }
}

