/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private static ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIconv(runtime, klass);
        }
    };

    public RubyIconv(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static void createIconv(Ruby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject(), ICONV_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyIconv.class);
        iconvClass.getMetaClass().defineFastMethod("iconv", callbackFactory.getOptSingletonMethod("iconv"));
        iconvClass.getMetaClass().defineFastMethod("conv", callbackFactory.getOptSingletonMethod("conv"));
        iconvClass.getMetaClass().defineMethod("open", callbackFactory.getSingletonMethod("open", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        iconvClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        iconvClass.defineFastMethod("iconv", callbackFactory.getFastOptMethod("iconv"));
        iconvClass.defineFastMethod("close", callbackFactory.getFastMethod("close"));
        RubyModule failure = iconvClass.defineModuleUnder("Failure");
        CallbackFactory failureCallbackFactory = runtime.callbackFactory(RubyFailure.class);
        RubyClass argumentError = runtime.getClass("ArgumentError");
        String[] iconvErrors = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i = 0; i < iconvErrors.length; ++i) {
            RubyClass subClass = iconvClass.defineClassUnder(iconvErrors[i], argumentError, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            subClass.defineMethod("initialize", failureCallbackFactory.getOptMethod("initialize"));
            subClass.defineFastMethod("success", failureCallbackFactory.getFastMethod("success"));
            subClass.defineFastMethod("failed", failureCallbackFactory.getFastMethod("failed"));
            subClass.defineFastMethod("inspect", failureCallbackFactory.getFastMethod("inspect"));
            subClass.includeModule(failure);
        }
    }

    private static String getCharset(String encoding) {
        int index = encoding.indexOf("//");
        if (index == -1) {
            return encoding;
        }
        return encoding.substring(0, index);
    }

    private static boolean isIgnore(String encoding) {
        return encoding.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject to, IRubyObject from, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyIconv iconv = (RubyIconv)runtime.getClass("Iconv").newInstance(new IRubyObject[]{to, from}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return iconv;
        }
        IRubyObject result = runtime.getNil();
        try {
            result = block.yield(recv.getRuntime().getCurrentContext(), iconv);
        }
        finally {
            iconv.close();
        }
        return result;
    }

    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args, 2, 2);
        Ruby runtime = this.getRuntime();
        if (!args[0].respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + args[0].getMetaClass() + " into String");
        }
        if (!args[1].respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + args[1].getMetaClass() + " into String");
        }
        String to = args[0].convertToString().toString();
        String from = args[1].convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(from)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(to)).newEncoder();
            if (!RubyIconv.isIgnore(from)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            if (!RubyIconv.isIgnore(to)) {
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException e) {
            throw runtime.newArgumentError("invalid encoding");
        }
        catch (UnsupportedCharsetException e) {
            throw runtime.newArgumentError("invalid encoding");
        }
        catch (Exception e) {
            throw runtime.newSystemCallError(e.toString());
        }
        return this;
    }

    public IRubyObject close() {
        this.toEncoding = null;
        this.fromEncoding = null;
        return this.getRuntime().newString("");
    }

    public IRubyObject iconv(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        args = Arity.scanArgs(runtime, args, 1, 2);
        int start = 0;
        int length = -1;
        if (args[0].isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return runtime.newString("");
        }
        if (!args[0].respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + args[0].getMetaClass() + " into String");
        }
        if (!args[1].isNil()) {
            start = RubyNumeric.fix2int(args[1]);
        }
        if (!args[2].isNil()) {
            length = RubyNumeric.fix2int(args[2]);
        }
        IRubyObject result = this._iconv(args[0].convertToString(), start, length);
        return result;
    }

    private IRubyObject _iconv(RubyString str, int start, int length) {
        ByteList bytes = str.getByteList();
        if (length < 0) {
            length = bytes.length() - start;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), start, length);
        try {
            CharBuffer cbuf = this.fromEncoding.decode(buf);
            buf = this.toEncoding.encode(cbuf);
        }
        catch (MalformedInputException e) {
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException e) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        byte[] arr = buf.array();
        return this.getRuntime().newString(new ByteList(arr, 0, buf.limit()));
    }

    public static IRubyObject iconv(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "iconv");
    }

    public static IRubyObject conv(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "conv").join(recv.getRuntime().newString(""));
    }

    public static RubyArray convertWithArgs(IRubyObject recv, IRubyObject[] args, String function) {
        Arity.checkArgumentCount(recv.getRuntime(), args, 3, -1);
        String fromEncoding = args[1].convertToString().toString();
        String toEncoding = args[0].convertToString().toString();
        RubyArray array = recv.getRuntime().newArray();
        for (int i = 2; i < args.length; ++i) {
            array.append(RubyIconv.convert2(fromEncoding, toEncoding, args[i].convertToString()));
        }
        return array;
    }

    private static IRubyObject convert2(String fromEncoding, String toEncoding, RubyString original) {
        if (fromEncoding.equals(toEncoding)) {
            return original;
        }
        try {
            ByteList bytes = original.getByteList();
            ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            CharsetDecoder decoder = Charset.forName(RubyIconv.getCharset(fromEncoding)).newDecoder();
            if (!RubyIconv.isIgnore(fromEncoding)) {
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            CharBuffer cbuf = decoder.decode(buf);
            CharsetEncoder encoder = Charset.forName(RubyIconv.getCharset(toEncoding)).newEncoder();
            if (!RubyIconv.isIgnore(toEncoding)) {
                encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            buf = encoder.encode(cbuf);
            byte[] arr = buf.array();
            return RubyString.newString(original.getRuntime(), new ByteList(arr, 0, buf.limit()));
        }
        catch (UnsupportedCharsetException e) {
            throw original.getRuntime().newInvalidEncoding("invalid encoding");
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return original.getRuntime().getNil();
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyFailure(runtime, klass);
            }
        };

        public static RubyFailure newInstance(Ruby runtime, RubyClass excptnClass, String msg) {
            return new RubyFailure(runtime, excptnClass, msg);
        }

        protected RubyFailure(Ruby runtime, RubyClass rubyClass) {
            this(runtime, rubyClass, null);
        }

        public RubyFailure(Ruby runtime, RubyClass rubyClass, String message) {
            super(runtime, rubyClass, message);
        }

        public IRubyObject initialize(IRubyObject[] args, Block block) {
            Arity.checkArgumentCount(this.getRuntime(), args, 1, 3);
            super.initialize(args, block);
            this.success = args.length >= 2 ? args[1] : this.getRuntime().getNil();
            this.failed = args.length == 3 ? args[2] : this.getRuntime().getNil();
            return this;
        }

        public IRubyObject success() {
            return this.success;
        }

        public IRubyObject failed() {
            return this.failed;
        }

        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuffer buffer = new StringBuffer("#<");
            buffer.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            buffer.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(buffer.toString());
        }
    }
}

