/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNativeThread
extends Thread {
    private Ruby runtime;
    private Frame currentFrame;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;

    protected RubyNativeThread(RubyThread rubyThread, IRubyObject[] args, Block currentBlock) {
        super(rubyThread.getRuntime().getThreadService().getRubyThreadGroup(), "Ruby Thread" + rubyThread.hash());
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(false, currentBlock);
        this.currentFrame = tc.getCurrentFrame();
        this.arguments = args;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            this.runtime.getThreadService().registerNewThread(this.rubyThread);
            ThreadContext context = this.runtime.getCurrentContext();
            context.preRunThread(this.currentFrame);
            try {
                try {
                    this.rubyThread.notifyStarted();
                    IRubyObject result = this.proc.call(this.arguments);
                    this.rubyThread.cleanTerminate(result);
                }
                catch (ThreadKill tk) {
                    Object object = this.rubyThread.killLock;
                    synchronized (object) {
                        this.rubyThread.killLock.notifyAll();
                    }
                    Object var6_6 = null;
                    this.runtime.getThreadService().setCritical(false);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    break block8;
                }
                catch (RaiseException e) {
                    this.rubyThread.exceptionRaised(e);
                    Object var6_7 = null;
                    this.runtime.getThreadService().setCritical(false);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                }
                Object var6_5 = null;
                this.runtime.getThreadService().setCritical(false);
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.runtime.getThreadService().setCritical(false);
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                throw throwable;
            }
        }
    }
}

