/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRManager;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.ValueCompiler;
import org.jruby.ir.targets.indy.ArrayBootstrap;
import org.jruby.ir.targets.indy.BignumObjectSite;
import org.jruby.ir.targets.indy.BuildDynamicStringSite;
import org.jruby.ir.targets.indy.CallSiteCacheBootstrap;
import org.jruby.ir.targets.indy.FixnumObjectSite;
import org.jruby.ir.targets.indy.FloatObjectSite;
import org.jruby.ir.targets.indy.LiteralValueBootstrap;
import org.jruby.ir.targets.indy.RangeObjectSite;
import org.jruby.ir.targets.indy.RegexpObjectSite;
import org.jruby.ir.targets.indy.StringBootstrap;
import org.jruby.ir.targets.indy.SymbolObjectSite;
import org.jruby.ir.targets.indy.SymbolProcObjectSite;
import org.jruby.ir.targets.simple.NormalValueCompiler;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;

public class IndyValueCompiler
implements ValueCompiler {
    private final IRBytecodeAdapter compiler;
    private final NormalValueCompiler normalValueCompiler;

    public IndyValueCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalValueCompiler = new NormalValueCompiler(compiler);
    }

    @Override
    public void pushRuntime() {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("runtime", CodegenUtils.sig(Ruby.class, ThreadContext.class), LiteralValueBootstrap.CONTEXT_VALUE_HANDLE, new Object[0]);
    }

    @Override
    public void pushArrayClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getArray", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushHashClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getHash", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushObjectClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getObject", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushSymbolClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getSymbol", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushUndefined() {
        this.compiler.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    @Override
    public void pushFixnum(long l) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FixnumObjectSite.BOOTSTRAP, l);
    }

    @Override
    public void pushFloat(double d) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("flote", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FloatObjectSite.BOOTSTRAP, d);
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("string", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.STRING_BOOTSTRAP, RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr);
    }

    @Override
    public void pushChilledString(ByteList bl, int cr, String file2, int line) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("chilled", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.CSTRING_BOOTSTRAP, RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr, file2, line);
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr, String file2, int line) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.FSTRING_BOOTSTRAP, RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr, file2, line);
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.FSTRING_SIMPLE_BOOTSTRAP, RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr);
    }

    @Override
    public void pushEmptyString(Encoding encoding2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("emptyString", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.EMPTY_STRING_BOOTSTRAP, encoding2.toString());
    }

    @Override
    public void pushBufferString(Encoding encoding2, int size2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("bufferString", CodegenUtils.sig(RubyString.class, ThreadContext.class), StringBootstrap.BUFFER_STRING_BOOTSTRAP, encoding2.toString(), size2);
    }

    @Override
    public void buildDynamicString(Encoding encoding2, int estimatedSize, boolean frozen, boolean chilled, boolean debugFrozen, String file2, int line, List<ValueCompiler.DStringElement> elements) {
        if (elements.size() > 50 || !((Boolean)Options.COMPILE_INVOKEDYNAMIC.load()).booleanValue()) {
            this.normalValueCompiler.buildDynamicString(encoding2, estimatedSize, frozen, chilled, debugFrozen, file2, line, elements);
            return;
        }
        this.compiler.loadContext();
        long descriptor = 0L;
        int bit = 0;
        int otherCount = 0;
        ArrayList<Object> bootstrapArgs = new ArrayList<Object>();
        for (ValueCompiler.DStringElement elt : elements) {
            switch (elt.type()) {
                case STRING: {
                    StringLiteral str = (StringLiteral)elt.value();
                    descriptor = IndyValueCompiler.setBit(descriptor, bit);
                    bootstrapArgs.add(RubyEncoding.decodeRaw(str.getByteList()));
                    bootstrapArgs.add(str.getByteList().getEncoding().toString());
                    bootstrapArgs.add(str.getCodeRange());
                    break;
                }
                case OTHER: {
                    ((Runnable)elt.value()).run();
                    ++otherCount;
                }
            }
            ++bit;
        }
        bootstrapArgs.add(estimatedSize * 3 / 2);
        bootstrapArgs.add(encoding2.toString());
        bootstrapArgs.add(frozen);
        bootstrapArgs.add(chilled);
        bootstrapArgs.add(descriptor);
        bootstrapArgs.add(bit);
        this.compiler.adapter.invokedynamic("buildDynamicString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, otherCount)), BuildDynamicStringSite.BUILD_DSTRING_BOOTSTRAP, bootstrapArgs.toArray());
    }

    private static long setBit(long descriptor, int bit) {
        return descriptor | 1L << bit;
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.compiler.adapter.invokedynamic("bytelist", CodegenUtils.sig(ByteList.class, new Class[0]), StringBootstrap.BYTELIST_BOOTSTRAP, RubyEncoding.decodeRaw(bl), bl.getEncoding().toString());
    }

    @Override
    public void pushRange(Runnable begin2, Runnable end2, boolean exclusive) {
        this.compiler.loadContext();
        begin2.run();
        end2.run();
        this.compiler.adapter.invokedynamic("range", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class), RangeObjectSite.BOOTSTRAP, exclusive ? 1 : 0);
    }

    @Override
    public void pushRange(long begin2, long end2, boolean exclusive) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("range", CodegenUtils.sig(RubyRange.class, ThreadContext.class), RangeObjectSite.BOOTSTRAP_LONG_LONG, begin2, end2, exclusive ? 1 : 0);
    }

    @Override
    public void pushEndlessRange(long end2, boolean exclusive) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("rangeEndless", CodegenUtils.sig(RubyRange.class, ThreadContext.class), RangeObjectSite.BOOTSTRAP_LONG, end2, exclusive ? 1 : 0);
    }

    @Override
    public void pushBeginlessRange(long begin2, boolean exclusive) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("rangeBeginless", CodegenUtils.sig(RubyRange.class, ThreadContext.class), RangeObjectSite.BOOTSTRAP_LONG, begin2, exclusive ? 1 : 0);
    }

    @Override
    public void pushRange(ByteList begin2, int beginCR, ByteList end2, int endCR, boolean exclusive) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("range", CodegenUtils.sig(RubyRange.class, ThreadContext.class), RangeObjectSite.BOOTSTRAP_STRING_STRING, RubyEncoding.decodeRaw(begin2), begin2.getEncoding().toString(), beginCR, RubyEncoding.decodeRaw(end2), end2.getEncoding().toString(), endCR, exclusive ? 1 : 0);
    }

    @Override
    public void pushRegexp(ByteList source2, int options2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("regexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class), RegexpObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(source2), source2.getEncoding().toString(), options2);
    }

    @Override
    public void pushSymbol(ByteList bytes2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void pushSymbolProc(ByteList bytes2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("symbolProc", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolProcObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void pushRubyEncoding(Encoding encoding2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("rubyEncoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), LiteralValueBootstrap.CONTEXT_VALUE_STRING_HANDLE, new String(encoding2.getName()));
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("encoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), LiteralValueBootstrap.CONTEXT_VALUE_STRING_HANDLE, new String(encoding2.getName()));
    }

    @Override
    public void pushNil() {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("nil", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), LiteralValueBootstrap.CONTEXT_VALUE_HANDLE, new Object[0]);
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic(b2 ? "True" : "False", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), LiteralValueBootstrap.CONTEXT_VALUE_HANDLE, new Object[0]);
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("bignum", CodegenUtils.sig(RubyBignum.class, ThreadContext.class), BignumObjectSite.BOOTSTRAP, bigint.toString());
    }

    @Override
    public void pushCallSite(String className, String siteName, String scopeFieldName, CallBase call2) {
        CallType callType = call2.getCallType();
        boolean profileCandidate = call2.hasLiteralClosure() && scopeFieldName != null && IRManager.IR_INLINER;
        boolean profiled = false;
        boolean refined = call2.isPotentiallyRefined();
        boolean specialSite = profiled || refined || profileCandidate;
        SkinnyMethodAdapter method2 = this.compiler.adapter;
        if (!specialSite) {
            method2.invokedynamic("callSite", CodegenUtils.sig(CachingCallSite.class, new Class[0]), CallSiteCacheBootstrap.CALLSITE, call2.getId(), callType.ordinal());
            return;
        }
        this.normalValueCompiler.pushCallSite(className, siteName, scopeFieldName, call2);
    }

    @Override
    public void pushConstantLookupSite(String className, String siteName, ByteList name2) {
        this.normalValueCompiler.pushConstantLookupSite(className, siteName, name2);
    }

    @Override
    public void pushFixnumArray(List<Long> values2) {
        String fixnumString = Helpers.encodeLongString(values2);
        this.compiler.adapter.invokedynamic("fixnumArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class), ArrayBootstrap.NUMERIC_ARRAY, fixnumString);
    }

    @Override
    public void pushFloatArray(List<Double> values2) {
        String doubleString = Helpers.encodeDoubleString(values2);
        this.compiler.adapter.invokedynamic("floatArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class), ArrayBootstrap.NUMERIC_ARRAY, doubleString);
    }
}

