/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.Inflater;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Zlib::GzipReader"}, parent="Zlib::GzipFile", include={"Enumerable"})
public class JZlibRubyGzipReader
extends RubyGzipFile {
    private static final int NEWLINE = 10;
    private static final int BUFF_SIZE = 4096;
    private int line = 0;
    private long position = 0L;
    private IOInputStream ioInputStream;
    private GZIPInputStream io;
    private PushbackInputStream bufferedStream;

    @JRubyMethod(name={"new"}, rest=true, meta=true, keywords=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        JZlibRubyGzipReader result2 = JZlibRubyGzipReader.newInstance(context, (RubyClass)recv2, args2);
        return RubyGzipFile.wrapBlock(context, result2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static JZlibRubyGzipReader newInstance(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibRubyGzipReader.newInstance(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, args2);
    }

    public static JZlibRubyGzipReader newInstance(ThreadContext context, RubyClass klass, IRubyObject[] args2) {
        JZlibRubyGzipReader result2 = (JZlibRubyGzipReader)klass.allocate(context);
        result2.callInit(args2, Block.NULL_BLOCK);
        return result2;
    }

    @JRubyMethod(name={"open"}, required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        args2[0] = Helpers.invoke(context, (IRubyObject)Access.fileClass(context), "open", args2[0], (IRubyObject)Create.newString(context, "rb"));
        JZlibRubyGzipReader gzio = JZlibRubyGzipReader.newInstance(context, (RubyClass)recv2, args2);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    public JZlibRubyGzipReader(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject stream) {
        this.realIo = stream;
        try {
            this.ioInputStream = new IOInputStream(this.realIo);
            this.io = new GZIPInputStream((InputStream)this.ioInputStream, 512, false);
            this.io.readHeader();
        }
        catch (IOException e) {
            RaiseException re = RubyZlib.newGzipFileError(context, "not in gzip format");
            byte[] input = this.io.getAvailIn();
            if (input != null && input.length > 0) {
                RubyException rubye = re.getException();
                rubye.setInstanceVariable("@input", Create.newString(context, new ByteList(input, 0, input.length)));
            }
            throw re;
        }
        this.position = 0L;
        this.line = 0;
        this.bufferedStream = new PushbackInputStream(new BufferedInputStream((InputStream)this.io), 512);
        this.mtime = RubyTime.newTime(context.runtime, this.io.getModifiedTime() * 1000L);
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject obj = this.initialize(context, args2[0]);
        IRubyObject opt = context.nil;
        if (argc == 2 && TypeConverter.checkHashType(context.runtime, opt = args2[1]).isNil()) {
            throw org.jruby.api.Error.argumentError(context, 2, 1);
        }
        this.ecopts(context, opt);
        return obj;
    }

    private long internalPosition() {
        Inflater inflater = this.io.getInflater();
        return inflater.getTotalIn() + (long)inflater.getAvailIn();
    }

    @JRubyMethod
    public IRubyObject rewind(ThreadContext context) {
        this.realIo.callMethod(context, "seek", new IRubyObject[]{Convert.asFixnum(context, -this.internalPosition()), Convert.asFixnum(context, 1)});
        this.initialize(context, this.realIo);
        return context.nil;
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno(ThreadContext context) {
        return Convert.asFixnum(context, this.line);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject lineno() {
        return this.lineno(this.getCurrentContext());
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject dst = this.gets(context, IRubyObject.NULL_ARRAY);
        if (dst.isNil()) {
            throw context.runtime.newEOFError();
        }
        return dst;
    }

    private IRubyObject internalGets(ThreadContext context, IRubyObject[] args2) throws IOException {
        ByteList sep = ((RubyString)Access.globalVariables(context).get("$/")).getByteList();
        int limit2 = -1;
        switch (args2.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args2[0].isNil()) {
                    return this.readAll(context);
                }
                IRubyObject tmp = args2[0].checkStringType();
                if (tmp.isNil()) {
                    limit2 = Convert.toInt(context, args2[0]);
                    break;
                }
                sep = tmp.convertToString().getByteList();
                break;
            }
            default: {
                limit2 = Convert.toInt(context, args2[1]);
                if (args2[0].isNil()) {
                    return this.readAll(context, limit2);
                }
                sep = args2[0].convertToString().getByteList();
            }
        }
        return this.internalSepGets(context, sep, limit2);
    }

    private IRubyObject internalSepGets(ThreadContext context, ByteList sep) throws IOException {
        return this.internalSepGets(context, sep, -1);
    }

    private ByteList newReadByteList() {
        ByteList byteList = new ByteList();
        return byteList;
    }

    private ByteList newReadByteList(int size2) {
        ByteList byteList = new ByteList(size2);
        return byteList;
    }

    private IRubyObject internalSepGets(ThreadContext context, ByteList sep, int limit2) throws IOException {
        int sepOffset;
        ByteList result2 = this.newReadByteList();
        boolean stripNewlines = false;
        if (sep.getRealSize() == 0) {
            sep = RubyIO.PARAGRAPH_SEPARATOR;
            stripNewlines = true;
        }
        if (stripNewlines) {
            this.skipNewlines();
        }
        int ce = -1;
        while (!(limit2 > 0 && result2.length() >= limit2 || (sepOffset = result2.length() - sep.getRealSize()) >= 0 && result2.startsWith(sep, sepOffset) || (ce = this.bufferedStream.read()) == -1)) {
            result2.append(ce);
        }
        this.fixBrokenTrailingCharacter(context, result2);
        if (stripNewlines) {
            this.skipNewlines();
        }
        if (0 == result2.length() && -1 == ce) {
            return context.nil;
        }
        ++this.line;
        this.position += (long)result2.length();
        return this.newStr(context, result2);
    }

    private void skipNewlines() throws IOException {
        int b2;
        while ((b2 = this.bufferedStream.read()) != -1) {
            if (b2 == 10) continue;
            this.bufferedStream.unread(b2);
            break;
        }
    }

    @JRubyMethod(name={"gets"}, optional=2, checkArity=false, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        try {
            IRubyObject result2 = this.internalGets(context, args2);
            if (!result2.isNil()) {
                context.setLastLine(result2);
            }
            return result2;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"read"}, optional=1, checkArity=false)
    public IRubyObject read(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        try {
            if (argc == 0 || args2[0].isNil()) {
                return this.readAll(context);
            }
            int len = Convert.toInt(context, args2[0]);
            if (len < 0) {
                throw org.jruby.api.Error.argumentError(context, "negative length " + len + " given");
            }
            if (len > 0) {
                ByteList buf = this.readSize(len);
                return buf == null ? context.nil : Create.newString(context, buf);
            }
            return RubyString.newEmptyBinaryString(context.runtime);
        }
        catch (IOException ioe) {
            String m = ioe.getMessage();
            if (m.startsWith("Unexpected end of ZLIB input stream")) {
                throw RubyZlib.newGzipFileError(context, ioe.getMessage());
            }
            if (m.startsWith("footer is not found")) {
                throw RubyZlib.newNoFooter(context, "footer is not found");
            }
            if (m.startsWith("incorrect data check")) {
                throw RubyZlib.newCRCError(context, "invalid compressed data -- crc error");
            }
            if (m.startsWith("incorrect length check")) {
                throw RubyZlib.newLengthError(context, "invalid compressed data -- length error");
            }
            throw RubyZlib.newDataError(context, ioe.getMessage());
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject readpartial(IRubyObject[] args2) {
        return this.readpartial(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1, checkArity=false)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        try {
            int len = Convert.toInt(context, args2[0]);
            if (len < 0) {
                throw org.jruby.api.Error.argumentError(context, "negative length " + len + " given");
            }
            return argc > 1 && !args2[1].isNil() ? this.readPartial(context, len, Convert.castAsString(context, args2[1])) : this.readPartial(context, len, null);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    private IRubyObject readPartial(ThreadContext context, int len, RubyString outbuf) throws IOException {
        ByteList val = this.newReadByteList(10);
        byte[] buffer = new byte[len];
        int read2 = this.bufferedStream.read(buffer, 0, len);
        if (read2 == -1) {
            return context.nil;
        }
        val.append(buffer, 0, read2);
        this.position += (long)val.length();
        if (outbuf != null) {
            outbuf.view(val);
        }
        return this.newStr(context, val);
    }

    private RubyString readAll(ThreadContext context) throws IOException {
        return this.readAll(context, -1);
    }

    private RubyString readAll(ThreadContext context, int limit2) throws IOException {
        int read2;
        ByteList val = this.newReadByteList(10);
        int rest = limit2 == -1 ? 4096 : limit2;
        byte[] buffer = new byte[rest];
        while (rest > 0 && (read2 = this.bufferedStream.read(buffer, 0, rest)) != -1) {
            val.append(buffer, 0, read2);
            if (limit2 == -1) continue;
            rest -= read2;
        }
        this.fixBrokenTrailingCharacter(context, val);
        this.position += (long)val.length();
        return this.newStr(context, val);
    }

    private ByteList readSize(int length2) throws IOException {
        byte[] buffer = new byte[length2];
        int toRead = length2;
        int offset2 = 0;
        while (toRead > 0) {
            int read2 = this.bufferedStream.read(buffer, offset2, toRead);
            if (read2 == -1) {
                if (offset2 != 0) break;
                return null;
            }
            toRead -= read2;
            offset2 += read2;
        }
        this.position += (long)(length2 - toRead);
        return new ByteList(buffer, 0, length2 - toRead, false);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_lineno(IRubyObject lineArg) {
        return this.set_lineno(this.getCurrentContext(), lineArg);
    }

    @JRubyMethod(name={"lineno="})
    public IRubyObject set_lineno(ThreadContext context, IRubyObject lineArg) {
        this.line = Convert.toInt(context, lineArg);
        return lineArg;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject pos() {
        return this.pos(this.getCurrentContext());
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext context) {
        return Convert.asFixnum(context, this.position);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject readchar() {
        return this.readchar(this.getCurrentContext());
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar(ThreadContext context) {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                throw context.runtime.newEOFError();
            }
            ++this.position;
            return Convert.asFixnum(context, value2);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getc() {
        return this.getbyte(this.getCurrentContext());
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                return context.nil;
            }
            ++this.position;
            return Convert.asFixnum(context, value2);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getbyte() {
        return this.getbyte(this.getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject readbyte() {
        return this.readbyte(this.getCurrentContext());
    }

    @JRubyMethod(name={"readbyte"})
    public IRubyObject readbyte(ThreadContext context) {
        IRubyObject dst = this.getbyte(context);
        if (dst.isNil()) {
            throw context.runtime.newEOFError();
        }
        return dst;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext context) {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                return context.nil;
            }
            ++this.position;
            return Create.newString(context, String.valueOf((char)(value2 & 0xFF)));
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    private boolean isEof() throws IOException {
        if (this.bufferedStream.available() == 0) {
            return true;
        }
        byte[] bytes2 = new byte[16];
        int read2 = this.bufferedStream.read(bytes2, 0, bytes2.length);
        if (read2 == -1) {
            return true;
        }
        this.bufferedStream.unread(bytes2, 0, read2);
        return this.bufferedStream.available() == 0;
    }

    @Override
    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        if (!this.closed) {
            try {
                this.bufferedStream.close();
                if (this.realIo.respondsTo("close")) {
                    this.realIo.callMethod(context, "close");
                }
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
        }
        this.closed = true;
        return this.realIo;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject eof() {
        return this.eof(this.getCurrentContext());
    }

    @JRubyMethod(name={"eof"})
    public IRubyObject eof(ThreadContext context) {
        try {
            return this.isEof() ? context.tru : context.fals;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject eof_p() {
        return this.eof_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"eof?"})
    public IRubyObject eof_p(ThreadContext context) {
        return this.eof(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject unused() {
        return this.unused(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject unused(ThreadContext context) {
        byte[] tmp = this.io.getAvailIn();
        return tmp == null ? context.nil : Create.newString(context, new ByteList(tmp));
    }

    @Override
    @JRubyMethod
    public IRubyObject crc(ThreadContext context) {
        long crc2 = 0L;
        try {
            crc2 = this.io.getCRC();
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        return Convert.asFixnum(context, crc2);
    }

    @Override
    @JRubyMethod
    public IRubyObject os_code(ThreadContext context) {
        int os = this.io.getOS();
        if (os == 255) {
            os = 11;
        }
        return Convert.asFixnum(context, os & 0xFF);
    }

    @Override
    @JRubyMethod
    public IRubyObject orig_name(ThreadContext context) {
        String name2 = this.io.getName();
        this.nullFreeOrigName = Create.newString(context, name2);
        return super.orig_name(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject comment(ThreadContext context) {
        String comment2 = this.io.getComment();
        this.nullFreeComment = Create.newString(context, comment2);
        return super.comment(context);
    }

    @JRubyMethod(optional=1, checkArity=false)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", args2);
        }
        ByteList sep = ((RubyString)Access.globalVariables(context).get("$/")).getByteList();
        if (argc > 0 && !args2[0].isNil()) {
            sep = args2[0].convertToString().getByteList();
        }
        try {
            IRubyObject result2 = this.internalSepGets(context, sep);
            while (!result2.isNil()) {
                block.yield(context, result2);
                result2 = this.internalSepGets(context, sep);
            }
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
        }
        return this.each(context, args2, block);
    }

    @JRubyMethod
    public IRubyObject ungetc(ThreadContext context, IRubyObject cArg) {
        RubyString rubyString;
        if (cArg.isNil()) {
            return context.nil;
        }
        if (cArg instanceof RubyInteger) {
            RubyInteger cint = (RubyInteger)cArg;
            rubyString = EncodingUtils.encUintChr(context, cint.asInt(context), this.getReadEncoding(context));
        } else {
            rubyString = cArg.convertToString();
        }
        RubyString c = rubyString;
        try {
            byte[] bytes2 = c.getBytes();
            this.bufferedStream.unread(bytes2);
            this.position -= (long)bytes2.length;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject ungetbyte(IRubyObject b2) {
        return this.ungetbyte(this.getCurrentContext(), b2);
    }

    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext context, IRubyObject b2) {
        if (b2.isNil()) {
            return b2;
        }
        try {
            this.bufferedStream.unread(Convert.toInt(context, b2));
            --this.position;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public IRubyObject readlines(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        ArrayList<IRubyObject> array2 = new ArrayList<IRubyObject>();
        if (argc != 0 && args2[0].isNil()) {
            array2.add(this.read(context, IRubyObject.NULL_ARRAY));
        } else {
            ByteList sep = ((RubyString)Access.globalVariables(context).get("$/")).getByteList();
            if (argc > 0) {
                sep = args2[0].convertToString().getByteList();
            }
            try {
                IRubyObject result2 = this.internalSepGets(context, sep);
                while (!result2.isNil()) {
                    array2.add(result2);
                    result2 = this.internalSepGets(context, sep);
                }
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
        }
        return Create.newArray(context, array2);
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        try {
            int value2 = this.bufferedStream.read();
            while (value2 != -1) {
                ++this.position;
                block.yield(context, Convert.asFixnum(context, value2));
                value2 = this.bufferedStream.read();
            }
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "each_char");
        }
        try {
            int value2 = this.bufferedStream.read();
            while (value2 != -1) {
                ++this.position;
                block.yield(context, runtime2.newString(String.valueOf((char)(value2 & 0xFF))));
                value2 = this.bufferedStream.read();
            }
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject zcat(ThreadContext context, IRubyObject klass, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        RubyString buf = null;
        IRubyObject io2 = args2[0];
        try {
            long pos2;
            do {
                JZlibRubyGzipReader obj = (JZlibRubyGzipReader)((RubyClass)klass).newInstance(context, args2, block);
                if (block.isGiven()) {
                    obj.each(context, IRubyObject.NULL_ARRAY, block);
                } else {
                    if (buf == null) {
                        buf = Create.newEmptyString(context);
                    }
                    RubyString tmpbuf = obj.readAll(context);
                    buf.cat(tmpbuf);
                }
                obj.read(context, IRubyObject.NULL_ARRAY);
                pos2 = Convert.toLong(context, io2.callMethod(context, "pos"));
                IRubyObject unused2 = obj.unused();
                obj.finish(context);
                if (unused2.isNil()) continue;
                io2.callMethod(context, "pos=", Convert.asFixnum(context, pos2 -= Convert.toLong(context, unused2.callMethod(context, "length"))));
            } while (pos2 < Convert.toLong(context, io2.callMethod(context, "size")));
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return block.isGiven() ? context.nil : buf;
    }

    private void fixBrokenTrailingCharacter(ThreadContext context, ByteList result2) throws IOException {
        int read2;
        int extraBytes = StringSupport.bytesToFixBrokenTrailingCharacter(result2.getUnsafeBytes(), result2.getBegin(), result2.getRealSize(), this.getReadEncoding(context), result2.length());
        for (int i2 = 0; i2 < extraBytes && (read2 = this.bufferedStream.read()) != -1; ++i2) {
            result2.append(read2);
        }
    }

    @JRubyClass(name={"Zlib::GzipReader::Error"}, parent="Zlib::GzipReader")
    public static class Error {
    }
}

